#version 450 compatibility

//out vec2 texcoord;

flat out vec3 colorSunlight;
flat out vec3 colorSkylight;


#include "/lib/Head/Common.inc"

uniform float nightVision;
uniform float wetness;
uniform float isLightningFlashing;
uniform float BiomeGreenShift;

uniform vec3 worldSunVector;
uniform vec3 worldLightVector;

uniform int moonPhase;

uniform vec2 screenPixelSize;

#include "/lib/Atmosphere/Atmosphere.glsl"

void main() {
	gl_Position = vec4(gl_Vertex.xy * (2.0 / TEMPORAL_UPSCALING) - 1.0, 0.0, 1.0);
	//texcoord = gl_Vertex.xy;

	colorSunlight = GetColorSunlight(worldSunVector);
	colorSkylight = SkyShading(vec3(0.0, 1.0, 0.0)) * oneMinus(BiomeGreenShift * 0.5);
	colorSkylight += maxOf(colorSkylight) * vec3(0.3, 1.0, 0.24) * BiomeGreenShift;
}
