
//const float PHI = sqrt(5.0) * 0.5 + 0.5;

// float GetSSAO(in vec3 origin, in vec3 normal, in float dither) {
// 	float aoAccum = 0.0;

// 	float radius = 0.3 * -origin.z;
// 		  radius = radius * 0.5 + 0.4;
// 	float zThickness = radius + 0.1;

// 	for (uint i = 0u; i < SSAO_SAMPLES; ++i) {
// 		float fi = float(i) + dither;
// 		float fiN = fi * rcp(SSAO_SAMPLES);
// 		float lon = goldenAngle * fi * 6.0;
// 		float lat = asin(fma(fiN, 2.0, -1.0));

// 		vec3 kernel;
// 		kernel.x = cos(lat) * cos(lon);
// 		kernel.z = cos(lat) * sin(lon);
// 		kernel.y = sin(lat);
// 		kernel = normalize(kernel + normal);

// 		float sampleLength = radius * mod(fiN, 0.02f) * 50.0;
// 		vec3 samplePos = fma(vec3(sampleLength), kernel, origin);
// 		float depthDiff = -ScreenToViewSpace(GetDepth(ViewToScreenSpaceRaw(samplePos).xy)) - samplePos.z;

// 		if (depthDiff > 0.0 && depthDiff < zThickness) {
// 			vec3 sampleVector = normalize(samplePos - origin);
// 			aoAccum += 1.4 * saturate(dot(sampleVector, normal));
// 		}
// 	}

// 	float ao = max0(1.0 - aoAccum * rcp(SSAO_SAMPLES));

// 	return pow(ao, 1.7);
// }

/*
    SSAO based on BSL Shaders by Capt Tatsu with permission
*/

float depthLinear(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));
}

vec2 offsetDist(float x) {
    return cossin(fract(x * 8.0) * PI) * x;
}

float GetDSSAO(vec3 sceneNormal, float depth, vec2 coord, float dither) {
    depth = depthLinear(depth);

    float radius = sqrt(2.0) * (0.75 + abs(1.0 - sceneNormal.y) * 0.5) * 0.5;

    float currStep  = 0.2 * dither + 0.2;
	float fovScale  = gbufferProjection[1][1] * 0.729927007299;
	float distScale = max((far - near) * depth + near, 5.0);
	vec2 scale      = radius * vec2(1.0 / aspectRatio, 1.0) * fovScale / distScale;

    float ao = 0.0;

    const float anibleedExp = 0.71;

    for (uint i = 0u; i < SSAO_SAMPLES; ++i) {
		vec2 offset = offsetDist(currStep) * scale;
		float mult  = (0.7 / radius) * (far - near);

		float sampleDepth = depthLinear(texture(depthtex0, coord + offset).x);
		float sample0 = (depth - sampleDepth) * mult;
        float antiBleed = rcp(1.0 + max0(distance(sampleDepth, depth) * far - TAU) * anibleedExp);
		float angle = mix(0.5, saturate(0.5 - sample0), antiBleed);
		float dist  = mix(0.5, saturate(0.25 * sample0 - 1.0), antiBleed);

		sampleDepth = depthLinear(texture(depthtex0, coord - offset).x);
		sample0     = (depth - sampleDepth) * mult;
        antiBleed   = rcp(1.0 + max0(distance(sampleDepth, depth) * far - TAU) * anibleedExp);
        angle      += mix(0.5, saturate(0.5 - sample0), antiBleed);
        dist       += mix(0.5, saturate(0.25 * sample0 - 1.0), antiBleed);
	
		ao         += saturate(angle + dist);
		currStep   += 0.2;
    }

	ao *= 1.0 / SSAO_SAMPLES;
	return ao// * sqrt(ao)
	;
}
