
uniform float blindness;
uniform float darknessFactor;

void CommonFog(inout vec3 color, in float dist) {
	if (blindness + darknessFactor > 0.0) color *= expf(-dist * max(blindness, darknessFactor));

	if (isEyeInWater == 2) color = mix(color, vec3(3.96, 0.68, 0.02), saturate(dist));

	if (isEyeInWater == 3) {
		#if defined IS_OVERWORLD
			vec3 fogColor = colorSkylight + colorSunlight * 1.5;
			fogColor = 6.0 * mix(fogColor, colorSunlight * 0.6, wetnessCustom * 0.8);
		#else
			vec3 fogColor = vec3(1.76, 1.92, 2.0);
		#endif

		color = mix(fogColor * eyeSkylightFix, color, exp2(-dist * 2.0));
	}
}

/*
#ifdef IS_END
	void EndFog(inout vec3 color, in vec3 viewPos, MaterialMask mask)
	{
		float dist = length(viewPos);

		float fogDensity = 0.02;
	#if MC_VERSION >= 11700
		fogDensity -= mask.sky * 0.018;
	#else
		fogDensity -= mask.sky * 0.015;
	#endif
		float fogFactor = sqr(1.0 - expf(-dist * fogDensity));
		
		vec3 fogColor = vec3(0.1, 0.03, 0.13) * 0.2;

		color = mix(color, fogColor, vec3(fogFactor));
	}
#endif
*/

#if defined IS_NETHER
	//uniform vec3 fogColor;
	uniform float BiomeNetherWastesSmooth;
	uniform float BiomeWarpedForestSmooth;
	uniform float BiomeCrimsonForestSmooth;
	uniform float BiomeSoulSandValleySmooth;
	uniform float BiomeBasaltDeltasSmooth;

	vec3 NetherFogColor() {
		return vec3(0.99, 0.23, 0.03) 	* BiomeNetherWastesSmooth
			 + vec3(0.04, 0.24, 0.2) 	* BiomeWarpedForestSmooth
			 + vec3(0.3, 0.03, 0.01) 	* BiomeCrimsonForestSmooth
			 + vec3(0.012, 0.055, 0.06) * BiomeSoulSandValleySmooth
			 + vec3(0.5) 				* BiomeBasaltDeltasSmooth;
	}

	void NetherFog(inout vec3 color, in float dist) {
		//dist = min(dist, far * 1.2);

		float fogFactor = sqr(1.0 - expf(-dist * 0.01));		
		//color = mix(color, GammaToLinear(fogColor), vec3(fogFactor));
		color = mix(color, NetherFogColor() * 0.5, fogFactor);
	}
#endif

void TransparentAbsorption(inout vec3 color, in vec4 stainedGlassAlbedo) {
	vec3 stainedGlassColor = normalize(stainedGlassAlbedo.rgb + 1e-6) * pow(dotSelf(stainedGlassAlbedo.rgb), GLASS_TEXTURE_ALPHA * 0.25);

	color *= pow4(mix(vec3(1.0), stainedGlassColor, pow(stainedGlassAlbedo.a, 0.2 * GLASS_TEXTURE_ALPHA)));
}
