/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.client.gui;

import dev.ftb.mods.ftbfiltersystem.api.FTBFilterSystemAPI;
import dev.ftb.mods.ftbfiltersystem.api.client.Textures;
import dev.ftb.mods.ftbfiltersystem.api.client.gui.AbstractFilterScreen;
import dev.ftb.mods.ftbfiltersystem.api.filter.AbstractCompoundFilter;
import dev.ftb.mods.ftbfiltersystem.api.filter.DumpedFilter;
import dev.ftb.mods.ftbfiltersystem.api.filter.SmartFilter;
import dev.ftb.mods.ftbfiltersystem.client.FTBFilterSystemClient;
import dev.ftb.mods.ftbfiltersystem.client.GuiUtil;
import dev.ftb.mods.ftbfiltersystem.client.SelectionPanel;
import dev.ftb.mods.ftbfiltersystem.network.SyncFilterMessage;
import dev.ftb.mods.ftbfiltersystem.registry.item.SmartFilterItem;
import dev.ftb.mods.ftbfiltersystem.util.FilterParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import org.jetbrains.annotations.Nullable;

public class FilterScreen
extends AbstractFilterScreen {
    private static SelectionPanel selectionPanel = null;
    private final SmartFilter filter;
    private final String origFilterStr;
    private final InteractionHand interactionHand;
    private int leftPos;
    private int topPos;
    private int guiWidth;
    private int guiHeight;
    private FilterList filterList;
    private Button addFilterBtn;
    private Button deleteFilterBtn;
    private Button configFilterBtn;
    private Button titleEditBtn;
    private EditBox titleEditBox;
    private SmartFilter newSelection = null;
    private Component newTitle = null;
    private boolean showingTitleEdit = false;

    public FilterScreen(Component component, SmartFilter filter, InteractionHand interactionHand) {
        super(component);
        this.interactionHand = interactionHand;
        selectionPanel = null;
        this.filter = filter;
        this.origFilterStr = filter.toString();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.setupGuiDimensions();
        this.getSelectionPanel().visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_7787_((GuiEventListener)x$0);
        });
        this.filterList = new FilterList(this.f_96541_, this.getListWidth(), this.getListHeight(), this.topPos + 20, this.topPos + 20 + this.getListHeight());
        this.filterList.m_93507_(this.leftPos + 8);
        this.filterList.m_93488_(false);
        this.filterList.m_93496_(false);
        this.m_7787_((GuiEventListener)this.filterList);
        this.titleEditBtn = (Button)this.m_142416_((GuiEventListener)new ImageButton(this.leftPos, this.topPos + 3, 16, 16, 0, 0, 0, Textures.EDIT_BUTTON, 16, 16, b -> {
            this.showingTitleEdit = true;
        }));
        int n = this.getListWidth();
        Objects.requireNonNull(this.f_96547_);
        this.titleEditBox = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.leftPos + 5, this.topPos + 4, n, 9 + 4, (Component)Component.m_237119_()));
        this.titleEditBox.f_93624_ = false;
        this.titleEditBox.m_94144_(this.f_96539_.getString());
        int buttonWidth = this.guiWidth - this.getListWidth() - 25;
        LinearLayout buttonPanel = new LinearLayout(this.leftPos + this.getListWidth() + 15, this.topPos + 20, buttonWidth, 70, LinearLayout.Orientation.VERTICAL);
        this.addFilterBtn = (Button)buttonPanel.m_264406_((LayoutElement)Button.m_253074_((Component)Component.m_237115_((String)"ftbfiltersystem.gui.add"), b -> this.getSelectionPanel().setVisible(true)).m_252780_(buttonWidth).m_253136_());
        this.deleteFilterBtn = (Button)buttonPanel.m_264406_((LayoutElement)Button.m_253074_((Component)Component.m_237115_((String)"ftbfiltersystem.gui.delete"), b -> this.deleteSelectedFilter(true)).m_252780_(buttonWidth).m_253136_());
        this.configFilterBtn = (Button)buttonPanel.m_264406_((LayoutElement)Button.m_253074_((Component)Component.m_237115_((String)"ftbfiltersystem.gui.configure"), b -> this.configureSelectedFilter(false)).m_252780_(buttonWidth).m_253136_());
        buttonPanel.m_264036_();
        buttonPanel.m_264134_(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
        LinearLayout bottomPanel = new LinearLayout(this.leftPos, this.topPos + this.guiHeight - 25, this.guiWidth, 20, LinearLayout.Orientation.HORIZONTAL);
        ((FrameLayout)bottomPanel.m_264406_((LayoutElement)new FrameLayout(this.guiWidth / 2, 20))).m_264557_((LayoutElement)Button.m_253074_((Component)CommonComponents.f_130655_, b -> this.applyChanges()).m_253046_(80, 20).m_253136_());
        ((FrameLayout)bottomPanel.m_264406_((LayoutElement)new FrameLayout(this.guiWidth / 2, 20))).m_264557_((LayoutElement)Button.m_253074_((Component)CommonComponents.f_130656_, b -> this.closeWithConfirmation()).m_253046_(80, 20).m_253136_());
        bottomPanel.m_264036_();
        bottomPanel.m_264134_(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
        if (this.filterList.m_93511_() == null) {
            this.findAndSelect(this.filter);
        } else {
            this.setupButtons();
        }
    }

    private void applyNewTitle() {
        this.newTitle = Component.m_237113_((String)this.titleEditBox.m_94155_());
        if (this.newTitle.getString().equals(this.f_96539_.getString())) {
            this.newTitle = null;
        }
        this.showingTitleEdit = false;
    }

    private SelectionPanel getSelectionPanel() {
        if (selectionPanel == null) {
            selectionPanel = new SelectionPanel(this.f_96547_, this::createNewFilter, this.f_96544_ - (this.topPos + 20) - 5);
        }
        return selectionPanel;
    }

    private void setupButtons() {
        FilterList.FilterEntry selected = (FilterList.FilterEntry)this.filterList.m_93511_();
        this.addFilterBtn.f_93623_ = selected != null && this.canAddMoreFilters(selected.dumpedFilter.filter());
        this.deleteFilterBtn.f_93623_ = selected != null && selected.dumpedFilter.filter().getParent() != null;
        this.configFilterBtn.f_93623_ = selected != null && selected.dumpedFilter.filter().isConfigurable();
    }

    private boolean canAddMoreFilters(SmartFilter filter) {
        SmartFilter.Compound compound;
        if (filter instanceof AbstractCompoundFilter) {
            AbstractCompoundFilter acf = (AbstractCompoundFilter)filter;
            compound = acf;
        } else {
            compound = filter.getParent();
        }
        SmartFilter.Compound parent = compound;
        return parent != null && parent.getChildren().size() < parent.maxChildren();
    }

    private void applyChanges() {
        new SyncFilterMessage(this.filter.toString(), this.newTitle == null ? null : this.newTitle.getString(), this.interactionHand).sendToServer();
        this.m_7379_();
        if (this.changesHaveBeenMade()) {
            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"ftbfiltersystem.message.changes_saved").m_130940_(ChatFormatting.GREEN), true);
        }
    }

    private boolean changesHaveBeenMade() {
        return !this.filter.toString().equals(this.origFilterStr) || this.newTitle != null;
    }

    private void createNewFilter(ResourceLocation filterId) {
        this.getSelectionPanel().setVisible(false);
        if (this.filterList.m_93511_() != null) {
            SmartFilter.Compound parent;
            SmartFilter selectedFilter = ((FilterList.FilterEntry)this.filterList.m_93511_()).dumpedFilter.filter();
            if (selectedFilter instanceof AbstractCompoundFilter) {
                AbstractCompoundFilter acf = (AbstractCompoundFilter)selectedFilter;
                v0 = acf;
            } else {
                v0 = parent = selectedFilter.getParent();
            }
            if (parent != null) {
                FTBFilterSystemAPI.api().createDefaultFilter(parent, filterId).ifPresent(newFilter -> {
                    parent.getChildren().add((SmartFilter)newFilter);
                    this.filterList.addChildren();
                    this.filterList.findAndSelect((SmartFilter)newFilter);
                    this.configureSelectedFilter(true);
                });
            }
        }
    }

    @Override
    public void deleteSelectedFilter(boolean rebuildList) {
        SmartFilter subFilter;
        SmartFilter.Compound parent;
        if (this.filterList.m_93511_() != null && (parent = (subFilter = ((FilterList.FilterEntry)this.filterList.m_93511_()).dumpedFilter.filter()).getParent()) instanceof SmartFilter.Compound) {
            SmartFilter.Compound compound = parent;
            List<SmartFilter> l = compound.getChildren().stream().filter(f -> f != subFilter).toList();
            compound.getChildren().clear();
            compound.getChildren().addAll(l);
            if (rebuildList) {
                this.filterList.addChildren();
                this.filterList.findAndSelect(parent);
            }
        }
    }

    private void configureSelectedFilter(boolean deleteOnCancel) {
        FilterList.FilterEntry selected = (FilterList.FilterEntry)this.filterList.m_93511_();
        if (selected != null) {
            FTBFilterSystemClient.INSTANCE.openFilterConfigScreen(selected.dumpedFilter.filter(), this, deleteOnCancel);
        }
    }

    @Override
    public <T extends SmartFilter> void replaceFilter(T filter, T newFilter) {
        List<SmartFilter> children;
        int idx;
        if (filter.getParent() != null && (idx = (children = filter.getParent().getChildren()).indexOf(filter)) >= 0) {
            children.set(idx, newFilter);
            this.newSelection = newFilter;
        }
    }

    public void m_86600_() {
        if (!(this.f_96541_.f_91074_.m_21120_(this.interactionHand).m_41720_() instanceof SmartFilterItem)) {
            this.m_7379_();
        } else if (this.showingTitleEdit && !this.titleEditBox.m_94213_()) {
            this.titleEditBox.f_93624_ = true;
            this.titleEditBtn.f_93624_ = false;
            if (Screen.m_96638_()) {
                this.titleEditBox.m_94201_();
                this.titleEditBox.m_94208_(0);
            }
            this.m_7522_((GuiEventListener)this.titleEditBox);
        } else if (!this.showingTitleEdit && this.titleEditBox.m_94213_()) {
            this.titleEditBox.f_93624_ = false;
            this.titleEditBtn.f_93624_ = true;
            this.m_7522_((GuiEventListener)this.filterList);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        if (this.guiHeight > 0) {
            guiGraphics.m_280260_(Textures.BACKGROUND, this.leftPos, this.topPos, this.guiWidth, this.guiHeight, 4, 32, 32, 0, 0);
            GuiUtil.drawPanel(guiGraphics, new Rect2i(this.leftPos + 7, this.topPos + 20, this.getListWidth() + 2, this.getListHeight()), -6250336, -6250336, GuiUtil.BorderStyle.INSET, 1);
            Component displayTitle = this.newTitle == null ? this.f_96539_ : this.newTitle;
            guiGraphics.m_280614_(this.f_96547_, displayTitle, this.leftPos + 8, this.topPos + 7, 0x404040, false);
            this.titleEditBtn.m_252865_(this.leftPos + this.f_96547_.m_92852_((FormattedText)displayTitle) + 8);
            this.filterList.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        if (this.getSelectionPanel().isVisible()) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
            guiGraphics.m_280509_(this.leftPos, this.topPos, this.leftPos + this.guiWidth, this.topPos + this.guiHeight, -1608507360);
            this.getSelectionPanel().positionAndRender(guiGraphics, this.addFilterBtn.m_252907_(), this.addFilterBtn.m_252754_() - 10, mouseX, mouseY, partialTick);
            guiGraphics.m_280168_().m_85849_();
        }
    }

    public void m_7379_() {
        this.getSelectionPanel().setVisible(false);
        super.m_7379_();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifier) {
        if (keyCode == 256 || this.f_96541_.f_91066_.f_92092_.m_90832_(keyCode, scanCode)) {
            if (this.getSelectionPanel().isVisible()) {
                this.getSelectionPanel().setVisible(false);
                return true;
            }
            if (this.titleEditBox.m_94204_()) {
                if (keyCode == 256) {
                    this.titleEditBox.m_94144_(this.newTitle == null ? this.f_96539_.getString() : this.newTitle.getString());
                    this.showingTitleEdit = false;
                } else {
                    this.titleEditBox.m_7933_(keyCode, scanCode, modifier);
                }
                return true;
            }
            this.closeWithConfirmation();
            return true;
        }
        if (keyCode == 257 || keyCode == 335) {
            if (this.titleEditBox.m_94204_()) {
                this.applyNewTitle();
                return true;
            }
            if (Screen.m_96638_()) {
                this.applyChanges();
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifier);
    }

    private void closeWithConfirmation() {
        if (this.changesHaveBeenMade()) {
            this.newSelection = this.filterList.getSelectedFilter();
            this.f_96541_.m_91152_((Screen)new ConfirmScreen(this::exitCallback, (Component)Component.m_237115_((String)"ftbfiltersystem.gui.changes_made"), (Component)Component.m_237115_((String)"ftbfiltersystem.gui.changes_made.question")));
        } else {
            this.m_7379_();
        }
    }

    private void exitCallback(boolean confirmed) {
        if (confirmed) {
            this.m_7379_();
        } else {
            this.f_96541_.m_91152_((Screen)this);
            this.findAndSelect(this.newSelection);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.getSelectionPanel().isVisible() && !this.getSelectionPanel().isMouseOver(mouseX, mouseY)) {
            this.getSelectionPanel().setVisible(false);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private int getListWidth() {
        return this.guiWidth - 100;
    }

    private int getListHeight() {
        return this.guiHeight - 50;
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        this.f_96543_ = width;
        this.f_96544_ = height;
        this.setupGuiDimensions();
        SmartFilter selected = this.filterList.m_93511_() == null ? null : ((FilterList.FilterEntry)this.filterList.m_93511_()).dumpedFilter.filter();
        this.m_267719_();
        this.getSelectionPanel().resize(height - (this.topPos + 20) - 5);
        this.findAndSelect(selected);
    }

    private void setupGuiDimensions() {
        this.guiWidth = this.f_96543_ * 2 / 3;
        this.guiHeight = this.f_96544_ * 3 / 4;
        this.leftPos = (this.f_96543_ - this.guiWidth) / 2;
        this.topPos = (this.f_96544_ - this.guiHeight) / 2;
    }

    @Override
    public void findAndSelect(@Nullable SmartFilter filter) {
        if (filter != null) {
            this.filterList.findAndSelect(filter);
        }
    }

    private class FilterList
    extends ObjectSelectionList<FilterEntry> {
        private static final int ELEMENT_HEIGHT = 12;
        private FilterEntry dragging;
        private SmartFilter.Compound dragTarget;

        public FilterList(Minecraft minecraft, int width, int height, int top, int bottom) {
            super(minecraft, width, height, top, bottom, 12);
            this.dragging = null;
            this.dragTarget = null;
            this.addChildren();
        }

        private void addChildren() {
            ArrayList entries = new ArrayList();
            List<DumpedFilter> dumped = FTBFilterSystemAPI.api().dump(FilterScreen.this.filter);
            dumped.forEach(entry -> entries.add(new FilterEntry((DumpedFilter)entry)));
            this.m_6702_().clear();
            this.m_6702_().addAll(entries);
            if (FilterScreen.this.newSelection != null) {
                this.findAndSelect(FilterScreen.this.newSelection);
                FilterScreen.this.newSelection = null;
            }
        }

        private SmartFilter getSelectedFilter() {
            return this.m_93511_() == null ? null : ((FilterEntry)this.m_93511_()).dumpedFilter.filter();
        }

        public int m_5759_() {
            return FilterScreen.this.getListWidth();
        }

        protected int m_5756_() {
            return FilterScreen.this.leftPos + this.f_93388_ + 8;
        }

        public void m_142291_(NarrationElementOutput narrationElementOutput) {
        }

        public void setSelected(@Nullable FilterEntry entry) {
            super.m_6987_((AbstractSelectionList.Entry)entry);
            FilterScreen.this.setupButtons();
        }

        public boolean m_6348_(double mouseX, double mouseY, int btn) {
            if (this.dragging != null && this.dragTarget != null) {
                FilterParser.parseFilterList(this.dragTarget, this.dragging.dumpedFilter.filter().toString()).stream().findFirst().ifPresent(newFilter -> {
                    this.dragTarget.getChildren().add((SmartFilter)newFilter);
                    FilterScreen.this.deleteSelectedFilter(false);
                    this.addChildren();
                    this.findAndSelect((SmartFilter)newFilter);
                });
            }
            this.dragging = null;
            this.dragTarget = null;
            return super.m_6348_(mouseX, mouseY, btn);
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
            SmartFilter smartFilter;
            if (this.dragging == null) return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
            FilterEntry entry = (FilterEntry)this.m_93412_(pMouseX, pMouseY);
            if (entry != null && (smartFilter = entry.dumpedFilter.filter()) instanceof SmartFilter.Compound) {
                SmartFilter.Compound compound = (SmartFilter.Compound)smartFilter;
                if (!(this.dragging.dumpedFilter.filter() instanceof SmartFilter.Compound && entry.dumpedFilter.indent() > this.dragging.dumpedFilter.indent() || compound == this.dragging.dumpedFilter.filter() || compound == this.dragging.dumpedFilter.filter().getParent() || compound.getChildren().size() >= compound.maxChildren())) {
                    this.dragTarget = compound;
                    return true;
                }
            }
            this.dragTarget = null;
            return true;
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            if (keyCode == 32 || keyCode == 257) {
                FilterScreen.this.configureSelectedFilter(false);
                return true;
            }
            return super.m_7933_(keyCode, scanCode, modifiers);
        }

        protected void m_7154_(GuiGraphics guiGraphics, int pMouseX, int pMouseY) {
            FilterEntry entry;
            if (this.dragging != null && (entry = (FilterEntry)this.m_93412_(pMouseX, pMouseY)) != null && entry.dumpedFilter.filter() != this.dragging.dumpedFilter.filter()) {
                int w = FilterScreen.this.f_96547_.m_92852_((FormattedText)this.dragging.dumpedFilter.filter().getDisplayName());
                guiGraphics.m_280509_(pMouseX, pMouseY - 6 + 1, pMouseX + w + 10, pMouseY + 6, -1058934275);
                guiGraphics.m_280637_(pMouseX, pMouseY - 6 + 1, w + 10, 12, -1069531072);
                guiGraphics.m_280614_(FilterScreen.this.f_96547_, this.dragging.dumpedFilter.filter().getDisplayName(), pMouseX + 5, pMouseY - 6 + 3, -1069531072, false);
            }
        }

        protected void m_240140_(GuiGraphics guiGraphics, int pTop, int pWidth, int pHeight, int pOuterColor, int pInnerColor) {
            int minX = this.f_93393_ + (this.f_93388_ - pWidth) / 2;
            int maxX = this.f_93393_ + (this.f_93388_ + pWidth) / 2;
            int col = this.m_93696_() ? -1969667 : -5851964;
            GuiUtil.drawPanel(guiGraphics, new Rect2i(minX + 1, pTop - 2, maxX - minX - 2, pHeight + 3), col, -12164180, GuiUtil.BorderStyle.PLAIN, 1);
        }

        private void findAndSelect(SmartFilter filter) {
            this.m_6702_().stream().filter(entry -> entry.dumpedFilter.filter() == filter).findFirst().ifPresent(this::setSelected);
        }

        private class FilterEntry
        extends ObjectSelectionList.Entry<FilterEntry> {
            private final DumpedFilter dumpedFilter;
            private long lastClickTime;

            public FilterEntry(DumpedFilter dumpedFilter) {
                this.dumpedFilter = dumpedFilter;
            }

            public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                int labelLeft = left + this.dumpedFilter.indent() * 10;
                int yBase = top + height / 2;
                if (this.dumpedFilter.filter() == FilterList.this.dragTarget && FilterList.this.dragging.dumpedFilter.filter() != FilterList.this.dragTarget) {
                    int n = labelLeft + FilterScreen.this.f_96547_.m_92852_((FormattedText)this.getLabel()) + 2;
                    Objects.requireNonNull(FilterScreen.this.f_96547_);
                    guiGraphics.m_280509_(labelLeft - 2, top - 3, n, top + 9, -3479106);
                    int n2 = FilterScreen.this.f_96547_.m_92852_((FormattedText)this.getLabel()) + 4;
                    Objects.requireNonNull(FilterScreen.this.f_96547_);
                    guiGraphics.m_280637_(labelLeft - 2, top - 3, n2, 9 + 4, -13604796);
                }
                guiGraphics.m_280614_(FilterScreen.this.f_96547_, this.getLabel(), labelLeft, top, 0x404040, false);
                if (index > 0) {
                    guiGraphics.m_280656_(labelLeft - 8, labelLeft - 2, yBase, -11513728);
                    int yOff = this.calcYoffset(index);
                    guiGraphics.m_280315_(labelLeft - 8, yBase, yBase - yOff, -11513728);
                }
            }

            private int calcYoffset(int index) {
                int res = 0;
                for (int i = index - 1; i >= 0; --i) {
                    res += FilterList.this.f_93387_;
                    if (((FilterEntry)((Object)FilterList.this.m_6702_().get((int)i))).dumpedFilter.indent() < this.dumpedFilter.indent()) break;
                }
                return res - 4;
            }

            public boolean m_6375_(double x, double y, int button) {
                FilterList.this.setSelected(this);
                if (this.dumpedFilter.filter().getParent() != null) {
                    FilterList.this.dragging = this;
                }
                if (Util.m_137550_() - this.lastClickTime < 250L) {
                    FilterScreen.this.configureSelectedFilter(false);
                } else {
                    this.lastClickTime = Util.m_137550_();
                }
                return true;
            }

            private Component getLabel() {
                Component disp = this.dumpedFilter.filter().getDisplayName();
                if (this.dumpedFilter.filter() instanceof SmartFilter.Compound) {
                    return disp;
                }
                Component text = this.dumpedFilter.filter().getDisplayArg();
                return disp.m_6881_().m_130946_(" ").m_7220_((Component)text.m_6881_().m_130940_(ChatFormatting.DARK_BLUE));
            }

            public Component m_142172_() {
                return Component.m_237110_((String)"narrator.select", (Object[])new Object[]{this.getLabel()});
            }
        }
    }
}

