/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.client;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class GuiUtil {
    public static void drawPanel(GuiGraphics graphics, Rect2i area, int bgColor, int borderColor, BorderStyle borderStyle, int borderWidth) {
        int xMax = area.m_110085_() + area.m_110090_();
        int yMax = area.m_110086_() + area.m_110091_();
        graphics.m_280509_(area.m_110085_(), area.m_110086_(), xMax, yMax, bgColor);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)(-borderWidth / 2), (float)(-borderWidth / 2), 0.0f);
        int brCol = borderStyle.bottomRight(bgColor, borderColor);
        graphics.m_280509_(area.m_110085_() + 1, yMax, xMax, yMax + borderWidth, brCol);
        graphics.m_280509_(xMax, area.m_110086_() + 1, xMax + borderWidth, yMax, brCol);
        int tlCol = borderStyle.topLeft(bgColor, borderColor);
        graphics.m_280509_(area.m_110085_(), area.m_110086_(), xMax, area.m_110086_() + borderWidth, tlCol);
        graphics.m_280509_(area.m_110085_(), area.m_110086_(), area.m_110085_() + borderWidth, yMax, tlCol);
        graphics.m_280168_().m_85849_();
    }

    public static int brighten(int color, float factor) {
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int i = (int)(1.0 / (1.0 - (double)factor));
        if (r == 0 && g == 0 && b == 0) {
            return GuiUtil.makeRGB(a, i, i, i);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return GuiUtil.makeRGB(a, Math.min((int)((float)r / factor), 255), Math.min((int)((float)g / factor), 255), Math.min((int)((float)b / factor), 255));
    }

    public static int darken(int color, float factor) {
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        return GuiUtil.makeRGB(a, Math.max((int)((float)r * factor), 0), Math.max((int)((float)g * factor), 0), Math.max((int)((float)b * factor), 0));
    }

    private static int makeRGB(int a, int r, int g, int b) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static ImageButton make16x16ImageButton(ResourceLocation texture, Button.OnPress onPress) {
        return new ImageButton(0, 0, 16, 16, 0, 0, 0, texture, 16, 16, onPress);
    }

    public static Rect2i outsetRect(Rect2i orig, int amount) {
        return new Rect2i(orig.m_110085_() - amount, orig.m_110086_() - amount, orig.m_110090_() + amount * 2, orig.m_110091_() + amount * 2);
    }

    public static FormattedText ellipsize(Font font, FormattedText text, int maxWidth) {
        int width = font.m_92852_(text);
        int eWidth = font.m_92852_((FormattedText)CommonComponents.f_238772_);
        if (width > maxWidth) {
            return eWidth >= maxWidth ? font.m_92854_(text, maxWidth) : FormattedText.m_130773_((FormattedText[])new FormattedText[]{font.m_92854_(text, maxWidth - eWidth), CommonComponents.f_238772_});
        }
        return text;
    }

    public static enum BorderStyle {
        NONE,
        PLAIN,
        OUTSET,
        INSET;


        public int topLeft(int bgColor, int borderColor) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NONE -> bgColor;
                case PLAIN -> borderColor;
                case OUTSET -> GuiUtil.brighten(borderColor, 0.7f);
                case INSET -> GuiUtil.darken(borderColor, 0.7f);
            };
        }

        public int bottomRight(int bgColor, int borderColor) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NONE -> bgColor;
                case PLAIN -> borderColor;
                case OUTSET -> GuiUtil.darken(borderColor, 0.7f);
                case INSET -> GuiUtil.brighten(borderColor, 0.7f);
            };
        }
    }
}

