/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.mcpack_tip;

import java.util.List;
import java.util.Objects;
import net.exmo.mcpack_tip.Config;
import net.exmo.mcpack_tip.DisplayContent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class TipScreen
extends Screen {
    private static final int MARGIN = 10;
    private static final int BUTTON_WIDTH = 40;
    private static final int BUTTON_HEIGHT = 20;
    private final List<DisplayContent> contents;
    private static final int TEXT_COLOR = -1;
    private int panelWidth;
    private int panelHeight;
    private int panelX;
    private int panelY;
    private int contentWidth;
    private int contentHeight;
    private int maxImageHeight;
    private Button nextPageButton;
    private Button prevPageButton;
    private int BUTTON_SIZE;
    private int currentPage;
    private static final int BUTTON_COLOR = Integer.MIN_VALUE;
    private static final int BUTTON_HOVER_COLOR = -1610612736;

    public TipScreen(Component title, List<DisplayContent> displayContents) {
        super(title);
        this.panelWidth = this.f_96543_;
        this.panelHeight = this.f_96544_ / 2;
        this.panelX = 0;
        this.panelY = (this.f_96544_ - this.panelHeight) / 2;
        this.maxImageHeight = 100;
        this.BUTTON_SIZE = 20;
        this.currentPage = 0;
        this.contents = displayContents;
    }

    public void m_280273_(GuiGraphics gui) {
    }

    private void renderCustomButton(GuiGraphics gui, Button button) {
        if (!button.f_93624_) {
            return;
        }
        int bgColor = button.f_93623_ ? (button.m_274382_() ? -12566464 : -14671840) : -15724528;
        gui.m_280509_(button.m_252754_(), button.m_252907_(), button.m_252754_() + button.m_5711_(), button.m_252907_() + button.m_93694_(), bgColor);
        int textColor = button.f_93623_ ? (button.m_274382_() ? -3936 : -2039584) : -8355712;
        gui.m_280653_(this.f_96547_, button.m_6035_(), button.m_252754_() + button.m_5711_() / 2, button.m_252907_() + (button.m_93694_() - 8) / 2, textColor);
    }

    private void nextPage() {
        if (this.currentPage < this.contents.size()) {
            ++this.currentPage;
        }
        this.updateButtonVisibility();
    }

    private void prevPage() {
        if (this.currentPage > 0) {
            --this.currentPage;
        }
        this.updateButtonVisibility();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.panelWidth = this.f_96543_;
        this.panelHeight = this.f_96544_;
        this.prevPageButton = new Button.Builder((Component)Component.m_237113_((String)"\u2190"), b -> this.prevPage()).m_252794_(10, this.f_96544_ - 20 - 10).m_253046_(40, 20).m_253136_();
        this.nextPageButton = new Button.Builder((Component)Component.m_237113_((String)"\u2192"), b -> this.nextPage()).m_252794_(this.f_96543_ - 40 - 10, this.f_96544_ - 20 - 10).m_253046_(40, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.prevPageButton);
        this.m_142416_((GuiEventListener)this.nextPageButton);
        this.updateButtonVisibility();
    }

    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float partialTick) {
        gui.m_280509_(0, 0, this.f_96543_, this.f_96544_, -1342177280);
        int panelY = this.f_96544_ / 4;
        int panelHeight = this.f_96544_ / 2;
        gui.m_280509_(0, panelY, this.f_96543_, panelY + panelHeight, Integer.MIN_VALUE);
        super.m_88315_(gui, mouseX, mouseY, partialTick);
        DisplayContent content = this.contents.get(this.currentPage);
        int contentStartY = panelY + 10;
        this.renderTextContent(gui, content, contentStartY);
        this.renderImageGrid(gui, content, contentStartY);
        String pageText = this.currentPage + 1 + "/" + this.contents.size();
        int textWidth = this.f_96547_.m_92895_(pageText);
        gui.m_280488_(this.f_96547_, pageText, (this.f_96543_ - textWidth) / 2, this.f_96544_ - 10 - 20, 0xFFFFFF);
        this.renderCustomButton(gui, this.nextPageButton);
        this.renderCustomButton(gui, this.prevPageButton);
    }

    private void renderTextContent(GuiGraphics gui, DisplayContent content, int startY) {
        int yOffset = startY;
        int textAreaWidth = this.f_96543_ - 20;
        int contentStartX = 10;
        for (String textRes : content.text()) {
            String text = this.loadTextContent(textRes);
            List lines = this.f_96547_.m_92865_().m_92432_(text, textAreaWidth, Style.f_131099_);
            gui.m_280168_().m_85836_();
            gui.m_280168_().m_85841_(1.25f, 1.25f, 1.0f);
            for (FormattedText line : lines) {
                gui.m_280488_(this.f_96547_, line.getString(), (int)((float)contentStartX / 1.25f), (int)((float)yOffset / 1.25f), -1);
                double d = yOffset;
                Objects.requireNonNull(this.f_96547_);
                yOffset = (int)(d + 9.0 * 1.25);
            }
            gui.m_280168_().m_85849_();
            yOffset += 15;
        }
    }

    private void renderButton(GuiGraphics gui, Button button, int color) {
        if (button.f_93624_) {
            gui.m_280509_(button.m_252754_(), button.m_252907_(), button.m_252754_() + button.m_5711_(), button.m_252907_() + button.m_93694_(), color);
            Component component = button.m_6035_();
            int n = button.m_252754_() + button.m_5711_() / 2 - this.f_96547_.m_92852_((FormattedText)button.m_6035_()) / 2;
            int n2 = button.m_252907_() + button.m_93694_() / 2;
            Objects.requireNonNull(this.f_96547_);
            gui.m_280430_(this.f_96547_, component, n, n2 - 9 / 2, -1);
        }
    }

    private void renderImageGrid(GuiGraphics gui, DisplayContent content, int startY) {
        List<ResourceLocation> images = content.image();
        if (images.isEmpty()) {
            return;
        }
        int contentStartX = 10;
        int gridWidth = this.f_96543_ - 20;
        int maxColumns = 3;
        int cellSize = Math.min(100, gridWidth / maxColumns);
        int columns = Math.min(maxColumns, gridWidth / cellSize);
        int xStart = contentStartX;
        int y = startY + (content.text().isEmpty() ? 0 : 30) - 10;
        int x = xStart;
        for (int i = 0; i < images.size(); ++i) {
            if (i % columns == 0 && i != 0) {
                y += cellSize + 10;
                x = xStart;
            }
            this.renderScaledImage(gui, images.get(i), x, y, cellSize, cellSize);
            x += cellSize + 10;
        }
    }

    private void renderScaledImage(GuiGraphics gui, ResourceLocation image, int x, int y, int maxWidth, int maxHeight) {
        try {
            ImageInfo size = this.getImageSize(image);
            float ratio = (float)size.width() / (float)size.height();
            int renderWidth = Math.min(maxWidth, (int)((float)maxHeight * ratio));
            int renderHeight = Math.min(maxHeight, (int)((float)maxWidth / ratio));
            gui.m_280163_(image, x + (maxWidth - renderWidth) / 2, y + (maxHeight - renderHeight) / 2, 0.0f, 0.0f, renderWidth, renderHeight, renderWidth, renderHeight);
        }
        catch (Exception e) {
            gui.m_280488_(this.f_96547_, "\u26a0", x, y, -65536);
        }
    }

    private void updateButtonVisibility() {
        this.prevPageButton.f_93624_ = this.currentPage > 0;
        this.nextPageButton.f_93624_ = true;
        if (this.currentPage > this.contents.size() - 1) {
            Config.IS_LOOK.set((Object)true);
            Minecraft.m_91087_().m_91152_((Screen)new InventoryScreen((Player)Minecraft.m_91087_().f_91074_));
        }
    }

    private String loadTextContent(String res) {
        return I18n.m_118938_((String)res, (Object[])new Object[0]);
    }

    private ImageInfo getImageSize(ResourceLocation image) {
        return new ImageInfo(100, 100);
    }

    record ImageInfo(int width, int height) {
    }
}

