/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.world.structure;

import com.aetherteam.aether.world.structure.AetherStructureTypes;
import com.aetherteam.aether.world.structurepiece.LargeAercloudChunk;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class LargeAercloudStructure
extends Structure {
    public static final Codec<LargeAercloudStructure> CODEC = RecordCodecBuilder.create(p_229075_ -> p_229075_.group((App)LargeAercloudStructure.m_226567_((RecordCodecBuilder.Instance)p_229075_), (App)BlockStateProvider.f_68747_.fieldOf("blocks").forGetter(structure -> structure.blocks), (App)Codec.INT.fieldOf("size").forGetter(structure -> structure.size), (App)Codec.INT.fieldOf("rangeY").forGetter(o -> o.rangeY)).apply((Applicative)p_229075_, LargeAercloudStructure::new));
    private final BlockStateProvider blocks;
    private final int size;
    private final int rangeY;

    public LargeAercloudStructure(Structure.StructureSettings settings, BlockStateProvider blocks, int size, int rangeY) {
        super(settings);
        this.blocks = blocks;
        this.size = size;
        this.rangeY = rangeY;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        return Structure.m_226585_((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, builder -> LargeAercloudStructure.generatePieces(builder, context, this.blocks, this.size, this.rangeY));
    }

    private static void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context, BlockStateProvider blocks, int size, int rangeY) {
        LinkedHashMap<ChunkPos, Set> chunks = new LinkedHashMap<ChunkPos, Set>();
        LinkedHashSet<BlockPos> positions = new LinkedHashSet<BlockPos>();
        WorldgenRandom random = context.f_226626_();
        boolean direction = random.m_188499_();
        int initialY = context.f_226629_().m_141937_() + context.f_226626_().m_188503_(rangeY);
        int x = context.f_226628_().m_45604_();
        int y = initialY;
        int z = context.f_226628_().m_45605_();
        int xTendency = random.m_188503_(3) - 1;
        int zTendency = random.m_188503_(3) - 1;
        for (int amount = 0; amount < 64; ++amount) {
            y += random.m_188503_(10) == 0 ? random.m_188503_(3) - 1 : 0;
            z += direction ? random.m_188503_(3) - 1 + zTendency : -(random.m_188503_(3) - 1 + zTendency);
            for (int x1 = x += random.m_188503_(3) - 1 + xTendency; x1 < x + random.m_188503_(4) + 3 * size; ++x1) {
                for (int y1 = y; y1 < y + random.m_188503_(1) + 2; ++y1) {
                    for (int z1 = z; z1 < z + random.m_188503_(4) + 3 * size; ++z1) {
                        BlockPos newPosition = new BlockPos(x1, y1, z1);
                        if (Math.abs(x1 - x) + Math.abs(y1 - y) + Math.abs(z1 - z) >= 4 * size + random.m_188503_(2)) continue;
                        positions.add(newPosition);
                        chunks.putIfAbsent(new ChunkPos(newPosition), new HashSet());
                    }
                }
            }
        }
        chunks.forEach((chunkPos, blockPosSet) -> {
            LinkedHashSet<BlockPos> withinChunk = new LinkedHashSet<BlockPos>(positions);
            withinChunk.removeIf(pos -> !new ChunkPos(pos).equals(chunkPos));
            blockPosSet.addAll(withinChunk);
        });
        int finalY = y;
        Direction orientation = Direction.Plane.HORIZONTAL.m_235690_((RandomSource)context.f_226626_());
        chunks.forEach((chunkPos, blockPosSet) -> {
            BoundingBox boundingBox = new BoundingBox(chunkPos.m_45604_(), Math.max(initialY - 16, 0), chunkPos.m_45605_(), chunkPos.m_45608_(), finalY + 16, chunkPos.m_45609_());
            builder.m_142679_((StructurePiece)new LargeAercloudChunk((Set<BlockPos>)blockPosSet, blocks, boundingBox, orientation));
        });
    }

    public StructureType<?> m_213658_() {
        return (StructureType)AetherStructureTypes.LARGE_AERCLOUD.get();
    }
}

