/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.recipe.builder;

import com.aetherteam.aether.recipe.recipes.item.IncubationRecipe;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class IncubationBuilder
implements RecipeBuilder {
    private final Ingredient ingredient;
    private final EntityType<?> entity;
    @Nullable
    private final CompoundTag tag;
    private final int incubationTime;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    @Nullable
    private String group;
    private final RecipeSerializer<IncubationRecipe> serializer;

    public IncubationBuilder(Ingredient ingredient, EntityType<?> entity, @Nullable CompoundTag tag, int incubationTime, RecipeSerializer<IncubationRecipe> serializer) {
        this.ingredient = ingredient;
        this.entity = entity;
        this.tag = tag;
        this.incubationTime = incubationTime;
        this.serializer = serializer;
    }

    public static IncubationBuilder incubation(Ingredient ingredient, EntityType<?> entity, CompoundTag tag, int incubationTime, RecipeSerializer<IncubationRecipe> serializer) {
        return new IncubationBuilder(ingredient, entity, tag, incubationTime, serializer);
    }

    public IncubationBuilder group(@Nullable String group) {
        this.group = group;
        return this;
    }

    public Item m_142372_() {
        return Items.f_41852_;
    }

    public IncubationBuilder unlockedBy(String criterionName, CriterionTriggerInstance criterionTrigger) {
        this.advancement.m_138386_(criterionName, criterionTrigger);
        return this;
    }

    public void m_126140_(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        this.ensureValid(id);
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        consumer.accept(new Result(id, this.group == null ? "" : this.group, this.ingredient, this.entity, this.tag, this.incubationTime, this.advancement, new ResourceLocation(id.m_135827_(), "recipes/incubation/" + id.m_135815_()), this.serializer));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final Ingredient ingredient;
        private final EntityType<?> entity;
        @Nullable
        private final CompoundTag tag;
        private final int incubationTime;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;
        private final RecipeSerializer<IncubationRecipe> serializer;

        public Result(ResourceLocation id, String group, Ingredient ingredient, EntityType<?> entity, @Nullable CompoundTag tag, int incubationTime, Advancement.Builder advancement, ResourceLocation advancementId, RecipeSerializer<IncubationRecipe> serializer) {
            this.id = id;
            this.group = group;
            this.ingredient = ingredient;
            this.entity = entity;
            this.tag = tag;
            this.incubationTime = incubationTime;
            this.advancement = advancement;
            this.advancementId = advancementId;
            this.serializer = serializer;
        }

        public void m_7917_(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.add("ingredient", this.ingredient.m_43942_());
            json.addProperty("entity", EntityType.m_20613_(this.entity).toString());
            if (this.tag != null && !this.tag.m_128456_()) {
                json.addProperty("tag", this.tag.toString());
            }
            json.addProperty("incubationtime", (Number)this.incubationTime);
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

