/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.inventory.menu;

import com.aetherteam.aether.blockentity.IncubatorBlockEntity;
import com.aetherteam.aether.inventory.AetherRecipeBookTypes;
import com.aetherteam.aether.inventory.menu.AetherMenuTypes;
import com.aetherteam.aether.inventory.menu.slot.IncubatorFuelSlot;
import com.aetherteam.aether.inventory.menu.slot.IncubatorItemSlot;
import com.aetherteam.aether.recipe.AetherRecipeTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class IncubatorMenu
extends RecipeBookMenu<Container> {
    public final Container container;
    public final ContainerData data;
    public final Level level;

    public IncubatorMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, (Container)new SimpleContainer(2), (ContainerData)new SimpleContainerData(7));
    }

    public IncubatorMenu(int containerId, Inventory playerInventory, Container container, ContainerData data) {
        super((MenuType)AetherMenuTypes.INCUBATOR.get(), containerId);
        IncubatorMenu.m_38869_((Container)container, (int)2);
        IncubatorMenu.m_38886_((ContainerData)data, (int)7);
        this.container = container;
        this.data = data;
        this.level = playerInventory.f_35978_.m_9236_();
        this.m_38897_(new IncubatorItemSlot(this, container, 0, 73, 17, playerInventory.f_35978_));
        this.m_38897_(new IncubatorFuelSlot(this, container, 1, 73, 53));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInventory, k, 8 + k * 18, 142));
        }
        this.m_38884_(data);
    }

    public void m_5816_(StackedContents contents) {
        Container container = this.container;
        if (container instanceof StackedContentsCompatible) {
            StackedContentsCompatible stackedContentsCompatible = (StackedContentsCompatible)container;
            stackedContentsCompatible.m_5809_(contents);
        }
    }

    public void m_6650_() {
        this.m_38853_(0).m_5852_(ItemStack.f_41583_);
    }

    public boolean m_6032_(Recipe<? super Container> recipe) {
        return recipe.m_5818_(this.container, this.level);
    }

    public int m_6636_() {
        return -1;
    }

    public int m_6635_() {
        return 1;
    }

    public int m_6656_() {
        return 1;
    }

    public int m_6653_() {
        return 2;
    }

    public boolean m_6875_(Player player) {
        return this.container.m_6542_(player);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack itemStack1 = slot.m_7993_();
            itemStack = itemStack1.m_41777_();
            if (index != 1 && index != 0 ? (this.canIncubate(itemStack1) ? !this.m_38903_(itemStack1, 0, 1, false) : (this.isFuel(itemStack1) ? !this.m_38903_(itemStack1, 1, 2, false) : (index >= 2 && index < 29 ? !this.m_38903_(itemStack1, 29, 38, false) : index >= 29 && index < 38 && !this.m_38903_(itemStack1, 2, 29, false)))) : !this.m_38903_(itemStack1, 2, 38, false)) {
                return ItemStack.f_41583_;
            }
            if (itemStack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemStack1.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemStack1);
        }
        return itemStack;
    }

    protected boolean canIncubate(ItemStack stack) {
        return this.level.m_7465_().m_44015_((RecipeType)AetherRecipeTypes.INCUBATION.get(), (Container)new SimpleContainer(new ItemStack[]{stack}), this.level).isPresent();
    }

    public boolean isFuel(ItemStack stack) {
        return IncubatorBlockEntity.getIncubatingMap().containsKey(stack.m_41720_());
    }

    public int getIncubationProgressScaled() {
        return this.data.m_6413_(3) != 0 ? this.data.m_6413_(2) * 54 / this.data.m_6413_(3) : 0;
    }

    public boolean isIncubating() {
        return this.data.m_6413_(0) > 0;
    }

    public int getIncubationTimeRemaining() {
        int i = this.data.m_6413_(1);
        if (i == 0) {
            i = 1000;
        }
        return this.data.m_6413_(0) * 11 / i;
    }

    public BlockPos getIncubatorPos() {
        int x = this.data.m_6413_(4);
        int y = this.data.m_6413_(5);
        int z = this.data.m_6413_(6);
        return new BlockPos(x, y, z);
    }

    public RecipeBookType m_5867_() {
        return AetherRecipeBookTypes.INCUBATOR;
    }

    public boolean m_142157_(int slot) {
        return slot != 1;
    }
}

