/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.sound;

import com.aetherteam.aether.capability.AetherCapabilities;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;

public class PortalTriggerSoundInstance
extends AbstractTickableSoundInstance {
    private final Player player;
    private final float startingVolume;
    private int fade;

    public PortalTriggerSoundInstance(Player player, SoundEvent event, SoundSource source, float volume, float pitch, RandomSource random, boolean looping, int delay, SoundInstance.Attenuation attenuation, double x, double y, double z, boolean relative) {
        super(event, source, random);
        this.player = player;
        this.f_119573_ = volume;
        this.startingVolume = volume;
        this.f_119574_ = pitch;
        this.f_119575_ = x;
        this.f_119576_ = y;
        this.f_119577_ = z;
        this.f_119578_ = looping;
        this.f_119579_ = delay;
        this.f_119580_ = attenuation;
        this.f_119582_ = relative;
    }

    public static PortalTriggerSoundInstance forLocalAmbience(Player player, SoundEvent pSound, float pVolume, float pPitch) {
        return new PortalTriggerSoundInstance(player, pSound, SoundSource.AMBIENT, pPitch, pVolume, SoundInstance.m_235150_(), false, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true);
    }

    public void m_7788_() {
        LazyOptional aetherPlayer = this.player.getCapability(AetherCapabilities.AETHER_PLAYER_CAPABILITY);
        aetherPlayer.ifPresent(cap -> {
            if (!cap.isInPortal()) {
                ++this.fade;
                this.f_119573_ = (float)Math.exp(-((double)this.fade / 50.0)) - (1.0f - this.startingVolume);
                if (this.fade >= 75) {
                    this.m_119609_();
                }
            }
        });
    }
}

