/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.block.portal;

import com.aetherteam.aether.Aether;
import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.block.portal.AetherPortalBlock;
import com.aetherteam.aether.mixin.mixins.common.accessor.EntityAccessor;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.clientbound.PortalTravelSoundPacket;
import com.aetherteam.aether.world.AetherPoi;
import com.aetherteam.aether.world.LevelUtil;
import com.aetherteam.nitrogen.network.PacketRelay;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.network.simple.SimpleChannel;

public class AetherPortalForcer
implements ITeleporter {
    private final ServerLevel level;
    private final boolean hasFrame;
    private final boolean isStartup;

    public AetherPortalForcer(ServerLevel level, boolean hasFrame) {
        this.level = level;
        this.hasFrame = hasFrame;
        this.isStartup = false;
    }

    public AetherPortalForcer(ServerLevel level, boolean hasFrame, boolean isStartup) {
        this.level = level;
        this.hasFrame = hasFrame;
        this.isStartup = isStartup;
    }

    public boolean playTeleportSound(ServerPlayer player, ServerLevel sourceLevel, ServerLevel destinationLevel) {
        if (this.hasFrame) {
            PacketRelay.sendToPlayer((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new PortalTravelSoundPacket(), (ServerPlayer)player);
        }
        return false;
    }

    @Nullable
    public PortalInfo getPortalInfo(Entity entity, ServerLevel destinationLevel, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
        boolean isAether;
        EntityAccessor entityAccessor = (EntityAccessor)entity;
        boolean bl = isAether = destinationLevel.m_46472_() == LevelUtil.destinationDimension();
        if (entity.m_9236_().m_46472_() != LevelUtil.destinationDimension() && !isAether) {
            return null;
        }
        if (this.isStartup) {
            return new PortalInfo(this.checkPositionsForInitialSpawn((Level)destinationLevel, entity.m_20183_()).m_252807_(), Vec3.f_82478_, entity.m_146908_(), entity.m_146909_());
        }
        if (!this.hasFrame) {
            return new PortalInfo(new Vec3(entity.m_20185_(), (double)destinationLevel.m_151558_(), entity.m_20189_()), Vec3.f_82478_, entity.m_146908_(), entity.m_146909_());
        }
        WorldBorder worldBorder = destinationLevel.m_6857_();
        double scale = DimensionType.m_63908_((DimensionType)this.level.m_6042_(), (DimensionType)destinationLevel.m_6042_());
        BlockPos scaledEntityPos = worldBorder.m_187569_(entity.m_20185_() * scale, entity.m_20186_(), entity.m_20189_() * scale);
        return this.getExitPortal(entity, scaledEntityPos, worldBorder).map(rectangle -> {
            Vec3 vec3;
            Direction.Axis axis;
            BlockState blockState = this.level.m_8055_(entityAccessor.aether$getPortalEntrancePos());
            if (blockState.m_61138_((Property)BlockStateProperties.f_61364_)) {
                axis = (Direction.Axis)blockState.m_61143_((Property)BlockStateProperties.f_61364_);
                BlockUtil.FoundRectangle foundRectangle = BlockUtil.m_124334_((BlockPos)entityAccessor.aether$getPortalEntrancePos(), (Direction.Axis)axis, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, blockPos -> this.level.m_8055_(blockPos) == blockState);
                vec3 = entityAccessor.callGetRelativePortalPosition(axis, foundRectangle);
            } else {
                axis = Direction.Axis.X;
                vec3 = new Vec3(0.5, 0.0, 0.0);
            }
            return PortalShape.m_257966_((ServerLevel)destinationLevel, (BlockUtil.FoundRectangle)rectangle, (Direction.Axis)axis, (Vec3)vec3, (Entity)entity, (Vec3)entity.m_20184_(), (float)entity.m_146908_(), (float)entity.m_146909_());
        }).orElse(null);
    }

    private Optional<BlockUtil.FoundRectangle> getExitPortal(Entity entity, BlockPos findFrom, WorldBorder worldBorder) {
        EntityAccessor entityAccessor = (EntityAccessor)entity;
        if (entity instanceof ServerPlayer) {
            Optional<BlockUtil.FoundRectangle> optional = this.findPortalAround(findFrom, worldBorder);
            if (optional.isPresent()) {
                return optional;
            }
            Direction.Axis direction$axis = this.level.m_8055_(entityAccessor.aether$getPortalEntrancePos()).m_61145_(AetherPortalBlock.AXIS).orElse(Direction.Axis.X);
            Optional<BlockUtil.FoundRectangle> portalOptional = this.createPortal(findFrom, direction$axis);
            if (portalOptional.isEmpty()) {
                Aether.LOGGER.error("Unable to create an Aether Portal, likely target out of worldborder");
            }
            return portalOptional;
        }
        return this.findPortalAround(findFrom, worldBorder);
    }

    private Optional<BlockUtil.FoundRectangle> findPortalAround(BlockPos pos, WorldBorder worldBorder) {
        PoiManager poiManager = this.level.m_8904_();
        poiManager.m_27056_((LevelReader)this.level, pos, 128);
        Optional<PoiRecord> optionalPoi = poiManager.m_27166_(poiType -> poiType.m_203565_(AetherPoi.AETHER_PORTAL.getKey()), pos, 128, PoiManager.Occupancy.ANY).filter(poiRecord -> worldBorder.m_61937_(poiRecord.m_27257_())).sorted(Comparator.comparingDouble(poiRecord -> poiRecord.m_27257_().m_123331_((Vec3i)pos)).thenComparingInt(poiRecord -> poiRecord.m_27257_().m_123342_())).filter(poiRecord -> this.level.m_8055_(poiRecord.m_27257_()).m_61138_((Property)BlockStateProperties.f_61364_)).findFirst();
        return optionalPoi.map(poiRecord -> {
            BlockPos poiPos = poiRecord.m_27257_();
            this.level.m_7726_().m_8387_(TicketType.f_9447_, new ChunkPos(poiPos), 3, (Object)poiPos);
            BlockState blockstate = this.level.m_8055_(poiPos);
            return BlockUtil.m_124334_((BlockPos)poiPos, (Direction.Axis)((Direction.Axis)blockstate.m_61143_((Property)BlockStateProperties.f_61364_)), (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, blockPos -> this.level.m_8055_(blockPos) == blockstate);
        });
    }

    public Optional<BlockUtil.FoundRectangle> createPortal(BlockPos pos, Direction.Axis axis) {
        Direction direction = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        double d0 = -1.0;
        BlockPos blockPos = null;
        double d1 = -1.0;
        BlockPos blockPos1 = null;
        WorldBorder worldBorder = this.level.m_6857_();
        int i = Math.min(this.level.m_151558_(), this.level.m_141937_() + this.level.m_143344_()) - 1;
        BlockPos.MutableBlockPos mutablePos = pos.m_122032_();
        for (BlockPos.MutableBlockPos mutablePos1 : BlockPos.m_121935_((BlockPos)pos, (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            int j = Math.min(i, this.level.m_6924_(Heightmap.Types.MOTION_BLOCKING, mutablePos1.m_123341_(), mutablePos1.m_123343_()));
            if (!worldBorder.m_61937_((BlockPos)mutablePos1) || !worldBorder.m_61937_((BlockPos)mutablePos1.m_122175_(direction, 1))) continue;
            mutablePos1.m_122175_(direction.m_122424_(), 1);
            for (int l = j; l >= this.level.m_141937_(); --l) {
                int j1;
                mutablePos1.m_142448_(l);
                if (!this.level.m_46859_((BlockPos)mutablePos1)) continue;
                int i1 = l;
                while (l > this.level.m_141937_() && this.level.m_46859_((BlockPos)mutablePos1.m_122173_(Direction.DOWN))) {
                    --l;
                }
                if (l + 4 > i || (j1 = i1 - l) > 0 && j1 < 3) continue;
                mutablePos1.m_142448_(l);
                if (!this.canHostFrame((BlockPos)mutablePos1, mutablePos, direction, 0)) continue;
                double d2 = pos.m_123331_((Vec3i)mutablePos1);
                if (this.canHostFrame((BlockPos)mutablePos1, mutablePos, direction, -1) && this.canHostFrame((BlockPos)mutablePos1, mutablePos, direction, 1) && (d0 == -1.0 || d0 > d2)) {
                    d0 = d2;
                    blockPos = mutablePos1.m_7949_();
                }
                if (d0 != -1.0 || d1 != -1.0 && !(d1 > d2)) continue;
                d1 = d2;
                blockPos1 = mutablePos1.m_7949_();
            }
        }
        if (d0 == -1.0 && d1 != -1.0) {
            blockPos = blockPos1;
            d0 = d1;
        }
        if (d0 == -1.0) {
            int i2 = i - 9;
            int k1 = Math.max(this.level.m_141937_() + 1, 70);
            if (i2 < k1) {
                return Optional.empty();
            }
            blockPos = new BlockPos(pos.m_123341_(), Mth.m_14045_((int)pos.m_123342_(), (int)k1, (int)i2), pos.m_123343_()).m_7949_();
            Direction direction1 = direction.m_122427_();
            if (!worldBorder.m_61937_(blockPos)) {
                return Optional.empty();
            }
            for (int i3 = -1; i3 < 2; ++i3) {
                for (int j3 = 0; j3 < 2; ++j3) {
                    for (int k3 = -1; k3 < 3; ++k3) {
                        BlockState blockState1 = k3 < 0 ? Blocks.f_50141_.m_49966_() : Blocks.f_50016_.m_49966_();
                        mutablePos.m_122154_((Vec3i)blockPos, j3 * direction.m_122429_() + i3 * direction1.m_122429_(), k3, j3 * direction.m_122431_() + i3 * direction1.m_122431_());
                        this.level.m_46597_((BlockPos)mutablePos, blockState1);
                    }
                }
            }
        }
        for (int l1 = -1; l1 < 3; ++l1) {
            for (int j2 = -1; j2 < 4; ++j2) {
                if (l1 != -1 && l1 != 2 && j2 != -1 && j2 != 3) continue;
                mutablePos.m_122154_(blockPos, l1 * direction.m_122429_(), j2, l1 * direction.m_122431_());
                this.level.m_7731_((BlockPos)mutablePos, Blocks.f_50141_.m_49966_(), 3);
            }
        }
        BlockState blockState = (BlockState)((AetherPortalBlock)((Object)AetherBlocks.AETHER_PORTAL.get())).m_49966_().m_61124_(AetherPortalBlock.AXIS, (Comparable)axis);
        for (int k2 = 0; k2 < 2; ++k2) {
            for (int l2 = 0; l2 < 3; ++l2) {
                mutablePos.m_122154_((Vec3i)blockPos, k2 * direction.m_122429_(), l2, k2 * direction.m_122431_());
                this.level.m_7731_((BlockPos)mutablePos, blockState, 18);
            }
        }
        return Optional.of(new BlockUtil.FoundRectangle(blockPos.m_7949_(), 2, 3));
    }

    private boolean canHostFrame(BlockPos originalPos, BlockPos.MutableBlockPos offsetPos, Direction direction, int offsetScale) {
        Direction clockWiseDirection = direction.m_122427_();
        for (int i = -1; i < 3; ++i) {
            for (int j = -1; j < 4; ++j) {
                offsetPos.m_122154_((Vec3i)originalPos, direction.m_122429_() * i + clockWiseDirection.m_122429_() * offsetScale, j, direction.m_122431_() * i + clockWiseDirection.m_122431_() * offsetScale);
                BlockState blockState = this.level.m_8055_((BlockPos)offsetPos);
                if (j < 0 && (!blockState.m_280296_() || blockState.m_204336_(AetherTags.Blocks.AETHER_PORTAL_BLACKLIST))) {
                    return false;
                }
                if (j < 0 || this.level.m_46859_((BlockPos)offsetPos)) continue;
                return false;
            }
        }
        return true;
    }

    private BlockPos checkPositionsForInitialSpawn(Level level, BlockPos origin) {
        if (!this.isSafe(level, origin)) {
            for (int i = 0; i <= 750; i += 5) {
                for (Direction facing : Direction.Plane.HORIZONTAL) {
                    BlockPos offsetPosition = origin.m_121955_(facing.m_122436_().m_142393_(i));
                    if (this.isSafeAround(level, offsetPosition)) {
                        return offsetPosition;
                    }
                    BlockPos heightmapPosition = level.m_5452_(Heightmap.Types.MOTION_BLOCKING, offsetPosition);
                    if (!this.isSafeAround(level, heightmapPosition)) continue;
                    return heightmapPosition;
                }
            }
        }
        return origin;
    }

    public boolean isSafeAround(Level level, BlockPos pos) {
        BlockPos belowPos = pos.m_7495_();
        if (!this.isSafe(level, belowPos)) {
            return false;
        }
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            if (this.isSafe(level, belowPos.m_5484_(facing, 2))) continue;
            return false;
        }
        return true;
    }

    private boolean isSafe(Level level, BlockPos pos) {
        return level.m_6857_().m_61937_(pos) && level.m_8055_(pos).m_204336_(AetherTags.Blocks.AETHER_DIRT) && level.m_8055_(pos.m_7494_()).m_60795_() && level.m_8055_(pos.m_6630_(2)).m_60795_();
    }
}

