/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.tree;

import biomesoplenty.util.biome.GeneratorUtil;
import biomesoplenty.worldgen.feature.configurations.EmpyrealTreeConfiguration;
import biomesoplenty.worldgen.feature.tree.BOPTreeFeature;
import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;

public class EmpyrealTreeFeature
extends BOPTreeFeature<EmpyrealTreeConfiguration> {
    public EmpyrealTreeFeature(Codec<EmpyrealTreeConfiguration> codec) {
        super(codec);
    }

    protected boolean m_225257_(WorldGenLevel world, RandomSource random, BlockPos startPos, BiConsumer<BlockPos, BlockState> roots, BiConsumer<BlockPos, BlockState> logs, FoliagePlacer.FoliageSetter leaves, TreeConfiguration configBase) {
        EmpyrealTreeConfiguration config = (EmpyrealTreeConfiguration)configBase;
        while (startPos.m_123342_() >= world.m_141937_() + 1 && world.m_46859_(startPos) || world.m_8055_(startPos).m_204336_(BlockTags.f_13035_)) {
            startPos = startPos.m_7495_();
        }
        int height = GeneratorUtil.nextIntBetween(random, config.minHeight, config.maxHeight);
        BlockPos pos = startPos.m_7494_();
        if (!this.checkSpace((LevelAccessor)world, pos, height + 20, 2)) {
            return false;
        }
        for (int i = 0; i < height; ++i) {
            this.placeLog((LevelAccessor)world, pos.m_6630_(i), logs, config);
        }
        BlockPos topPos = pos.m_6630_(height);
        if (world.m_213780_().m_188503_(5) == 0) {
            world.m_7731_(topPos.m_7918_(0, 0, 0), Blocks.f_50701_.m_49966_(), 2);
        } else {
            this.placeLog((LevelAccessor)world, topPos.m_7918_(0, 0, 0), logs, config);
        }
        if (random.m_188503_(2) == 0) {
            this.placeLog((LevelAccessor)world, topPos.m_7918_(0, 0, -1), logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(0, 1, -1), logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(-1, 1, -1), logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(-1, 2, -1), logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(-1, 3, -1), logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(-2, 3, 0), logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(-2, 4, 0), logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(-2, 4, 1), Direction.Axis.Z, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(-2, 5, 1), Direction.Axis.Z, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(-2, 5, 2), Direction.Axis.Z, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(-2, 5, 3), Direction.Axis.Z, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(-1, 5, 3), Direction.Axis.X, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(-1, 6, 3), Direction.Axis.X, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(0, 6, 3), Direction.Axis.X, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(1, 6, 3), Direction.Axis.X, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(2, 6, 3), Direction.Axis.Z, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(2, 6, 2), Direction.Axis.Z, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(2, 7, 2), Direction.Axis.Z, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(2, 7, 1), Direction.Axis.Z, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(1, 8, 0), Direction.Axis.X, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(0, 0, 1), logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(0, 1, 1), logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(1, 1, 1), logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(1, 2, 1), logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(1, 3, 1), logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(2, 3, 0), logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(2, 4, 0), logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(2, 4, -1), Direction.Axis.Z, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(2, 5, -1), Direction.Axis.Z, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(2, 5, -2), Direction.Axis.Z, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(2, 5, -3), Direction.Axis.Z, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(1, 5, -3), Direction.Axis.X, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(1, 6, -3), Direction.Axis.X, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(0, 6, -3), Direction.Axis.X, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(-1, 6, -3), Direction.Axis.X, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(-2, 6, -3), Direction.Axis.Z, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(-2, 6, -2), Direction.Axis.Z, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(-2, 7, -2), Direction.Axis.Z, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(-2, 7, -1), Direction.Axis.Z, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(-1, 8, 0), Direction.Axis.X, logs, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(0, 1, 0), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(1, 0, 0), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(-1, 0, 0), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(1, 0, 1), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(-1, 0, -1), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(1, -1, 0), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(-1, -1, 0), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(0, -1, 1), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(0, -1, -1), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(1, -2, 0), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(-1, -2, 0), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(0, 7, 3), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(0, 6, 2), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(0, 6, 4), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(0, 5, 2), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(0, 5, 4), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(0, 5, 3), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(1, 5, 3), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(-1, 4, 3), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(0, 4, 3), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(1, 4, 3), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(-1, 3, 3), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(1, 3, 3), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(-1, 2, 3), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(0, 7, -3), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(0, 6, -2), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(0, 6, -4), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(0, 5, -2), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(0, 5, -4), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(0, 5, -3), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(-1, 5, -3), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(1, 4, -3), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(0, 4, -3), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(-1, 4, -3), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(1, 3, -3), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(-1, 3, -3), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(1, 2, -3), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(1, 6, 0), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(-1, 6, 0), leaves, config);
        } else {
            this.placeLog((LevelAccessor)world, topPos.m_7918_(-1, 0, 0), logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(-1, 1, 0), logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(-1, 1, -1), logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(-1, 2, -1), logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(-1, 3, -1), logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(0, 3, -2), logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(0, 4, -2), logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(1, 4, -2), Direction.Axis.X, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(1, 5, -2), Direction.Axis.X, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(2, 5, -2), Direction.Axis.X, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(3, 5, -2), Direction.Axis.X, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(3, 5, -1), Direction.Axis.Z, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(3, 6, -1), Direction.Axis.Z, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(3, 6, 0), Direction.Axis.Z, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(3, 6, 1), Direction.Axis.Z, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(3, 6, 2), Direction.Axis.X, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(2, 6, 2), Direction.Axis.X, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(2, 7, 2), Direction.Axis.X, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(1, 7, 2), Direction.Axis.X, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(0, 8, 1), Direction.Axis.Z, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(1, 0, 0), logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(1, 1, 0), logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(1, 1, 1), logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(1, 2, 1), logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(1, 3, 1), logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(0, 3, 2), logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(0, 4, 2), logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(-1, 4, 2), Direction.Axis.X, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(-1, 5, 2), Direction.Axis.X, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(-2, 5, 2), Direction.Axis.X, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(-3, 5, 2), Direction.Axis.X, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(-3, 5, 1), Direction.Axis.Z, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(-3, 6, 1), Direction.Axis.Z, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(-3, 6, 0), Direction.Axis.Z, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(-3, 6, -1), Direction.Axis.Z, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(-3, 6, -2), Direction.Axis.X, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(-2, 6, -2), Direction.Axis.X, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(-2, 7, -2), Direction.Axis.X, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(-1, 7, -2), Direction.Axis.X, logs, config);
            this.placeLog((LevelAccessor)world, topPos.m_7918_(0, 8, -1), Direction.Axis.Z, logs, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(0, 1, 0), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(0, 0, 1), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(0, 0, -1), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(1, 0, 1), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(-1, 0, -1), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(0, -1, 1), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(0, -1, -1), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(1, -1, 0), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(-1, -1, 0), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(0, -2, 1), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(0, -2, -1), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(3, 7, 0), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(2, 6, 0), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(4, 6, 0), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(2, 5, 0), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(4, 5, 0), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(3, 5, 0), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(3, 5, 1), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(3, 4, -1), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(3, 4, 0), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(3, 4, 1), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(3, 3, -1), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(3, 3, 1), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(3, 2, -1), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(-3, 7, 0), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(-2, 6, 0), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(-4, 6, 0), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(-2, 5, 0), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(-4, 5, 0), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(-3, 5, 0), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(-3, 5, -1), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(-3, 4, 1), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(-3, 4, 0), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(-3, 4, -1), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(-3, 3, 1), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(-3, 3, -1), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(-3, 2, 1), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(0, 6, 1), leaves, config);
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(0, 6, -1), leaves, config);
        }
        this.placeLog((LevelAccessor)world, topPos.m_7918_(0, 9, 0), logs, config);
        this.placeLeaves((LevelAccessor)world, topPos.m_7918_(0, 10, 0), leaves, config);
        this.placeLeaves((LevelAccessor)world, topPos.m_7918_(1, 9, 0), leaves, config);
        this.placeLeaves((LevelAccessor)world, topPos.m_7918_(-1, 9, 0), leaves, config);
        this.placeLeaves((LevelAccessor)world, topPos.m_7918_(0, 9, 1), leaves, config);
        this.placeLeaves((LevelAccessor)world, topPos.m_7918_(0, 9, -1), leaves, config);
        if (world.m_213780_().m_188503_(5) == 0) {
            world.m_7731_(topPos.m_7918_(0, 8, 0), Blocks.f_50701_.m_49966_(), 2);
        } else {
            this.placeLeaves((LevelAccessor)world, topPos.m_7918_(0, 8, 0), leaves, config);
        }
        this.placeLeaves((LevelAccessor)world, topPos.m_7918_(1, 8, 0), leaves, config);
        this.placeLeaves((LevelAccessor)world, topPos.m_7918_(-1, 8, 0), leaves, config);
        this.placeLeaves((LevelAccessor)world, topPos.m_7918_(0, 8, 1), leaves, config);
        this.placeLeaves((LevelAccessor)world, topPos.m_7918_(0, 8, -1), leaves, config);
        this.placeLeaves((LevelAccessor)world, topPos.m_7918_(1, 7, 0), leaves, config);
        this.placeLeaves((LevelAccessor)world, topPos.m_7918_(-1, 7, 0), leaves, config);
        this.placeLeaves((LevelAccessor)world, topPos.m_7918_(0, 7, 1), leaves, config);
        this.placeLeaves((LevelAccessor)world, topPos.m_7918_(0, 7, -1), leaves, config);
        if (random.m_188503_(2) == 0) {
            this.generateTop((LevelAccessor)world, topPos.m_6630_(12), logs, leaves, config);
        }
        return true;
    }

    public boolean checkSpace(LevelAccessor world, BlockPos pos, int height, int radius) {
        for (int y = 0; y <= height; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos1 = pos.m_7918_(x, y, z);
                    if (pos1.m_123342_() < 255 && this.canReplace(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void generateTop(LevelAccessor world, BlockPos pos, BiConsumer<BlockPos, BlockState> logs, FoliagePlacer.FoliageSetter leaves, EmpyrealTreeConfiguration config) {
        this.placeLeaves(world, pos.m_7918_(0, 0, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(1, 0, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-1, 0, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 0, 1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 0, -1), leaves, config);
        this.placeLog(world, pos.m_7918_(0, 1, 0), logs, config);
        this.placeLeaves(world, pos.m_7918_(1, 1, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-1, 1, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 1, 1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 1, -1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(1, 1, 1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(1, 1, -1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-1, 1, 1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-1, 1, -1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(2, 1, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-2, 1, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 1, 2), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 1, -2), leaves, config);
        if (world.m_213780_().m_188503_(5) == 0) {
            world.m_7731_(pos.m_7918_(0, 2, 0), Blocks.f_50701_.m_49966_(), 2);
        } else {
            this.placeLog(world, pos.m_7918_(0, 2, 0), logs, config);
        }
        this.placeLeaves(world, pos.m_7918_(1, 2, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-1, 2, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 2, 1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 2, -1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(1, 2, 1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(1, 2, -1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-1, 2, 1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-1, 2, -1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(2, 2, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-2, 2, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 2, 2), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 2, -2), leaves, config);
        this.placeLeaves(world, pos.m_7918_(2, 2, -1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-2, 2, 1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-1, 2, 2), leaves, config);
        this.placeLeaves(world, pos.m_7918_(1, 2, -2), leaves, config);
        this.placeLeaves(world, pos.m_7918_(2, 2, 1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-2, 2, -1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(1, 2, 2), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-1, 2, -2), leaves, config);
        this.placeLog(world, pos.m_7918_(0, 3, 0), logs, config);
        this.placeLeaves(world, pos.m_7918_(1, 3, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-1, 3, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 3, 1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 3, -1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(1, 3, 1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(1, 3, -1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-1, 3, 1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-1, 3, -1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(2, 3, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-2, 3, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 3, 2), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 3, -2), leaves, config);
        this.placeLog(world, pos.m_7918_(0, 4, 0), logs, config);
        this.placeLeaves(world, pos.m_7918_(1, 4, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-1, 4, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 4, 1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 4, -1), leaves, config);
        this.placeLog(world, pos.m_7918_(0, 5, 0), logs, config);
        this.placeLeaves(world, pos.m_7918_(1, 5, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-1, 5, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 5, 1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 5, -1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 6, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 7, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 8, 0), leaves, config);
    }
}

