/*
 * Decompiled with CFR 0.152.
 */
package exmo.cy;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.jnativehook.GlobalScreen;
import org.jnativehook.NativeHookException;
import org.jnativehook.keyboard.NativeKeyEvent;
import org.jnativehook.keyboard.NativeKeyListener;

public class Main {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static Scanner scanner = new Scanner(System.in);
    private static volatile String clipboardContent = "";
    private static final AtomicBoolean changed = new AtomicBoolean(false);
    private static int pr = 0;
    private static String basejson = "";
    private static TrayIcon trayIcon;

    private static void initSystemTray() {
        if (!SystemTray.isSupported()) {
            System.err.println("\u7cfb\u7edf\u4e0d\u652f\u6301\u6258\u76d8\u529f\u80fd");
            return;
        }
        SystemTray tray = SystemTray.getSystemTray();
        Image image = Toolkit.getDefaultToolkit().createImage(Main.class.getResource("/icon.png"));
        trayIcon = new TrayIcon(image, "JSON\u5904\u7406\u5668");
        trayIcon.setImageAutoSize(true);
        try {
            tray.add(trayIcon);
        }
        catch (AWTException e) {
            System.err.println("\u65e0\u6cd5\u6dfb\u52a0\u6258\u76d8\u56fe\u6807: " + e.getMessage());
        }
    }

    private static void showNotification(String title, String message) {
        if (trayIcon != null) {
            trayIcon.displayMessage(title, message, TrayIcon.MessageType.INFO);
        }
    }

    private static void initGlobalHotkey() {
        try {
            Logger.getLogger(GlobalScreen.class.getPackage().getName()).setLevel(Level.OFF);
            GlobalScreen.registerNativeHook();
            GlobalScreen.addNativeKeyListener(new NativeKeyListener(){

                @Override
                public void nativeKeyTyped(NativeKeyEvent e) {
                }

                @Override
                public void nativeKeyPressed(NativeKeyEvent e) {
                    if (e.getKeyCode() == 48) {
                        try {
                            clipboardContent = Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor).toString();
                        }
                        catch (UnsupportedFlavorException ex) {
                            throw new RuntimeException(ex);
                        }
                        catch (IOException ex) {
                            throw new RuntimeException(ex);
                        }
                        changed.set(true);
                    }
                }

                @Override
                public void nativeKeyReleased(NativeKeyEvent e) {
                }
            });
        }
        catch (NativeHookException ex) {
            System.err.println("\u5168\u5c40\u70ed\u952e\u6ce8\u518c\u5931\u8d25: " + ex.getMessage());
            System.exit(1);
        }
    }

    public static void main(String[] args) throws IOException {
        Main.initSystemTray();
        Main.initGlobalHotkey();
        Main.showNotification("JSON\u5904\u7406\u5668", "\u8bf7\u5c06JSON\u590d\u5236\u81f3\u526a\u8d34\u677f");
        Main.processFiles();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                GlobalScreen.unregisterNativeHook();
            }
            catch (NativeHookException e) {
                e.printStackTrace();
            }
        }));
        new Thread(() -> {
            while (true) {
                if (!changed.get()) {
                    continue;
                }
                changed.set(false);
                if (pr == 0) {
                    if (clipboardContent.isEmpty()) continue;
                    basejson = clipboardContent;
                    ++pr;
                    System.out.println("json\u5df2\u8bb0\u5f55 | " + basejson);
                    Main.showNotification("JSON\u5904\u7406\u5668", "json\u5df2\u8bb0\u5f55 | " + basejson);
                    continue;
                }
                if (pr != 1 || clipboardContent.isEmpty()) continue;
                pr = 0;
                String trim1 = clipboardContent;
                String trim = trim1;
                String[] split = trim.split(":");
                if (split.length == 2) {
                    trim = split[1];
                }
                String fileName = trim + ".json";
                System.out.println("\u6587\u4ef6\u5df2\u4fdd\u5b58\u81f3 output/" + fileName);
                Main.showNotification("JSON\u5904\u7406\u5668", "\u6587\u4ef6\u5df2\u4fdd\u5b58\u81f3 output/" + fileName);
                Main.processJsonString(basejson, fileName, trim1);
            }
        }).start();
    }

    private static void processFiles() throws IOException {
        Path inputDir = Paths.get("input", new String[0]);
        Path outputDir = Paths.get("output", new String[0]);
        Files.createDirectories(outputDir, new FileAttribute[0]);
        try (Stream<Path> paths = Files.walk(inputDir, new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(".json")).forEach(p -> Main.processFile(p, inputDir, outputDir));
        }
    }

    private static void processConsoleInput() throws IOException {
        String trim1;
        String line;
        clipboardContent = null;
        System.out.println("\u8bf7\u8f93\u5165JSON\u5185\u5bb9\uff08\u8f93\u5165\u7a7a\u884c\u7ed3\u675f\uff0c\u6216\u6309~\u952e\u4f7f\u7528\u526a\u8d34\u677f\u5185\u5bb9\uff09\uff1a");
        StringBuilder jsonInput = new StringBuilder();
        while (!(line = scanner.nextLine()).isEmpty()) {
            jsonInput.append(line);
        }
        if (clipboardContent != null) {
            jsonInput = new StringBuilder(clipboardContent);
            System.out.println("\u68c0\u6d4b\u5230\u526a\u8d34\u677f\u5185\u5bb9\uff0c\u81ea\u52a8\u4f7f\u7528\u3002");
        }
        System.out.print("\u8bf7\u8f93\u5165\u4fdd\u5b58\u6587\u4ef6\u540d\uff08\u4e0d\u542b.json\uff09\uff1a");
        String trim = trim1 = scanner.nextLine().trim();
        String[] split = trim.split(":");
        if (split.length == 2) {
            trim = split[1];
        }
        String fileName = trim + ".json";
        Main.processJsonString(jsonInput.toString(), fileName, trim1);
        System.out.println("\u6587\u4ef6\u5df2\u4fdd\u5b58\u81f3 output/" + fileName);
    }

    private static void processJsonString(String jsonStr, String fileName, String itemId) {
        try {
            JsonNode root = mapper.readTree(jsonStr);
            Main.processAndModifyJson(root);
            if (root.has("result")) {
                result = (ObjectNode)root.get("result");
                result.put("item", itemId);
            } else {
                result = ((ObjectNode)root).putObject("result");
                result.put("item", itemId);
            }
            Path outputPath = Paths.get("output", fileName);
            Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
            mapper.writerWithDefaultPrettyPrinter().writeValue(outputPath.toFile(), (Object)root);
        }
        catch (IOException e) {
            System.err.println("\u5904\u7406\u51fa\u9519: " + e.getMessage());
        }
    }

    private static void processAndModifyJson(JsonNode root) {
        if (root.has("type") && root.get("type").asText().equals("extendedcrafting:shaped_table")) {
            ((ObjectNode)root).put("type", "minecraft:crafting_shaped");
        }
        if (root.has("key")) {
            ObjectNode keys = (ObjectNode)root.get("key");
            keys.fields().forEachRemaining(entry -> {
                JsonNode value = (JsonNode)entry.getValue();
                if (value.isObject()) {
                    ObjectNode itemNode = (ObjectNode)value;
                    itemNode.remove("nbt");
                    itemNode.remove("count");
                    itemNode.remove("type");
                }
            });
        }
    }

    private static void processFile(Path inputFile, Path inputDir, Path outputDir) {
        try {
            JsonNode root = mapper.readTree(inputFile.toFile());
            Main.processAndModifyJson(root);
            Path relativePath = inputDir.relativize(inputFile);
            Path outputPath = outputDir.resolve(relativePath);
            Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
            mapper.writerWithDefaultPrettyPrinter().writeValue(outputPath.toFile(), (Object)root);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class GlobalKeyListener
    implements NativeKeyListener {
        private GlobalKeyListener() {
        }

        @Override
        public void nativeKeyPressed(NativeKeyEvent e) {
            if (e.getKeyCode() == 47) {
                try {
                    clipboardContent = Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor).toString();
                    System.out.println("\u6a21\u62df\u56de\u8f66\u952e\u7ed3\u675f\u8f93\u5165");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        @Override
        public void nativeKeyReleased(NativeKeyEvent e) {
        }

        @Override
        public void nativeKeyTyped(NativeKeyEvent e) {
        }
    }
}

