/*
 * Decompiled with CFR 0.152.
 */
package com.tianyi.primeval.specialattacks.swrod;

import com.tianyi.primeval.entity.SwordRainEntity;
import com.tianyi.primeval.registry.PLEntiteRegristrys;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import mods.flammpfeil.slashblade.ability.SummonedSwordArts;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.item.SwordType;
import mods.flammpfeil.slashblade.util.AdvancementHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SwordRainSOM {
    public static void doSlash(LivingEntity playerIn, boolean critical, double damage, float speed) {
        int colorCode = playerIn.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).map(state -> state.getColorCode()).orElse(-13421569);
        SwordRainSOM.doSlash(playerIn, colorCode, critical, damage, speed);
    }

    public static void doSlash(LivingEntity playerIn, int colorCode, boolean critical, double damage, float speed) {
        if (playerIn.m_9236_().m_5776_()) {
            return;
        }
        playerIn.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
            Level worldIn = playerIn.m_9236_();
            if (state.isBroken() || state.isSealed() || !SwordType.from((ItemStack)playerIn.m_21205_()).contains(SwordType.BEWITCHED)) {
                return;
            }
            List targets = worldIn.m_6443_(LivingEntity.class, new AABB(playerIn.m_20183_()).m_82400_(20.0), e -> e != playerIn && e.m_6084_() && !e.m_7307_((Entity)playerIn)).stream().sorted(Comparator.comparingDouble(e -> e.m_20280_((Entity)playerIn))).collect(Collectors.toList());
            LivingEntity closestTarget = targets.stream().min(Comparator.comparingDouble(e -> SwordRainSOM.calculateAngle(playerIn, (Entity)e))).orElse(null);
            if (closestTarget == null) {
                return;
            }
            Vec3 basePos = closestTarget.m_20182_().m_82520_(0.0, (double)closestTarget.m_20206_() + 1.5, 0.0);
            int powerLevel = playerIn.m_21205_().getEnchantmentLevel(Enchantments.f_44988_);
            int layers = 1;
            int swordsPerLayer = 4;
            float baseRadius = 2.0f;
            for (int layer = 0; layer < layers; ++layer) {
                float currentRadius = baseRadius + (float)layer * 0.8f;
                float yOffset = (float)layer * 1.2f;
                for (int i = 0; i < swordsPerLayer; ++i) {
                    SwordRainEntity sword = new SwordRainEntity(PLEntiteRegristrys.ro, worldIn);
                    sword.m_5602_((Entity)playerIn);
                    sword.setColor(state.getColorCode());
                    sword.setDamage(4 * (powerLevel + 1));
                    sword.setTarget(closestTarget);
                    sword.setTargetPos(closestTarget.m_20182_().m_82520_(0.0, (double)(closestTarget.m_20206_() / 2.0f), 0.0));
                    double angle = Math.toRadians(360.0 / (double)swordsPerLayer * (double)i);
                    double x = basePos.f_82479_ + (double)currentRadius * Math.cos(angle);
                    double z = basePos.f_82481_ + (double)currentRadius * Math.sin(angle);
                    double y = basePos.f_82480_ + (double)yOffset;
                    sword.m_6034_(x, y + 5.0, z);
                    sword.setTargetPos(new Vec3(x, basePos.f_82480_, z));
                    sword.m_146926_(-90.0f);
                    sword.m_146922_(180.0f);
                    sword.f_19859_ = 180.0f;
                    sword.m_20256_(new Vec3(0.0, -0.5, 0.0));
                    worldIn.m_7967_((Entity)sword);
                }
            }
            AdvancementHelper.grantCriterion((LivingEntity)playerIn, (ResourceLocation)SummonedSwordArts.ADVANCEMENT_HEAVY_RAIN_SWORDS);
            playerIn.m_5496_(SoundEvents.f_11893_, 0.2f, 1.45f);
        });
    }

    private static float calculateAngle(LivingEntity player, Entity target) {
        Vec3 viewVec = player.m_20252_(1.0f);
        Vec3 toTarget = target.m_20182_().m_82546_(player.m_20182_()).m_82541_();
        return (float)Math.toDegrees(Math.acos(viewVec.m_82526_(toTarget)));
    }

    static Vec3 calculateViewVector(float x, float y) {
        float f = x * ((float)Math.PI / 180);
        float f1 = -y * ((float)Math.PI / 180);
        float f2 = Mth.m_14089_((float)(f1 * 2.0f));
        float f3 = Mth.m_14031_((float)(f1 * 2.0f));
        float f4 = Mth.m_14089_((float)(f * 2.0f));
        float f5 = Mth.m_14031_((float)(f * 2.0f));
        return new Vec3((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }
}

