/*
 * Decompiled with CFR 0.152.
 */
package com.tianyi.primeval.entity;

import java.util.UUID;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.ability.StunManager;
import mods.flammpfeil.slashblade.entity.EntityAbstractSummonedSword;
import mods.flammpfeil.slashblade.entity.Projectile;
import mods.flammpfeil.slashblade.util.KnockBacks;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;

public class SwordRainEntity
extends EntityAbstractSummonedSword {
    private static final EntityDataAccessor<Boolean> IT_FIRED;
    long fireTime = -1L;
    int ON_GROUND_LIFE_TIME = 20;
    int ticksInGround = 0;
    private LivingEntity target;
    private static final EntityDataAccessor<String> TARGET_UUID;
    private boolean hasHit = false;
    private Vec3 targetPos;

    public void setTarget(LivingEntity target) {
        this.target = target;
        this.m_20088_().m_135381_(TARGET_UUID, (Object)target.m_20148_().toString());
    }

    public SwordRainEntity(EntityType<? extends Projectile> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.setPierce((byte)5);
        this.m_146926_(-90.0f);
        CompoundTag compoundtag = this.getPersistentData();
        ListTag listtag = compoundtag.m_128437_("CustomPotionEffects", 9);
        MobEffectInstance mobeffectinstance = new MobEffectInstance(MobEffects.f_19597_, 20, 10);
        listtag.add((Object)mobeffectinstance.m_19555_(new CompoundTag()));
        this.getPersistentData().m_128365_("CustomPotionEffects", (Tag)listtag);
    }

    public void setTargetPos(Vec3 pos) {
        this.targetPos = pos;
        if (!this.m_9236_().f_46443_) {
            this.m_20256_(Vec3.f_82478_);
        }
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (!this.m_9236_().f_46443_) {
            Vec3 pos = this.m_20182_();
            this.m_6034_(pos.f_82479_, pos.f_82480_ + 5.0, pos.f_82481_);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TARGET_UUID, (Object)"");
    }

    public void doFire() {
        this.m_20088_().m_135381_(IT_FIRED, (Object)true);
    }

    public boolean itFired() {
        return (Boolean)this.m_20088_().m_135370_(IT_FIRED);
    }

    public static SwordRainEntity createInstance(PlayMessages.SpawnEntity packet, Level worldIn) {
        return new SwordRainEntity((EntityType<? extends Projectile>)SlashBlade.RegistryEvents.HeavyRainSwords, worldIn);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            LivingEntity currentTarget = this.getCurrentTarget();
            if (currentTarget != null && currentTarget.m_6084_()) {
                this.targetPos = currentTarget.m_20182_().m_82520_(0.0, (double)(currentTarget.m_20206_() / 2.0f), 0.0);
                Vec3 toTarget = this.targetPos.m_82546_(this.m_20182_()).m_82541_();
                double speed = 0.8;
                Vec3 motion = toTarget.m_82490_(speed).m_82520_(0.0, -0.2, 0.0);
                this.m_20256_(motion);
                float targetYRot = (float)Math.toDegrees(Math.atan2(toTarget.f_82481_, toTarget.f_82479_)) - 90.0f;
                this.m_146922_(targetYRot);
            } else {
                this.m_146922_(180.0f);
                this.m_146926_(-90.0f);
                if (this.m_20184_().f_82480_ > -2.0) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -0.05, 0.0));
                }
            }
            if (!this.m_9236_().f_46443_ && this.f_19797_ % 5 == 0 && this.getCurrentTarget() != null) {
                Vec3 predictedPos = this.target.m_20182_().m_82549_(this.target.m_20184_().m_82490_(2.0));
                Vec3 adjustDir = predictedPos.m_82546_(this.m_20182_()).m_82541_();
                this.m_20256_(this.m_20184_().m_82549_(adjustDir.m_82490_(0.1)));
            }
        }
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        if (this.targetPos == null) {
            super.m_6686_(x, y, z, velocity, inaccuracy);
        }
    }

    private LivingEntity getCurrentTarget() {
        String uuidStr;
        if (!(this.target != null && this.target.m_6084_() || (uuidStr = (String)this.m_20088_().m_135370_(TARGET_UUID)).isEmpty())) {
            this.target = (LivingEntity)((ServerLevel)this.m_9236_()).m_8791_(UUID.fromString(uuidStr));
        }
        return this.target;
    }

    public void m_6083_() {
        super.m_6083_();
        if (this.m_20202_() != null) {
            this.m_20256_(Vec3.f_82478_);
        }
    }

    private void faceEntityStandby() {
        this.m_146884_(this.m_20182_());
        this.m_19915_(this.m_146908_(), -90.0f);
    }

    public void setSpread(Vec3 basePos) {
        double areaSize = 2.5;
        double offsetX = (this.f_19796_.m_188500_() * 2.0 - 1.0) * areaSize;
        double offsetZ = (this.f_19796_.m_188500_() * 2.0 - 1.0) * areaSize;
        this.m_6034_(basePos.f_82479_ + offsetX, basePos.f_82480_, basePos.f_82481_ + offsetZ);
    }

    protected void m_5790_(EntityHitResult p_213868_1_) {
        Entity targetEntity = p_213868_1_.m_82443_();
        if (targetEntity instanceof LivingEntity) {
            LivingEntity a = (LivingEntity)targetEntity;
            KnockBacks.cancel.action.accept((LivingEntity)targetEntity);
            StunManager.setStun((LivingEntity)((LivingEntity)targetEntity));
            a.f_19802_ = 0;
        }
        if (!this.hasHit) {
            this.target = null;
            this.m_20088_().m_135381_(TARGET_UUID, (Object)"");
        }
        super.m_5790_(p_213868_1_);
    }

    protected void tryDespawn() {
        ++this.ticksInGround;
        if (this.ON_GROUND_LIFE_TIME <= this.ticksInGround) {
            this.burst();
        }
    }

    public void m_19915_(float yRot, float xRot) {
    }

    static {
        TARGET_UUID = SynchedEntityData.m_135353_(SwordRainEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
        IT_FIRED = SynchedEntityData.m_135353_(SwordRainEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    }
}

