/*
 * Decompiled with CFR 0.152.
 */
package com.tianyi.primeval.cover;

import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.capability.concentrationrank.ConcentrationRankCapabilityProvider;
import mods.flammpfeil.slashblade.entity.EntitySlashEffect;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.KnockBacks;
import mods.flammpfeil.slashblade.util.VectorHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class ExSlashEffect {

    public class MoonSlash {
        public static EntitySlashEffect create(LivingEntity playerIn, float roll, Vec3 centerOffset, boolean mute, boolean critical, double damage) {
            return MoonSlash.create(playerIn, roll, centerOffset, mute, critical, damage, KnockBacks.toss);
        }

        public static EntitySlashEffect create(LivingEntity playerIn, float roll, Vec3 centerOffset, boolean mute, boolean critical, double damage, KnockBacks knockback) {
            int colorCode = playerIn.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).map(state -> state.getColorCode()).orElse(0xC0C0C0);
            return MoonSlash.create(playerIn, roll, colorCode, centerOffset, mute, critical, damage, knockback);
        }

        public static EntitySlashEffect create(LivingEntity playerIn, float roll, int colorCode, Vec3 centerOffset, boolean mute, boolean critical, double damage, KnockBacks knockback) {
            if (playerIn.m_9236_().m_5776_()) {
                return null;
            }
            Vec3 pos = MoonSlash.calculateMoonPosition(playerIn, centerOffset);
            EntitySlashEffect jc = new EntitySlashEffect(SlashBlade.RegistryEvents.SlashEffect, playerIn.m_9236_());
            MoonSlash.configureMoonSlash(jc, playerIn, pos, roll, colorCode, mute, critical, damage, knockback);
            playerIn.m_9236_().m_7967_((Entity)jc);
            return jc;
        }

        private static Vec3 calculateMoonPosition(LivingEntity player, Vec3 centerOffset) {
            Vec3 base = player.m_20182_().m_82520_(0.0, (double)player.m_20192_() * 0.75, 0.0).m_82549_(player.m_20154_().m_82490_(0.3));
            Vec3 customOffset = new Vec3(3.0, 0.0, 0.0);
            return base.m_82549_(VectorHelper.getVectorForRotation((float)-90.0f, (float)player.m_5675_(0.0f)).m_82490_(centerOffset.f_82480_)).m_82549_(VectorHelper.getVectorForRotation((float)0.0f, (float)(player.m_5675_(0.0f) + 90.0f)).m_82490_(centerOffset.f_82481_)).m_82549_(customOffset);
        }

        private static void configureMoonSlash(EntitySlashEffect entity, LivingEntity player, Vec3 position, float roll, int color, boolean mute, boolean critical, double damage, KnockBacks knockback) {
            entity.m_6034_(position.f_82479_, position.f_82480_, position.f_82481_);
            entity.m_5602_((Entity)player);
            entity.setRotationRoll(roll);
            entity.m_146922_(player.m_146908_());
            entity.m_146926_(0.0f);
            entity.setColor(color);
            entity.setMute(mute);
            entity.setIsCritical(critical);
            entity.setDamage(damage);
            entity.setKnockBack(knockback);
            if (player != null) {
                player.getCapability(ConcentrationRankCapabilityProvider.RANK_POINT).ifPresent(rank -> entity.setRank(rank.getRankLevel(player.m_9236_().m_46467_())));
            }
            entity.setLifetime(15);
            entity.m_6593_((Component)Component.m_237113_((String)"MoonSlash"));
        }
    }
}

