/*
 * Decompiled with CFR 0.152.
 */
package com.tianyi.primeval.cilent.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.tianyi.primeval.Primeval;
import com.tianyi.primeval.entity.BigDriveEnity;
import javax.annotation.Nullable;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.util.BladeRenderState;
import mods.flammpfeil.slashblade.client.renderer.util.MSAutoCloser;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class BigDriveRenderer<T extends BigDriveEnity>
extends EntityRenderer<T> {
    private static final ResourceLocation TEXTURE = Primeval.prefix("model/util/big_drive.png");
    private static final ResourceLocation MODEL = Primeval.prefix("model/util/big_drive.obj");

    @Nullable
    public ResourceLocation getTextureLocation(T entity) {
        return entity.getTextureLoc();
    }

    public BigDriveRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack matrixStack, @NotNull MultiBufferSource bufferIn, int packedLightIn) {
        try (MSAutoCloser ignored = MSAutoCloser.pushMatrix((PoseStack)matrixStack);){
            float lifetime = ((BigDriveEnity)((Object)entity)).getLifetime();
            double deathTime = lifetime;
            double baseAlpha = Math.min(deathTime, (double)Math.max(0.0f, lifetime - (float)((BigDriveEnity)((Object)entity)).f_19797_)) / deathTime;
            baseAlpha = Math.max(0.0, -Math.pow(baseAlpha - 1.0, 4.0) + 0.75);
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14189_((float)partialTicks, (float)((BigDriveEnity)((Object)entity)).f_19859_, (float)entity.m_146908_()) - 90.0f));
            matrixStack.m_252781_(Axis.f_252403_.m_252977_(Mth.m_14189_((float)partialTicks, (float)((BigDriveEnity)((Object)entity)).f_19860_, (float)entity.m_146909_())));
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(((BigDriveEnity)((Object)entity)).getRotationRoll()));
            float scale = 0.015f;
            matrixStack.m_85841_(scale, scale, scale);
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            int color = ((BigDriveEnity)((Object)entity)).getColor() & 0xFFFFFF;
            int alpha = (0xFF & (int)(255.0 * baseAlpha)) << 24;
            WavefrontObject model = BladeModelManager.getInstance().getModel(MODEL);
            BladeRenderState.setCol((int)(color | alpha));
            BladeRenderState.renderOverridedLuminous((ItemStack)ItemStack.f_41583_, (WavefrontObject)model, (String)"base", (ResourceLocation)TEXTURE, (PoseStack)matrixStack, (MultiBufferSource)bufferIn, (int)packedLightIn);
        }
    }
}

