/*
 * Decompiled with CFR 0.152.
 */
package com.tianyi.primeval;

import com.mojang.logging.LogUtils;
import com.tianyi.primeval.registry.PLComboRegsitry;
import com.tianyi.primeval.registry.PLEntiteRegristrys;
import com.tianyi.primeval.registry.PLSpecialEffectsRegistry;
import com.tianyi.primeval.registry.PLslashArtRegsitry;
import com.tianyi.primeval.registry.ParticleRegistry;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.init.SBItems;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.registry.slashblade.SlashBladeDefinition;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Mod(value="primeval")
public class Primeval {
    public static final String MODID = "primeval";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"primeval");
    public static final RegistryObject<CreativeModeTab> Primeval = CREATIVE_MODE_TABS.register("primeval_slashblade", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"item_group.primeval.primeval_slashblade")).m_257737_(() -> {
        ItemStack stack = new ItemStack((ItemLike)SBItems.slashblade);
        stack.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(s -> {
            s.setModel(new ResourceLocation(MODID, "model/tianyi/yinyangpo.obj"));
            s.setTexture(new ResourceLocation(MODID, "model/tianyi/yinyang.png"));
        });
        return stack;
    }).m_257501_((parameters, tabData) -> com.tianyi.primeval.Primeval.fillBlades(tabData)).m_257652_());
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public static ResourceLocation prefix(String path) {
        return new ResourceLocation(MODID, path);
    }

    public static ResourceLocation id(@NotNull String path) {
        return new ResourceLocation(MODID, path);
    }

    public Primeval() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        PLSpecialEffectsRegistry.REGISTRY_KEY2.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::register);
        CREATIVE_MODE_TABS.register(modEventBus);
        ParticleRegistry.register(modEventBus);
        PLComboRegsitry.COMBO_STATES.register(modEventBus);
        PLslashArtRegsitry.SLASH_ARTS.register(modEventBus);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void fillBlades(CreativeModeTab.Output output) {
        if (Minecraft.m_91087_().m_91403_() != null) {
            BladeModelManager.getClientSlashBladeRegistry().m_6579_().stream().filter(entry -> entry.getKey() != null && entry.getValue() != null).filter(entry -> {
                ResourceLocation loc = ResourceLocation.m_135820_((String)((ResourceKey)entry.getKey()).m_135782_().toString());
                return loc != null && loc.m_135827_().equals(MODID);
            }).sorted(Map.Entry.comparingByKey()).forEach(entry -> {
                LOGGER.info("Registering Slashblade: {}", entry.getKey());
                output.m_246342_(((SlashBladeDefinition)entry.getValue()).getBlade());
            });
        }
    }

    public void register(RegisterEvent event) {
        PLEntiteRegristrys.register(event);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    @SubscribeEvent
    public static void onStunApplied(LivingAttackEvent event) {
        if (event.getSource().m_19385_().equals("stun")) {
            event.setCanceled(true);
        }
    }

    @Mod.EventBusSubscriber
    public static class CommonEvents {
        @SubscribeEvent
        public static void tick(TickEvent.ServerTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                ArrayList actions = new ArrayList();
                workQueue.forEach(work -> {
                    work.setValue((Integer)work.getValue() - 1);
                    if ((Integer)work.getValue() == 0) {
                        actions.add(work);
                    }
                });
                actions.forEach(e -> ((Runnable)e.getKey()).run());
                workQueue.removeAll(actions);
            }
        }
    }
}

