/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.singularity;

import com.blakebr0.cucumber.helper.NBTHelper;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.init.ModItems;
import com.blakebr0.extendedcrafting.singularity.Singularity;
import com.blakebr0.extendedcrafting.singularity.SingularityRegistry;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public final class SingularityUtils {
    public static Singularity loadFromJson(ResourceLocation id, JsonObject json) {
        Singularity singularity;
        String name = GsonHelper.m_13906_((JsonObject)json, (String)"name");
        JsonArray colors = GsonHelper.m_13933_((JsonObject)json, (String)"colors");
        int materialCount = GsonHelper.m_13824_((JsonObject)json, (String)"materialCount", (int)((Integer)ModConfigs.SINGULARITY_MATERIALS_REQUIRED.get()));
        int overlayColor = Integer.parseInt(colors.get(0).getAsString(), 16);
        int underlayColor = Integer.parseInt(colors.get(1).getAsString(), 16);
        boolean inUltimateSingularity = GsonHelper.m_13855_((JsonObject)json, (String)"inUltimateSingularity", (boolean)true);
        JsonObject ing = GsonHelper.m_13841_((JsonObject)json, (String)"ingredient", null);
        if (ing == null) {
            singularity = new Singularity(id, name, new int[]{overlayColor, underlayColor}, Ingredient.f_43901_, materialCount, inUltimateSingularity);
        } else if (ing.has("tag")) {
            String tag = ing.get("tag").getAsString();
            singularity = new Singularity(id, name, new int[]{overlayColor, underlayColor}, tag, materialCount, inUltimateSingularity);
        } else {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.get("ingredient"));
            singularity = new Singularity(id, name, new int[]{overlayColor, underlayColor}, ingredient, materialCount, inUltimateSingularity);
        }
        boolean enabled = GsonHelper.m_13855_((JsonObject)json, (String)"enabled", (boolean)true);
        singularity.setEnabled(enabled);
        return singularity;
    }

    public static JsonObject writeToJson(Singularity singularity) {
        JsonElement ingredient;
        JsonObject json = new JsonObject();
        json.addProperty("name", singularity.getName());
        JsonArray colors = new JsonArray();
        colors.add(Integer.toString(singularity.getOverlayColor(), 16));
        colors.add(Integer.toString(singularity.getUnderlayColor(), 16));
        json.add("colors", (JsonElement)colors);
        if (singularity.getTag() != null) {
            JsonObject obj = new JsonObject();
            obj.addProperty("tag", singularity.getTag());
            ingredient = obj;
        } else {
            ingredient = singularity.getIngredient().m_43942_();
        }
        json.add("ingredient", ingredient);
        if (!singularity.isEnabled()) {
            json.addProperty("enabled", Boolean.valueOf(false));
        }
        return json;
    }

    public static CompoundTag makeTag(Singularity singularity) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("Id", singularity.getId().toString());
        return nbt;
    }

    public static ItemStack getItemForSingularity(Singularity singularity) {
        CompoundTag nbt = SingularityUtils.makeTag(singularity);
        ItemStack stack = new ItemStack((ItemLike)ModItems.SINGULARITY.get());
        stack.m_41751_(nbt);
        return stack;
    }

    public static Singularity getSingularity(ItemStack stack) {
        String id = NBTHelper.getString((ItemStack)stack, (String)"Id");
        if (!id.isEmpty()) {
            return SingularityRegistry.getInstance().getSingularityById(ResourceLocation.m_135820_((String)id));
        }
        return null;
    }
}

