/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.network.message;

import com.blakebr0.cucumber.network.message.Message;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.extendedcrafting.tileentity.AutoEnderCrafterTileEntity;
import com.blakebr0.extendedcrafting.tileentity.AutoFluxCrafterTileEntity;
import com.blakebr0.extendedcrafting.tileentity.AutoTableTileEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class SaveRecipeMessage
extends Message<SaveRecipeMessage> {
    private final BlockPos pos;
    private final int selected;

    public SaveRecipeMessage() {
        this.pos = BlockPos.f_121853_;
        this.selected = -1;
    }

    public SaveRecipeMessage(BlockPos pos, int selected) {
        this.pos = pos;
        this.selected = selected;
    }

    public SaveRecipeMessage read(FriendlyByteBuf buffer) {
        return new SaveRecipeMessage(buffer.m_130135_(), buffer.m_130242_());
    }

    public void write(SaveRecipeMessage message, FriendlyByteBuf buffer) {
        buffer.m_130064_(message.pos);
        buffer.m_130130_(message.selected);
    }

    public void onMessage(SaveRecipeMessage message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player != null) {
                BaseInventoryTileEntity crafter;
                Level level = player.m_20193_();
                BlockEntity tile = level.m_7702_(message.pos);
                if (tile instanceof AutoTableTileEntity) {
                    AutoTableTileEntity table = (AutoTableTileEntity)tile;
                    if (!table.getRecipeStorage().hasRecipe(message.selected)) {
                        table.saveRecipe(message.selected);
                    } else {
                        table.deleteRecipe(message.selected);
                    }
                }
                if (tile instanceof AutoEnderCrafterTileEntity) {
                    crafter = (AutoEnderCrafterTileEntity)tile;
                    if (!crafter.getRecipeStorage().hasRecipe(message.selected)) {
                        crafter.saveRecipe(message.selected);
                    } else {
                        crafter.deleteRecipe(message.selected);
                    }
                }
                if (tile instanceof AutoFluxCrafterTileEntity) {
                    crafter = (AutoFluxCrafterTileEntity)tile;
                    if (!crafter.getRecipeStorage().hasRecipe(message.selected)) {
                        crafter.saveRecipe(message.selected);
                    } else {
                        crafter.deleteRecipe(message.selected);
                    }
                }
            }
        });
        context.get().setPacketHandled(true);
    }
}

