/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.crafting.recipe;

import com.blakebr0.extendedcrafting.crafting.recipe.ShapelessTableRecipe;
import com.blakebr0.extendedcrafting.init.ModItems;
import com.blakebr0.extendedcrafting.init.ModRecipeSerializers;
import com.blakebr0.extendedcrafting.singularity.SingularityRegistry;
import com.blakebr0.extendedcrafting.singularity.SingularityUtils;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandler;

public class UltimateSingularityRecipe
extends ShapelessTableRecipe {
    private static boolean ingredientsLoaded = false;

    public UltimateSingularityRecipe(ResourceLocation recipeId, ItemStack output) {
        super(recipeId, (NonNullList<Ingredient>)NonNullList.m_122779_(), output, 4);
    }

    @Override
    public NonNullList<Ingredient> m_7527_() {
        if (!ingredientsLoaded) {
            super.m_7527_().clear();
            SingularityRegistry.getInstance().getSingularities().stream().filter(singularity -> singularity.isInUltimateSingularity() && singularity.getIngredient() != Ingredient.f_43901_).limit(81L).map(SingularityUtils::getItemForSingularity).map(xva$0 -> Ingredient.m_43927_((ItemStack[])new ItemStack[]{xva$0})).forEach(arg_0 -> super.m_7527_().add(arg_0));
            ingredientsLoaded = true;
        }
        return super.m_7527_();
    }

    @Override
    public boolean matches(IItemHandler inventory) {
        NonNullList<Ingredient> ingredients = this.m_7527_();
        return !ingredients.isEmpty() && super.matches(inventory);
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.ULTIMATE_SINGULARITY.get();
    }

    public static void invalidate() {
        ingredientsLoaded = false;
    }

    public static class Serializer
    implements RecipeSerializer<UltimateSingularityRecipe> {
        public UltimateSingularityRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            return new UltimateSingularityRecipe(recipeId, new ItemStack((ItemLike)ModItems.ULTIMATE_SINGULARITY.get()));
        }

        public UltimateSingularityRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return new UltimateSingularityRecipe(recipeId, new ItemStack((ItemLike)ModItems.ULTIMATE_SINGULARITY.get()));
        }

        public void toNetwork(FriendlyByteBuf buffer, UltimateSingularityRecipe recipe) {
        }
    }
}

