/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.crafttweaker;

import com.blakebr0.extendedcrafting.api.crafting.ICombinationRecipe;
import com.blakebr0.extendedcrafting.crafting.recipe.CombinationRecipe;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.action.recipe.ActionRemoveRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.extendedcrafting.CombinationCrafting")
@ZenRegister
public final class CombinationCrafting
implements IRecipeManager<ICombinationRecipe> {
    private static final CombinationCrafting INSTANCE = new CombinationCrafting();

    public RecipeType<ICombinationRecipe> getRecipeType() {
        return (RecipeType)ModRecipeTypes.COMBINATION.get();
    }

    @ZenCodeType.Method
    public static void addRecipe(String name, IItemStack output, int cost, IIngredient[] inputs) {
        ResourceLocation id = CraftTweakerConstants.rl((String)INSTANCE.fixRecipeName(name));
        CombinationRecipe recipe = new CombinationRecipe(id, CombinationCrafting.toIngredientsList(inputs), output.getInternal(), cost);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)INSTANCE, (Recipe)recipe));
    }

    @ZenCodeType.Method
    public static void addRecipe(String name, IItemStack output, int cost, IIngredient[] inputs, int perTick) {
        ResourceLocation id = CraftTweakerConstants.rl((String)INSTANCE.fixRecipeName(name));
        CombinationRecipe recipe = new CombinationRecipe(id, CombinationCrafting.toIngredientsList(inputs), output.getInternal(), cost, perTick);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)INSTANCE, (Recipe)recipe));
    }

    @ZenCodeType.Method
    public static void remove(IItemStack stack) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveRecipe((IRecipeManager)INSTANCE, recipe -> recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_150930_(stack.getInternal().m_41720_())));
    }

    private static NonNullList<Ingredient> toIngredientsList(IIngredient ... ingredients) {
        return Arrays.stream(ingredients).map(IIngredient::asVanillaIngredient).collect(Collectors.toCollection(NonNullList::m_122779_));
    }
}

