/*
 * Decompiled with CFR 0.152.
 */
package com.tianyi.origin.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.tianyi.origin.Enitiy.XingqiuEntity;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class XingqiuRenderer
extends EntityRenderer<XingqiuEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("origincore", "textures/entity/xingqiu.png");
    private static final ResourceLocation OBJ_MODEL = new ResourceLocation("origincore", "models/fazhen/xingqiu.obj");
    private static List<float[]> vertices = new ArrayList<float[]>();
    private static List<int[]> faces = new ArrayList<int[]>();
    private static boolean modelLoaded = false;

    public XingqiuRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    private void loadModel() {
        if (modelLoaded) {
            return;
        }
        try {
            String line;
            ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
            InputStream inputStream = ((Resource)resourceManager.m_213713_(OBJ_MODEL).orElseThrow()).m_215507_();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            vertices.clear();
            faces.clear();
            while ((line = reader.readLine()) != null) {
                String[] parts;
                if ((line = line.trim()).startsWith("v ") && !line.startsWith("vt ") && !line.startsWith("vn ")) {
                    parts = line.split("\\s+");
                    if (parts.length < 4) continue;
                    float x = Float.parseFloat(parts[1]) * 0.01f;
                    float y = Float.parseFloat(parts[2]) * 0.01f;
                    float z = Float.parseFloat(parts[3]) * 0.01f;
                    vertices.add(new float[]{x, y, z});
                    continue;
                }
                if (!line.startsWith("f ") || (parts = line.split("\\s+")).length < 4) continue;
                int v1 = this.parseVertexIndex(parts[1]);
                int v2 = this.parseVertexIndex(parts[2]);
                int v3 = this.parseVertexIndex(parts[3]);
                if (v1 < 0 || v1 >= vertices.size() || v2 < 0 || v2 >= vertices.size() || v3 < 0 || v3 >= vertices.size()) continue;
                faces.add(new int[]{v1, v2, v3});
            }
            reader.close();
            modelLoaded = true;
            System.out.println("[XingqiuRenderer] \u6a21\u578b\u52a0\u8f7d\u6210\u529f: " + vertices.size() + " \u9876\u70b9, " + faces.size() + " \u9762");
        }
        catch (Exception e) {
            System.err.println("[XingqiuRenderer] \u6a21\u578b\u52a0\u8f7d\u5931\u8d25:");
            e.printStackTrace();
        }
    }

    private int parseVertexIndex(String indexStr) {
        String[] parts = indexStr.split("/");
        return Integer.parseInt(parts[0]) - 1;
    }

    public void render(XingqiuEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (!modelLoaded) {
            this.loadModel();
        }
        if (vertices.isEmpty() || faces.isEmpty()) {
            return;
        }
        poseStack.m_85836_();
        float rotation = entity.getRotation(partialTick);
        float scale = entity.getScale();
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
        int red = entity.getColorRed();
        int green = entity.getColorGreen();
        int blue = entity.getColorBlue();
        int alpha = entity.getAlpha();
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110488_((ResourceLocation)this.getTextureLocation(entity)));
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f matrix4f = pose.m_252922_();
        Matrix3f matrix3f = pose.m_252943_();
        int fullBright = 0xF000F0;
        for (int[] face : faces) {
            if (face.length < 3) continue;
            int idx0 = face[0];
            int idx1 = face[1];
            int idx2 = face[2];
            if (idx0 >= vertices.size() || idx1 >= vertices.size() || idx2 >= vertices.size()) continue;
            float[] v0 = vertices.get(idx0);
            float[] v1 = vertices.get(idx1);
            float[] v2 = vertices.get(idx2);
            float[] normal = this.calculateNormal(v0, v1, v2);
            this.renderVertex(vertexConsumer, matrix4f, matrix3f, v0, normal, red, green, blue, alpha, fullBright);
            this.renderVertex(vertexConsumer, matrix4f, matrix3f, v1, normal, red, green, blue, alpha, fullBright);
            this.renderVertex(vertexConsumer, matrix4f, matrix3f, v2, normal, red, green, blue, alpha, fullBright);
        }
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    private float[] calculateNormal(float[] v0, float[] v1, float[] v2) {
        float e1y = v1[1] - v0[1];
        float e2z = v2[2] - v0[2];
        float e1z = v1[2] - v0[2];
        float e2y = v2[1] - v0[1];
        float nx = e1y * e2z - e1z * e2y;
        float e2x = v2[0] - v0[0];
        float e1x = v1[0] - v0[0];
        float ny = e1z * e2x - e1x * e2z;
        float nz = e1x * e2y - e1y * e2x;
        float length = (float)Math.sqrt(nx * nx + ny * ny + nz * nz);
        if (length > 1.0E-4f) {
            nx /= length;
            ny /= length;
            nz /= length;
        }
        return new float[]{nx, ny, nz};
    }

    private void renderVertex(VertexConsumer consumer, Matrix4f matrix4f, Matrix3f matrix3f, float[] pos, float[] normal, int red, int green, int blue, int alpha, int packedLight) {
        consumer.m_252986_(matrix4f, pos[0], pos[1], pos[2]).m_6122_(red, green, blue, alpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(matrix3f, normal[0], normal[1], normal[2]).m_5752_();
    }

    public ResourceLocation getTextureLocation(XingqiuEntity entity) {
        return TEXTURE;
    }
}

