/*
 * Decompiled with CFR 0.152.
 */
package com.tianyi.origin.menu;

import com.tianyi.origin.core.Registration;
import com.tianyi.origin.item.Box.EndxBox;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class BoxContainer
extends AbstractContainerMenu {
    private final ItemStack boxStack;
    private final ItemStackHandler handler;
    private static final int ROWS = 12;
    private static final int COLUMNS = 21;
    private static final int PLAYER_SLOTS = 36;
    private static final int CONTAINER_HEIGHT = 234;
    private static final int CONTAINER_SLOTS = 252;
    private static final int TOTAL_SLOTS = 288;

    public BoxContainer(int windowId, Inventory playerInv, ItemStack stack) {
        super((MenuType)Registration.BOX_CONTAINER.get(), windowId);
        int col;
        int row;
        final Player player = playerInv.f_35978_;
        this.boxStack = stack;
        this.handler = new ItemStackHandler(252){

            protected void onContentsChanged(int slot) {
                if (!player.m_9236_().f_46443_) {
                    BoxContainer.this.saveInventoryToNBT();
                }
            }
        };
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInv, col + row * 9 + 9, 114 + col * 18, 237 + row * 18));
            }
        }
        for (int col2 = 0; col2 < 9; ++col2) {
            this.m_38897_(new Slot((Container)playerInv, col2, 114 + col2 * 18, 296));
        }
        for (row = 0; row < 12; ++row) {
            for (col = 0; col < 21; ++col) {
                int slotIndex = row * 21 + col;
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.handler, slotIndex, 7 + col * 18, 9 + row * 18){

                    public boolean m_5857_(ItemStack stack) {
                        return !(stack.m_41720_() instanceof EndxBox);
                    }
                });
            }
        }
        ListTag items = this.getInventoryTag();
        for (int i = 0; i < Math.min(items.size(), 252); ++i) {
            this.handler.setStackInSlot(i, ItemStack.m_41712_((CompoundTag)items.m_128728_(i)));
        }
    }

    private void saveInventoryToNBT() {
        ListTag items = new ListTag();
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            items.add((Object)this.handler.getStackInSlot(i).m_41739_(new CompoundTag()));
        }
        this.boxStack.m_41784_().m_128365_("BoxInventory", (Tag)items);
    }

    private ListTag getInventoryTag() {
        CompoundTag tag = this.boxStack.m_41784_();
        if (!tag.m_128441_("DataVersion")) {
            // empty if block
        }
        ListTag list = tag.m_128437_("BoxInventory", 10);
        while (list.size() < 252) {
            list.add((Object)new CompoundTag());
        }
        return list;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack copyStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            copyStack = slotStack.m_41777_();
            if (slotStack.m_41720_() instanceof EndxBox) {
                return ItemStack.f_41583_;
            }
            if (index < 36 ? !this.m_38903_(slotStack, 36, 288, false) : !this.m_38903_(slotStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return copyStack;
    }

    public boolean m_6875_(Player player) {
        return ItemStack.m_41728_((ItemStack)player.m_21120_(InteractionHand.MAIN_HAND), (ItemStack)this.boxStack) || ItemStack.m_41728_((ItemStack)player.m_21120_(InteractionHand.OFF_HAND), (ItemStack)this.boxStack);
    }

    public void m_6877_(Player player) {
        if (!player.m_9236_().f_46443_) {
            this.saveInventoryToNBT();
            player.m_150109_().m_6596_();
        }
        super.m_6877_(player);
    }

    public static BoxContainer fromNetwork(int windowId, Inventory inv, FriendlyByteBuf data) {
        ItemStack stack = data.m_130267_();
        return new BoxContainer(windowId, inv, stack);
    }
}

