/*
 * Decompiled with CFR 0.152.
 */
package com.tianyi.origin.item.custom;

import com.tianyi.origin.Utils.LocalUtil;
import com.tianyi.origin.dimension.MiningDimensionTeleporter;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.ITeleporter;
import org.jetbrains.annotations.Nullable;

public class TeleportationItem
extends Item {
    public static final ResourceKey<Level> MAIN_WORLD_DIMENSION = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("overworld"));
    public static final ResourceKey<Level> MINING_WORLD_DIMENSION = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("origincore", "mining"));

    public TeleportationItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public void m_7373_(ItemStack timestack, @Nullable Level pLevel, List<Component> list, TooltipFlag flag) {
        list.add(LocalUtil.returnner("hoo_1"));
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        Level level = pContext.m_43725_();
        if (!level.f_46443_) {
            ServerPlayer player = (ServerPlayer)pContext.m_43723_();
            if (player.m_20159_()) {
                player.m_5661_((Component)Component.m_237113_((String)"Please dismout before using the teleporter."), true);
                return InteractionResult.FAIL;
            }
            if (player.m_9236_().m_46472_() == MAIN_WORLD_DIMENSION) {
                this.teleportToMiningWorld(player, player.m_20097_());
            } else if (player.m_9236_().m_46472_() == MINING_WORLD_DIMENSION) {
                this.teleportToMainWorld(player, player.m_20097_());
            } else {
                player.m_5661_((Component)Component.m_237113_((String)"Cannot teleport from this dimension."), true);
                return InteractionResult.FAIL;
            }
            player.m_36335_().m_41524_((Item)this, 20);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (!level.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (serverPlayer.m_20159_()) {
                serverPlayer.m_5661_((Component)Component.m_237113_((String)"Please dismout before using the teleporter."), true);
                return InteractionResultHolder.m_19100_((Object)itemStack);
            }
            if (serverPlayer.m_9236_().m_46472_() == MAIN_WORLD_DIMENSION) {
                this.teleportToMiningWorld(serverPlayer, serverPlayer.m_20097_());
            } else if (serverPlayer.m_9236_().m_46472_() == MINING_WORLD_DIMENSION) {
                this.teleportToMainWorld(serverPlayer, serverPlayer.m_20097_());
            } else {
                serverPlayer.m_5661_((Component)Component.m_237113_((String)"Cannot teleport from this dimension."), true);
                return InteractionResultHolder.m_19100_((Object)itemStack);
            }
            serverPlayer.m_36335_().m_41524_((Item)this, 20);
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    private void teleportToMiningWorld(ServerPlayer player, BlockPos pos) {
        ServerLevel miningWorld = player.m_20194_().m_129880_(MINING_WORLD_DIMENSION);
        if (miningWorld != null) {
            player.changeDimension(miningWorld, (ITeleporter)new MiningDimensionTeleporter(pos));
        } else {
            player.m_5661_((Component)Component.m_237113_((String)"You have entered the place of origin"), true);
        }
    }

    private void teleportToMainWorld(ServerPlayer player, BlockPos pos) {
        ServerLevel mainWorld = player.m_20194_().m_129880_(MAIN_WORLD_DIMENSION);
        if (mainWorld != null) {
            player.changeDimension(mainWorld, (ITeleporter)new MiningDimensionTeleporter(mainWorld.m_220360_()));
        } else {
            player.m_5661_((Component)Component.m_237113_((String)"You have left the place of origin"), true);
        }
    }
}

