/*
 * Decompiled with CFR 0.152.
 */
package com.tianyi.origin.dimension;

import com.tianyi.origin.origincore;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class SchematicLoader {
    public static boolean loadAndPlace(ServerLevel world, ResourceLocation schematicLocation, BlockPos position) {
        boolean bl;
        block14: {
            origincore.LOGGER.info("Loading schematic from resource: " + schematicLocation);
            Optional resourceOpt = world.m_7654_().m_177941_().m_213713_(schematicLocation);
            if (resourceOpt.isEmpty()) {
                origincore.LOGGER.error("Schematic resource not found: " + schematicLocation);
                return false;
            }
            Resource resource = (Resource)resourceOpt.get();
            InputStream in = resource.m_215507_();
            try {
                CompoundTag rootTag = NbtIo.m_128939_((InputStream)in);
                int version = rootTag.m_128451_("Version");
                origincore.LOGGER.info("Schematic version: " + version);
                int width = rootTag.m_128448_("Width");
                int height = rootTag.m_128448_("Height");
                int length = rootTag.m_128448_("Length");
                origincore.LOGGER.info("Schematic size: " + (short)width + "x" + (short)height + "x" + (short)length);
                CompoundTag paletteTag = rootTag.m_128469_("Palette");
                Map<Integer, BlockState> palette = SchematicLoader.parsePalette(paletteTag);
                byte[] blockDataBytes = rootTag.m_128463_("BlockData");
                int[] blockData = SchematicLoader.decodeVarIntArray(blockDataBytes);
                int offsetX = -width / 2;
                int offsetY = 0;
                int offsetZ = -length / 2;
                BlockPos placePos = position.m_7918_(offsetX, offsetY, offsetZ);
                origincore.LOGGER.info("Placing schematic at: " + placePos);
                int blocksPlaced = 0;
                int index = 0;
                for (int y = 0; y < height; ++y) {
                    block8: for (int z = 0; z < length; ++z) {
                        for (int x = 0; x < width; ++x) {
                            int paletteId;
                            BlockState blockState;
                            if (index >= blockData.length) {
                                origincore.LOGGER.warn("BlockData array too short, stopping placement");
                                continue block8;
                            }
                            if ((blockState = palette.get(paletteId = blockData[index++])) == null || blockState.m_60795_()) continue;
                            BlockPos worldPos = placePos.m_7918_(x, y, z);
                            world.m_7731_(worldPos, blockState, 2);
                            ++blocksPlaced;
                        }
                    }
                }
                if (rootTag.m_128425_("BlockEntities", 9)) {
                    ListTag blockEntities = rootTag.m_128437_("BlockEntities", 10);
                    SchematicLoader.placeBlockEntities(world, placePos, blockEntities);
                }
                origincore.LOGGER.info("Successfully placed " + blocksPlaced + " blocks from schematic");
                bl = true;
                if (in == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    origincore.LOGGER.error("Failed to load schematic: " + e.getMessage(), (Throwable)e);
                    return false;
                }
            }
            in.close();
        }
        return bl;
    }

    private static Map<Integer, BlockState> parsePalette(CompoundTag paletteTag) {
        HashMap<Integer, BlockState> palette = new HashMap<Integer, BlockState>();
        for (String key : paletteTag.m_128431_()) {
            int id = paletteTag.m_128451_(key);
            try {
                BlockState blockState = SchematicLoader.parseBlockState(key);
                palette.put(id, blockState);
            }
            catch (Exception e) {
                origincore.LOGGER.warn("Failed to parse block state: " + key);
                palette.put(id, Blocks.f_50016_.m_49966_());
            }
        }
        return palette;
    }

    private static BlockState parseBlockState(String blockString) {
        String[] parts = blockString.split("\\[", 2);
        String blockId = parts[0];
        ResourceLocation blockLoc = new ResourceLocation(blockId);
        Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(blockLoc);
        if (block == null || block == Blocks.f_50016_) {
            return Blocks.f_50016_.m_49966_();
        }
        BlockState state = block.m_49966_();
        if (parts.length > 1) {
            String[] propertyPairs;
            String properties = parts[1].replace("]", "");
            for (String pair : propertyPairs = properties.split(",")) {
                String[] keyValue = pair.split("=");
                if (keyValue.length != 2) continue;
                String propName = keyValue[0].trim();
                String propValue = keyValue[1].trim();
                state = SchematicLoader.applyProperty(state, propName, propValue);
            }
        }
        return state;
    }

    private static BlockState applyProperty(BlockState state, String name, String value) {
        try {
            return state;
        }
        catch (Exception e) {
            return state;
        }
    }

    private static int[] decodeVarIntArray(byte[] data) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int i = 0;
        while (i < data.length) {
            int value = 0;
            int shift = 0;
            while (i < data.length) {
                byte b = data[i++];
                value |= (b & 0x7F) << shift;
                if ((b & 0x80) == 0) break;
                shift += 7;
            }
            result.add(value);
        }
        return result.stream().mapToInt(Integer::intValue).toArray();
    }

    private static void placeBlockEntities(ServerLevel world, BlockPos origin, ListTag blockEntities) {
        for (int i = 0; i < blockEntities.size(); ++i) {
            CompoundTag entityTag = blockEntities.m_128728_(i);
            try {
                BlockPos worldPos;
                BlockEntity blockEntity;
                int[] pos = entityTag.m_128465_("Pos");
                if (pos.length != 3 || (blockEntity = world.m_7702_(worldPos = origin.m_7918_(pos[0], pos[1], pos[2]))) == null) continue;
                CompoundTag data = entityTag.m_6426_();
                data.m_128405_("x", worldPos.m_123341_());
                data.m_128405_("y", worldPos.m_123342_());
                data.m_128405_("z", worldPos.m_123343_());
                blockEntity.m_142466_(data);
                continue;
            }
            catch (Exception e) {
                origincore.LOGGER.warn("Failed to place block entity: " + e.getMessage());
            }
        }
    }
}

