/*
 * Decompiled with CFR 0.152.
 */
package com.tianyi.origin.dimension;

import com.tianyi.origin.dimension.MiningWorldSavedData;
import com.tianyi.origin.dimension.SchematicLoader;
import com.tianyi.origin.item.custom.TeleportationItem;
import com.tianyi.origin.origincore;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;

public class MiningDimensionTeleporter
implements ITeleporter {
    private BlockPos pos;
    private static final BlockPos FIXED_SPAWN_POS = new BlockPos(0, 201, -73);
    private static final BlockPos STRUCTURE_SPAWN_POS = new BlockPos(0, 200, 0);
    private static final ResourceLocation SCHEMATIC_LOCATION = new ResourceLocation("origincore", "structures/jingjichang930x.schem");

    public MiningDimensionTeleporter(BlockPos pos) {
        this.pos = pos;
    }

    public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
        double targetZ;
        double targetY;
        double targetX;
        Entity e = repositionEntity.apply(false);
        if (!(e instanceof ServerPlayer)) {
            return e;
        }
        ServerPlayer player = (ServerPlayer)e;
        if (destWorld.m_46472_().equals(TeleportationItem.MINING_WORLD_DIMENSION)) {
            origincore.LOGGER.info("Teleporting player to mining dimension at fixed position");
            this.tryGenerateStructure(destWorld);
            this.ensureSafeSpawn(destWorld, FIXED_SPAWN_POS);
            targetX = (double)FIXED_SPAWN_POS.m_123341_() + 0.5;
            targetY = FIXED_SPAWN_POS.m_123342_();
            targetZ = FIXED_SPAWN_POS.m_123343_();
            origincore.LOGGER.info("Target position: X=" + targetX + ", Y=" + targetY + ", Z=" + targetZ);
        } else {
            BlockPos spawn = destWorld.m_220360_();
            targetX = (double)spawn.m_123341_() + 0.5;
            targetY = (double)spawn.m_123342_() + 1.0;
            targetZ = (double)spawn.m_123343_() + 0.5;
        }
        player.f_8906_.m_9774_(targetX, targetY, targetZ, player.m_146908_(), player.m_146909_());
        return e;
    }

    private void ensureSafeSpawn(ServerLevel world, BlockPos spawnPos) {
        BlockPos below = spawnPos.m_7495_();
        if (world.m_8055_(below).m_60795_()) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos platformPos = below.m_7918_(x, 0, z);
                    if (!world.m_8055_(platformPos).m_60795_()) continue;
                    world.m_46597_(platformPos, Blocks.f_50069_.m_49966_());
                }
            }
        }
        BlockPos headPos = spawnPos.m_7494_();
        BlockPos aboveHead = headPos.m_7494_();
        if (!world.m_8055_(spawnPos).m_60795_()) {
            world.m_46597_(spawnPos, Blocks.f_50016_.m_49966_());
        }
        if (!world.m_8055_(headPos).m_60795_()) {
            world.m_46597_(headPos, Blocks.f_50016_.m_49966_());
        }
        if (!world.m_8055_(aboveHead).m_60795_()) {
            world.m_46597_(aboveHead, Blocks.f_50016_.m_49966_());
        }
    }

    private void tryGenerateStructure(ServerLevel world) {
        MiningWorldSavedData savedData = MiningWorldSavedData.get(world);
        if (savedData.isStructureGenerated()) {
            origincore.LOGGER.info("Structure already generated, skipping");
            return;
        }
        origincore.LOGGER.info("Attempting to generate schematic structure: " + SCHEMATIC_LOCATION);
        boolean success = SchematicLoader.loadAndPlace(world, SCHEMATIC_LOCATION, STRUCTURE_SPAWN_POS);
        if (success) {
            origincore.LOGGER.info("Schematic structure generated successfully at: " + STRUCTURE_SPAWN_POS);
            savedData.setStructureGenerated(true);
        } else {
            origincore.LOGGER.error("Failed to load schematic from resources: " + SCHEMATIC_LOCATION);
            origincore.LOGGER.error("Please ensure the file exists at: data/origincore/structures/jingjichang930x.schem");
        }
    }

    @Nullable
    private Vec3 findPortalInChunk(LevelChunk chunk) {
        return new Vec3(0.0, 0.0, 0.0);
    }

    private static Vec3 getTeleporterSpawnPos(Level level, BlockPos blockPos) {
        return DismountHelper.m_38441_((EntityType)EntityType.f_20532_, (CollisionGetter)level, (BlockPos)blockPos.m_7494_(), (boolean)false);
    }

    private Vec3 placeTeleporterMining(ServerLevel world, LevelChunk chunk) {
        int z;
        int x;
        int y;
        boolean deep = false;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int min = world.m_141937_();
        int max = world.m_151558_() - 10;
        int n = y = deep ? min : max - 1;
        while (deep ? y < max - 1 : y >= min) {
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    pos.m_122178_(x, y, z);
                    if (!chunk.m_8055_((BlockPos)pos).m_60795_() || !chunk.m_8055_(pos.m_6630_(1)).m_60795_() || !chunk.m_8055_(pos.m_6630_(2)).m_60795_()) continue;
                    BlockPos absolutePos = chunk.m_7697_().m_45615_().m_7918_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                    return new Vec3((double)absolutePos.m_123341_() + 0.5, (double)(absolutePos.m_123342_() + 1), (double)absolutePos.m_123343_() + 0.5);
                }
            }
            y = deep ? y + 1 : y - 1;
        }
        int n2 = y = deep ? min : max - 1;
        while (deep ? y < max - 1 : y >= min) {
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    BlockPos absolutePos;
                    pos.m_122178_(x, y, z);
                    if (!this.isAirOrStone(chunk, (BlockPos)pos) || !this.isAirOrStone(chunk, pos.m_6630_(1)) || !this.isAirOrStone(chunk, pos.m_6630_(2)) || !this.isReplaceable((Level)world, (absolutePos = chunk.m_7697_().m_45615_().m_7918_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_())).m_6630_(3)) || !this.isReplaceable((Level)world, absolutePos.m_6630_(1).m_121945_(Direction.NORTH)) || !this.isReplaceable((Level)world, absolutePos.m_6630_(1).m_121945_(Direction.NORTH)) || !this.isReplaceable((Level)world, absolutePos.m_6630_(1).m_121945_(Direction.SOUTH)) || !this.isReplaceable((Level)world, absolutePos.m_6630_(1).m_121945_(Direction.EAST)) || !this.isReplaceable((Level)world, absolutePos.m_6630_(1).m_121945_(Direction.WEST)) || !this.isReplaceable((Level)world, absolutePos.m_6630_(2).m_121945_(Direction.NORTH)) || !this.isReplaceable((Level)world, absolutePos.m_6630_(2).m_121945_(Direction.SOUTH)) || !this.isReplaceable((Level)world, absolutePos.m_6630_(2).m_121945_(Direction.EAST)) || !this.isReplaceable((Level)world, absolutePos.m_6630_(2).m_121945_(Direction.WEST))) continue;
                    world.m_46597_(absolutePos.m_6630_(1), Blocks.f_50016_.m_49966_());
                    world.m_46597_(absolutePos.m_6630_(2), Blocks.f_50016_.m_49966_());
                    world.m_46597_(absolutePos.m_6630_(3), Blocks.f_50069_.m_49966_());
                    world.m_46597_(absolutePos.m_6630_(1).m_121945_(Direction.NORTH), Blocks.f_50069_.m_49966_());
                    world.m_46597_(absolutePos.m_6630_(1).m_121945_(Direction.SOUTH), Blocks.f_50069_.m_49966_());
                    world.m_46597_(absolutePos.m_6630_(1).m_121945_(Direction.EAST), Blocks.f_50069_.m_49966_());
                    world.m_46597_(absolutePos.m_6630_(1).m_121945_(Direction.WEST), Blocks.f_50069_.m_49966_());
                    world.m_46597_(absolutePos.m_6630_(2).m_121945_(Direction.NORTH), Blocks.f_50069_.m_49966_());
                    world.m_46597_(absolutePos.m_6630_(2).m_121945_(Direction.SOUTH), Blocks.f_50069_.m_49966_());
                    world.m_46597_(absolutePos.m_6630_(2).m_121945_(Direction.EAST), Blocks.f_50069_.m_49966_());
                    world.m_46597_(absolutePos.m_6630_(2).m_121945_(Direction.WEST), Blocks.f_50069_.m_49966_());
                    return new Vec3((double)absolutePos.m_123341_() + 0.5, (double)(absolutePos.m_123342_() + 1), (double)absolutePos.m_123343_() + 0.5);
                }
            }
            y = deep ? y + 1 : y - 1;
        }
        return null;
    }

    private boolean isAirOrStone(LevelChunk chunk, BlockPos pos) {
        BlockState state = chunk.m_8055_(pos);
        return state.m_60734_().equals(Blocks.f_50069_) || state.m_60795_();
    }

    private boolean isReplaceable(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return state.m_60734_().equals(Blocks.f_50069_) || state.m_60734_().equals(Blocks.f_50122_) || state.m_60734_().equals(Blocks.f_50334_) || state.m_60734_().equals(Blocks.f_50228_) || state.m_60734_().equals(Blocks.f_50493_) || state.m_60734_().equals(Blocks.f_49994_) || state.m_60734_().equals(Blocks.f_49991_) || state.m_60795_();
    }

    private Vec3 placeTeleporterOverworld(ServerLevel world, LevelChunk chunk) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = world.m_151558_(); y >= world.m_141937_(); --y) {
                    pos.m_122178_(x, y, z);
                    if (!chunk.m_8055_((BlockPos)pos).m_60795_() || !chunk.m_8055_(pos.m_6630_(1)).m_60795_() || !chunk.m_8055_(pos.m_6630_(2)).m_60795_() || chunk.m_8055_(pos.m_7495_()).m_60795_()) continue;
                    BlockPos absolutePos = chunk.m_7697_().m_45615_().m_7918_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                    return new Vec3((double)absolutePos.m_123341_() + 0.5, (double)(absolutePos.m_123342_() + 1), (double)absolutePos.m_123343_() + 0.5);
                }
            }
        }
        return null;
    }
}

