/*
 * Decompiled with CFR 0.152.
 */
package com.tianyi.origin.data;

import com.tianyi.origin.data.ModBlockModelGen;
import com.tianyi.origin.data.ModBlockTagGen;
import com.tianyi.origin.data.ModItemModelGen;
import com.tianyi.origin.data.ModLangGen;
import com.tianyi.origin.data.ModLootTableGen;
import com.tianyi.origin.data.ModRecipesGen;
import com.tianyi.origin.data.ModWorldGen;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="origincore", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        generator.addProvider(event.includeClient(), (DataProvider)new ModLangGen(output, "en_us"));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelGen(output, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModBlockModelGen(output, helper));
        ModBlockTagGen blockModelGen = new ModBlockTagGen(output, lookupProvider, event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)blockModelGen);
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(output, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(ModLootTableGen::new, LootContextParamSets.f_81421_))));
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipesGen(output));
        generator.addProvider(event.includeServer(), (DataProvider)new ModWorldGen(output, lookupProvider));
    }
}

