/*
 * Decompiled with CFR 0.152.
 */
package com.tianyi.origin.client;

import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientProxy {
    private static boolean magicCircleEffectActive = false;
    private static long effectStartTime = 0L;
    private static float shakeIntensity = 0.0f;
    private static long lastShakeTime = 0L;

    public static void setMagicCircleEffect(boolean active) {
        magicCircleEffectActive = active;
        if (active) {
            effectStartTime = System.currentTimeMillis();
            shakeIntensity = 0.3f;
        } else {
            shakeIntensity = 0.0f;
        }
    }

    public static boolean isMagicCircleEffectActive() {
        return magicCircleEffectActive;
    }

    public static float getWhiteScreenOpacity() {
        if (!magicCircleEffectActive) {
            return 0.0f;
        }
        long elapsed = System.currentTimeMillis() - effectStartTime;
        if (elapsed < 500L) {
            return (float)elapsed / 500.0f * 0.9f;
        }
        if (elapsed < 1500L) {
            return 0.9f;
        }
        if (elapsed < 2000L) {
            return 0.9f * (1.0f - (float)(elapsed - 1500L) / 500.0f);
        }
        return 0.0f;
    }

    public static float getShakeOffset(boolean isX) {
        if (!magicCircleEffectActive || shakeIntensity <= 0.0f) {
            return 0.0f;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastShakeTime > 50L) {
            lastShakeTime = currentTime;
        }
        double seed = (double)currentTime / 50.0 * (isX ? 1.0 : 1.7);
        return (float)(Math.sin(seed * Math.PI) * (double)shakeIntensity * 10.0);
    }
}

