/*
 * Decompiled with CFR 0.152.
 */
package com.tianyi.origin.client;

import com.tianyi.origin.Enitiy.DenLisBoss;
import com.tianyi.origin.Enitiy.DenLisTwo;
import com.tianyi.origin.core.ModSounds;
import com.tianyi.origin.origincore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.MusicManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="origincore", value={Dist.CLIENT})
public class BossMusicManager {
    private static final Map<UUID, BossMusicData> ACTIVE_BOSS_MUSIC = new HashMap<UUID, BossMusicData>();
    private static final float FADE_IN_DURATION = 60.0f;
    private static final float FADE_OUT_DURATION = 40.0f;
    private static final double MUSIC_RANGE = 129.0;
    private static final boolean DEBUG_MODE = false;
    private static boolean vanillaMusicStopped = false;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            BossMusicManager.stopAllMusic();
            BossMusicManager.restoreVanillaMusic(mc);
            return;
        }
        boolean foundPhaseOneBoss = false;
        boolean foundPhaseTwoBoss = false;
        UUID phaseOneBossId = null;
        UUID phaseTwoBossId = null;
        for (Entity entity : mc.f_91073_.m_104735_()) {
            DenLisTwo bossTwo;
            double distance;
            DenLisBoss boss;
            if (entity instanceof DenLisBoss && (boss = (DenLisBoss)entity).isBossAlive() && (distance = (double)mc.f_91074_.m_20270_((Entity)boss)) <= 129.0) {
                foundPhaseOneBoss = true;
                phaseOneBossId = boss.m_20148_();
            }
            if (!(entity instanceof DenLisTwo) || !(bossTwo = (DenLisTwo)entity).isBossAlive() || !((distance = (double)mc.f_91074_.m_20270_((Entity)bossTwo)) <= 129.0)) continue;
            foundPhaseTwoBoss = true;
            phaseTwoBossId = bossTwo.m_20148_();
        }
        if (foundPhaseTwoBoss && phaseTwoBossId != null) {
            BossMusicManager.stopVanillaMusic(mc);
            BossMusicManager.stopPhaseOneMusic();
            if (!ACTIVE_BOSS_MUSIC.containsKey(phaseTwoBossId)) {
                origincore.LOGGER.info("Boss\u4e8c\u9636\u6bb5\u5728\u8303\u56f4\u5185\uff0c\u5f00\u59cb\u64ad\u653e\u97f3\u4e50");
                BossMusicManager.startBossMusic(phaseTwoBossId, true);
            }
        } else if (foundPhaseOneBoss && phaseOneBossId != null) {
            BossMusicManager.stopVanillaMusic(mc);
            if (!ACTIVE_BOSS_MUSIC.containsKey(phaseOneBossId)) {
                origincore.LOGGER.info("Boss\u4e00\u9636\u6bb5\u5728\u8303\u56f4\u5185\uff0c\u5f00\u59cb\u64ad\u653e\u97f3\u4e50");
                BossMusicManager.startBossMusic(phaseOneBossId, false);
            }
        } else {
            for (UUID bossId : new ArrayList<UUID>(ACTIVE_BOSS_MUSIC.keySet())) {
                BossMusicManager.startFadeOut(bossId);
            }
        }
        if (!ACTIVE_BOSS_MUSIC.isEmpty()) {
            BossMusicManager.stopVanillaMusic(mc);
        }
        if (ACTIVE_BOSS_MUSIC.isEmpty()) {
            BossMusicManager.restoreVanillaMusic(mc);
        }
        ACTIVE_BOSS_MUSIC.entrySet().removeIf(entry -> {
            BossMusicData data = (BossMusicData)entry.getValue();
            boolean isStopped = data.soundInstance.m_7801_();
            if (isStopped && ACTIVE_BOSS_MUSIC.size() == 1) {
                BossMusicManager.restoreVanillaMusic(mc);
            }
            return isStopped;
        });
    }

    private static void stopPhaseOneMusic() {
        ACTIVE_BOSS_MUSIC.entrySet().removeIf(entry -> {
            BossMusicData data = (BossMusicData)entry.getValue();
            if (!data.isPhaseTwo) {
                data.soundInstance.stopImmediately();
                origincore.LOGGER.info("\u505c\u6b62\u4e00\u9636\u6bb5\u97f3\u4e50\uff0c\u5207\u6362\u5230\u4e8c\u9636\u6bb5");
                return true;
            }
            return false;
        });
    }

    private static void startBossMusic(UUID bossId, boolean isPhaseTwo) {
        Minecraft mc = Minecraft.m_91087_();
        String phaseStr = isPhaseTwo ? "\u4e8c\u9636\u6bb5" : "\u4e00\u9636\u6bb5";
        origincore.LOGGER.info("\u5f00\u59cb\u64ad\u653eBoss{}\u97f3\u4e50: {}", (Object)phaseStr, (Object)bossId);
        try {
            SoundEvent soundEvent = isPhaseTwo ? (SoundEvent)ModSounds.BOSS_MUSIC_DAIAN_2.get() : (SoundEvent)ModSounds.BOSS_MUSIC_DAIAN_1.get();
            FadingBossMusicSound soundInstance = new FadingBossMusicSound(soundEvent);
            mc.m_91106_().m_120367_((SoundInstance)soundInstance);
            origincore.LOGGER.info("Boss{}\u97f3\u4e50\u5df2\u542f\u52a8\uff0c\u5c06\u57283\u79d2\u5185\u6de1\u5165\u81f3\u6b63\u5e38\u97f3\u91cf", (Object)phaseStr);
            BossMusicData data = new BossMusicData(soundInstance, isPhaseTwo);
            ACTIVE_BOSS_MUSIC.put(bossId, data);
        }
        catch (Exception e) {
            origincore.LOGGER.error("\u542f\u52a8Boss\u97f3\u4e50\u5931\u8d25", (Throwable)e);
        }
    }

    private static void startFadeOut(UUID bossId) {
        BossMusicData data = ACTIVE_BOSS_MUSIC.get(bossId);
        if (data == null || data.fadingOut) {
            return;
        }
        data.fadingOut = true;
        data.soundInstance.startFadeOut();
    }

    private static void stopAllMusic() {
        for (BossMusicData data : ACTIVE_BOSS_MUSIC.values()) {
            data.soundInstance.stopImmediately();
        }
        ACTIVE_BOSS_MUSIC.clear();
    }

    private static void stopVanillaMusic(Minecraft mc) {
        MusicManager musicManager = mc.m_91397_();
        musicManager.m_120186_();
        mc.m_91106_().m_120386_(null, SoundSource.MUSIC);
        vanillaMusicStopped = true;
    }

    private static void restoreVanillaMusic(Minecraft mc) {
        if (vanillaMusicStopped && ACTIVE_BOSS_MUSIC.isEmpty()) {
            vanillaMusicStopped = false;
        }
    }

    private static class FadingBossMusicSound
    extends AbstractTickableSoundInstance {
        private float targetVolume = 0.2f;
        private float fadeSpeed = 0.0f;
        private boolean shouldStop = false;

        public FadingBossMusicSound(SoundEvent soundEvent) {
            super(soundEvent, SoundSource.RECORDS, SoundInstance.m_235150_());
            this.f_119578_ = true;
            this.f_119579_ = 0;
            this.f_119573_ = 0.01f;
            this.f_119574_ = 1.0f;
            this.f_119575_ = 0.0;
            this.f_119576_ = 0.0;
            this.f_119577_ = 0.0;
            this.f_119580_ = SoundInstance.Attenuation.NONE;
            this.f_119582_ = true;
            this.fadeSpeed = 0.016666668f;
        }

        public void m_7788_() {
            if (this.shouldStop) {
                this.m_119609_();
                return;
            }
            if (this.f_119573_ < this.targetVolume) {
                float oldVolume = this.f_119573_;
                this.f_119573_ = Math.min(this.f_119573_ + this.fadeSpeed, this.targetVolume);
                if (oldVolume < this.targetVolume && this.f_119573_ >= this.targetVolume) {
                    origincore.LOGGER.info("Boss\u97f3\u4e50\u6de1\u5165\u5b8c\u6210\uff0c\u5f53\u524d\u97f3\u91cf: {}", (Object)Float.valueOf(this.f_119573_));
                }
            } else if (this.f_119573_ > this.targetVolume) {
                this.f_119573_ = Math.max(this.f_119573_ - this.fadeSpeed, this.targetVolume);
                if (this.f_119573_ <= 0.01f) {
                    origincore.LOGGER.info("Boss\u97f3\u4e50\u6de1\u51fa\u5b8c\u6210\uff0c\u505c\u6b62\u64ad\u653e");
                    this.m_119609_();
                }
            }
        }

        public void startFadeOut() {
            this.targetVolume = 0.0f;
            this.fadeSpeed = 0.025f;
            origincore.LOGGER.info("\u5f00\u59cb\u6de1\u51faBoss\u97f3\u4e50");
        }

        public boolean isFadingOut() {
            return this.targetVolume <= 0.0f;
        }

        public void stopImmediately() {
            this.shouldStop = true;
        }
    }

    private static class BossMusicData {
        FadingBossMusicSound soundInstance;
        boolean fadingOut = false;
        boolean isPhaseTwo = false;

        BossMusicData(FadingBossMusicSound soundInstance, boolean isPhaseTwo) {
            this.soundInstance = soundInstance;
            this.isPhaseTwo = isPhaseTwo;
        }
    }
}

