/*
 * Decompiled with CFR 0.152.
 */
package com.tianyi.origin.Enitiy.custom;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class TianyiMerchant {
    public static MerchantOffers createDefaultTrades() {
        MerchantOffers offers = new MerchantOffers();
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 1), new ItemStack((ItemLike)Items.f_42415_, 1), 999999, 0, 0.05f));
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)Items.f_42534_, 4), new ItemStack((ItemLike)Items.f_42390_, 1), 5, 10, 0.05f));
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)Items.f_41834_, 8), new ItemStack((ItemLike)Items.f_42416_, 32), 999999, 0, 0.05f));
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)Items.f_42417_, 16), new ItemStack((ItemLike)Items.f_42616_, 1), 999999, 0, 0.05f));
        return offers;
    }

    public static MerchantOffers loadTrades(ResourceManager resourceManager) {
        MerchantOffers offers = new MerchantOffers();
        try {
            String[] paths;
            for (String path : paths = new String[]{"assets/origincore/trades/tianyi_trades.json", "tianyi_trades.json"}) {
                try {
                    String line;
                    InputStream stream = TianyiMerchant.class.getClassLoader().getResourceAsStream(path);
                    if (stream == null) continue;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                    StringBuilder content = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        content.append(line);
                    }
                    reader.close();
                    JsonObject json = JsonParser.parseString((String)content.toString()).getAsJsonObject();
                    JsonArray tradesArray = json.getAsJsonArray("trades");
                    if (tradesArray != null) {
                        for (int i = 0; i < tradesArray.size(); ++i) {
                            JsonObject tradeObj = tradesArray.get(i).getAsJsonObject();
                            MerchantOffer offer = TianyiMerchant.parseMerchantOffer(tradeObj);
                            if (offer == null) continue;
                            offers.add((Object)offer);
                        }
                    }
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (offers.isEmpty()) {
            return TianyiMerchant.createDefaultTrades();
        }
        return offers;
    }

    private static MerchantOffer parseMerchantOffer(JsonObject obj) {
        try {
            float priceMultiplier;
            ItemStack result;
            ItemStack item1 = TianyiMerchant.parseItemStack(obj.getAsJsonObject("item1"));
            if (item1.m_41619_()) {
                return null;
            }
            ItemStack item2 = ItemStack.f_41583_;
            if (obj.has("item2")) {
                item2 = TianyiMerchant.parseItemStack(obj.getAsJsonObject("item2"));
            }
            if ((result = TianyiMerchant.parseItemStack(obj.getAsJsonObject("result"))).m_41619_()) {
                return null;
            }
            int maxUses = obj.has("maxUses") ? obj.get("maxUses").getAsInt() : 999999;
            int experience = obj.has("experience") ? obj.get("experience").getAsInt() : 0;
            float f = priceMultiplier = obj.has("priceMultiplier") ? obj.get("priceMultiplier").getAsFloat() : 0.05f;
            if (item2.m_41619_()) {
                return new MerchantOffer(item1, result, maxUses, experience, priceMultiplier);
            }
            return new MerchantOffer(item1, item2, result, maxUses, experience, priceMultiplier);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static ItemStack parseItemStack(JsonObject obj) {
        try {
            String itemName = obj.get("item").getAsString();
            int count = obj.has("count") ? obj.get("count").getAsInt() : 1;
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
            if (item != null) {
                ItemStack stack = new ItemStack((ItemLike)item, count);
                if (obj.has("nbt")) {
                    // empty if block
                }
                return stack;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ItemStack.f_41583_;
    }
}

