/*
 * Decompiled with CFR 0.152.
 */
package com.tianyi.origin.Enitiy;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class XingqiuEntity
extends Entity {
    private static final EntityDataAccessor<Float> DATA_ROTATION = SynchedEntityData.m_135353_(XingqiuEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DATA_COLOR_RED = SynchedEntityData.m_135353_(XingqiuEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_COLOR_GREEN = SynchedEntityData.m_135353_(XingqiuEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_COLOR_BLUE = SynchedEntityData.m_135353_(XingqiuEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ALPHA = SynchedEntityData.m_135353_(XingqiuEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_SCALE = SynchedEntityData.m_135353_(XingqiuEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int tickCount = 0;
    private static final int MAX_LIFETIME = 600;
    private static final float ROTATION_SPEED = 1.0f;
    private boolean isExploding = false;
    private int explosionDelay = 0;
    private static final int EXPLOSION_DELAY_TICKS = 10;
    private static final double EXPLOSION_RANGE = 64.0;
    private static final float EXPLOSION_DAMAGE_PERCENT = 0.65f;
    private float clientRotation = 0.0f;
    private float clientRotationO = 0.0f;

    public XingqiuEntity(EntityType<?> type, Level level) {
        super(type, level);
        this.f_19794_ = false;
        this.m_20242_(true);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ROTATION, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_COLOR_RED, (Object)255);
        this.f_19804_.m_135372_(DATA_COLOR_GREEN, (Object)255);
        this.f_19804_.m_135372_(DATA_COLOR_BLUE, (Object)255);
        this.f_19804_.m_135372_(DATA_ALPHA, (Object)200);
        this.f_19804_.m_135372_(DATA_SCALE, (Object)100);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            ++this.tickCount;
            float rotation = ((Float)this.f_19804_.m_135370_(DATA_ROTATION)).floatValue();
            this.f_19804_.m_135381_(DATA_ROTATION, (Object)Float.valueOf(rotation += 1.0f));
            if (this.isExploding) {
                ++this.explosionDelay;
                if (this.explosionDelay >= 10) {
                    this.explode();
                    this.m_146870_();
                    return;
                }
            } else {
                Vec3 movement = this.m_20184_();
                Vec3 newPos = this.m_20182_().m_82549_(movement);
                if (this.checkBlockCollision(newPos)) {
                    this.startExplosion();
                } else {
                    this.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
                }
            }
            if (this.tickCount >= 600) {
                this.m_146870_();
            }
        } else {
            ++this.tickCount;
            this.clientRotationO = this.clientRotation;
            this.clientRotation += 1.0f;
        }
    }

    private boolean checkBlockCollision(Vec3 pos) {
        AABB boundingBox = this.m_20191_().m_82383_(pos.m_82546_(this.m_20182_()));
        return !this.m_9236_().m_45756_((Entity)this, boundingBox);
    }

    private void startExplosion() {
        if (!this.isExploding) {
            this.isExploding = true;
            this.explosionDelay = 0;
            this.m_20256_(Vec3.f_82478_);
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 20, 0.5, 0.5, 0.5, 0.02);
            }
        }
    }

    private void explode() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        this.m_9236_().m_6263_(null, x, y, z, SoundEvents.f_11913_, SoundSource.HOSTILE, 4.0f, 0.8f);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123812_, x, y, z, 3, 0.0, 0.0, 0.0, 0.0);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 100, 2.0, 2.0, 2.0, 0.2);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, x, y, z, 50, 1.5, 1.5, 1.5, 0.1);
        }
        AABB damageBox = new AABB(x - 64.0, y - 64.0, z - 64.0, x + 64.0, y + 64.0, z + 64.0);
        for (Player player : this.m_9236_().m_45976_(Player.class, damageBox)) {
            float damage = player.m_21233_() * 0.65f;
            player.m_6469_(this.m_269291_().m_269036_((Entity)this, null), damage);
            player.f_19802_ = 0;
            Vec3 knockbackDir = player.m_20182_().m_82546_(this.m_20182_()).m_82541_();
            player.m_20256_(player.m_20184_().m_82520_(knockbackDir.f_82479_ * 0.5, 0.3, knockbackDir.f_82481_ * 0.5));
        }
    }

    public float getRotation(float partialTick) {
        if (this.m_9236_().f_46443_) {
            return this.clientRotationO + (this.clientRotation - this.clientRotationO) * partialTick;
        }
        return ((Float)this.f_19804_.m_135370_(DATA_ROTATION)).floatValue();
    }

    public void setColor(int red, int green, int blue) {
        this.f_19804_.m_135381_(DATA_COLOR_RED, (Object)Math.max(0, Math.min(255, red)));
        this.f_19804_.m_135381_(DATA_COLOR_GREEN, (Object)Math.max(0, Math.min(255, green)));
        this.f_19804_.m_135381_(DATA_COLOR_BLUE, (Object)Math.max(0, Math.min(255, blue)));
    }

    public void setAlpha(int alpha) {
        this.f_19804_.m_135381_(DATA_ALPHA, (Object)Math.max(0, Math.min(255, alpha)));
    }

    public void setScale(float scale) {
        this.f_19804_.m_135381_(DATA_SCALE, (Object)((int)(scale * 100.0f)));
    }

    public int getColorRed() {
        return (Integer)this.f_19804_.m_135370_(DATA_COLOR_RED);
    }

    public int getColorGreen() {
        return (Integer)this.f_19804_.m_135370_(DATA_COLOR_GREEN);
    }

    public int getColorBlue() {
        return (Integer)this.f_19804_.m_135370_(DATA_COLOR_BLUE);
    }

    public int getAlpha() {
        return (Integer)this.f_19804_.m_135370_(DATA_ALPHA);
    }

    public float getScale() {
        return (float)((Integer)this.f_19804_.m_135370_(DATA_SCALE)).intValue() / 100.0f;
    }

    protected void m_7378_(CompoundTag tag) {
        this.tickCount = tag.m_128451_("TickCount");
        this.f_19804_.m_135381_(DATA_ROTATION, (Object)Float.valueOf(tag.m_128457_("Rotation")));
        this.f_19804_.m_135381_(DATA_COLOR_RED, (Object)tag.m_128451_("ColorRed"));
        this.f_19804_.m_135381_(DATA_COLOR_GREEN, (Object)tag.m_128451_("ColorGreen"));
        this.f_19804_.m_135381_(DATA_COLOR_BLUE, (Object)tag.m_128451_("ColorBlue"));
        this.f_19804_.m_135381_(DATA_ALPHA, (Object)tag.m_128451_("Alpha"));
        this.f_19804_.m_135381_(DATA_SCALE, (Object)tag.m_128451_("Scale"));
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128405_("TickCount", this.tickCount);
        tag.m_128350_("Rotation", ((Float)this.f_19804_.m_135370_(DATA_ROTATION)).floatValue());
        tag.m_128405_("ColorRed", ((Integer)this.f_19804_.m_135370_(DATA_COLOR_RED)).intValue());
        tag.m_128405_("ColorGreen", ((Integer)this.f_19804_.m_135370_(DATA_COLOR_GREEN)).intValue());
        tag.m_128405_("ColorBlue", ((Integer)this.f_19804_.m_135370_(DATA_COLOR_BLUE)).intValue());
        tag.m_128405_("Alpha", ((Integer)this.f_19804_.m_135370_(DATA_ALPHA)).intValue());
        tag.m_128405_("Scale", ((Integer)this.f_19804_.m_135370_(DATA_SCALE)).intValue());
    }
}

