/*
 * Decompiled with CFR 0.152.
 */
package com.tianyi.origin.Enitiy.Enitiycz;

import com.tianyi.origin.Enitiy.DenLisBoss;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class OrbitingMagicBullet
extends ThrowableProjectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int tickCount = 0;
    private static final int MAX_LIFETIME = 200;
    private float damage = 10.0f;
    private static final double ORBIT_RADIUS = 2.0;
    private static final double ORBIT_SPEED = 0.1;
    private double angle;
    private int bulletIndex;

    public OrbitingMagicBullet(EntityType<? extends ThrowableProjectile> type, Level level) {
        super(type, level);
        this.m_20242_(true);
    }

    public OrbitingMagicBullet(EntityType<? extends ThrowableProjectile> type, Level level, LivingEntity owner, int index) {
        super(type, level);
        this.m_5602_((Entity)owner);
        this.m_20242_(true);
        this.bulletIndex = index;
        this.angle = 1.5707963267948966 * (double)index;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.tickCount;
        if (this.tickCount > 200) {
            this.m_146870_();
            return;
        }
        Entity owner = this.m_19749_();
        if (owner == null || !owner.m_6084_()) {
            this.m_146870_();
            return;
        }
        if (!this.m_9236_().f_46443_) {
            this.angle += 0.1;
            double x = owner.m_20185_() + Math.cos(this.angle) * 2.0;
            double z = owner.m_20189_() + Math.sin(this.angle) * 2.0;
            double y = owner.m_20186_() + (double)owner.m_20206_() * 0.6;
            this.m_6034_(x, y, z);
            this.m_20256_(Vec3.f_82478_);
            this.checkEntityCollision();
        }
        if (this.m_9236_().f_46443_ && this.tickCount % 2 == 0) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123771_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    private void checkEntityCollision() {
        AABB box = this.m_20191_().m_82400_(0.5);
        List entities = this.m_9236_().m_6249_((Entity)this, box, entity -> {
            if (!(entity instanceof LivingEntity)) {
                return false;
            }
            if (entity == this.m_19749_()) {
                return false;
            }
            if (entity instanceof DenLisBoss) {
                return false;
            }
            return entity.m_6084_();
        });
        for (Entity target : entities) {
            target.m_6469_(this.m_269291_().m_269390_((Entity)this, this.m_19749_()), this.damage);
            for (int i = 0; i < 5; ++i) {
                double offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                double offsetY = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123771_, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, offsetX * 0.1, offsetY * 0.1, offsetZ * 0.1);
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

