/*
 * Decompiled with CFR 0.152.
 */
package com.tianyi.origin.Enitiy.Enitiycz;

import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class MissileEntity
extends ThrowableProjectile {
    private static final EntityDataAccessor<Float> DATA_ROTATION_YAW = SynchedEntityData.m_135353_(MissileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_ROTATION_PITCH = SynchedEntityData.m_135353_(MissileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private int tickCount = 0;
    private static final int MAX_LIFETIME = 200;
    private LivingEntity target;
    private UUID targetUUID;
    private static final double TRACKING_STRENGTH = 0.05;
    private float damage = 10.0f;
    private Vec3 initialRandomDirection;
    private Vec3 spawnPosition;
    private static final int PHASE_1_DURATION = 15;
    private static final int PHASE_2_DURATION = 10;
    private static final int PHASE_3_START = 25;
    private static final double MAX_CHASE_DISTANCE = 50.0;

    public MissileEntity(EntityType<? extends ThrowableProjectile> entityType, Level level) {
        super(entityType, level);
        this.m_20242_(true);
        this.initializeRandomDirection();
    }

    public MissileEntity(EntityType<? extends ThrowableProjectile> entityType, Level level, LivingEntity owner) {
        super(entityType, level);
        this.m_5602_((Entity)owner);
        this.m_20242_(true);
        this.initializeRandomDirection();
    }

    public void m_6034_(double x, double y, double z) {
        super.m_6034_(x, y, z);
        if (this.spawnPosition == null) {
            this.spawnPosition = new Vec3(x, y, z);
        }
    }

    private void initializeRandomDirection() {
        double randomAngle = this.f_19796_.m_188500_() * Math.PI * 2.0;
        double randomPitch = this.f_19796_.m_188500_() * 0.45 - 0.15;
        double x = Math.cos(randomAngle) * Math.cos(randomPitch);
        double y = Math.sin(randomPitch);
        double z = Math.sin(randomAngle) * Math.cos(randomPitch);
        this.initialRandomDirection = new Vec3(x, y, z).m_82541_();
    }

    public void setTarget(LivingEntity target) {
        this.target = target;
        if (target != null) {
            this.targetUUID = target.m_20148_();
        }
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ROTATION_YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_ROTATION_PITCH, (Object)Float.valueOf(0.0f));
    }

    public void m_8119_() {
        Vec3 motion;
        block15: {
            block16: {
                block14: {
                    ++this.tickCount;
                    super.m_8119_();
                    if (this.tickCount > 200) {
                        this.m_146870_();
                        return;
                    }
                    if (!this.m_20068_()) {
                        this.m_20242_(true);
                    }
                    if (this.tickCount > 15) break block14;
                    if (this.initialRandomDirection == null) break block15;
                    double speed = 0.8;
                    this.m_20256_(this.initialRandomDirection.m_82490_(speed));
                    break block15;
                }
                if (this.tickCount > 25) break block16;
                Vec3 currentMotion = this.m_20184_();
                double slowdownFactor = 0.7;
                this.m_20256_(currentMotion.m_82490_(slowdownFactor));
                if (!this.m_9236_().f_46443_ || this.tickCount % 3 != 0) break block15;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                break block15;
            }
            if (this.tickCount % 2 == 0 && this.target != null && this.target.m_6084_()) {
                double targetSpeed;
                Vec3 targetPos = new Vec3(this.target.m_20185_(), this.target.m_20186_() + (double)this.target.m_20206_() * 0.5, this.target.m_20189_());
                Vec3 currentPos = this.m_20182_();
                Vec3 toTarget = targetPos.m_82546_(currentPos).m_82541_();
                Vec3 currentMotion = this.m_20184_();
                double currentSpeed = currentMotion.m_82553_();
                if (currentSpeed < (targetSpeed = 2.0) * 0.5) {
                    this.m_20256_(toTarget.m_82490_(targetSpeed));
                } else {
                    Vec3 currentDirection = currentMotion.m_82541_();
                    double strongTrackingStrength = 0.15;
                    Vec3 newDirection = currentDirection.m_82490_(1.0 - strongTrackingStrength).m_82549_(toTarget.m_82490_(strongTrackingStrength)).m_82541_();
                    double newSpeed = Math.min(currentSpeed * 1.05, targetSpeed);
                    this.m_20256_(newDirection.m_82490_(newSpeed));
                }
            } else if (this.targetUUID != null && this.target == null && this.tickCount % 20 == 0) {
                for (Entity entity : this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(50.0))) {
                    LivingEntity living;
                    if (!(entity instanceof LivingEntity) || !(living = (LivingEntity)entity).m_20148_().equals(this.targetUUID)) continue;
                    this.target = living;
                    break;
                }
            }
        }
        if ((motion = this.m_20184_()).m_82556_() > 0.0) {
            double horizontalDistance = Math.sqrt(motion.f_82479_ * motion.f_82479_ + motion.f_82481_ * motion.f_82481_);
            float pitch = (float)Math.toDegrees(Math.atan2(motion.f_82480_, horizontalDistance));
            float yaw = (float)Math.toDegrees(Math.atan2(motion.f_82481_, motion.f_82479_)) - 90.0f;
            this.m_146922_(yaw);
            this.m_146926_(pitch);
            this.f_19804_.m_135381_(DATA_ROTATION_YAW, (Object)Float.valueOf(yaw));
            this.f_19804_.m_135381_(DATA_ROTATION_PITCH, (Object)Float.valueOf(pitch));
        }
        if (this.m_9236_().f_46443_ && this.tickCount % 2 == 0) {
            if (this.tickCount > 25) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            } else if (this.tickCount > 15) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            } else {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void m_6532_(HitResult result) {
        if (this.tickCount <= 10) {
            return;
        }
        super.m_6532_(result);
        if (!this.m_9236_().f_46443_) {
            System.out.println("[MissileEntity] onHit triggered! tickCount=" + this.tickCount + ", result=" + result.m_6662_());
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 5.0f, Level.ExplosionInteraction.NONE);
            this.m_146870_();
        }
    }

    protected void m_5790_(EntityHitResult result) {
        if (this.tickCount <= 10) {
            return;
        }
        Entity hitEntity = result.m_82443_();
        Entity owner = this.m_19749_();
        if (!this.m_9236_().f_46443_) {
            System.out.println("[MissileEntity] onHitEntity! tickCount=" + this.tickCount + ", entity=" + hitEntity.m_7755_().getString() + ", owner=" + (owner != null ? owner.m_7755_().getString() : "null"));
        }
        if (hitEntity == owner) {
            if (!this.m_9236_().f_46443_) {
                System.out.println("[MissileEntity] Ignored owner collision!");
            }
            return;
        }
        super.m_5790_(result);
        if (!this.m_9236_().f_46443_) {
            hitEntity.m_6469_(this.m_269291_().m_269390_((Entity)this, owner), this.damage);
        }
    }

    public float getVisualRotationYaw() {
        return ((Float)this.f_19804_.m_135370_(DATA_ROTATION_YAW)).floatValue();
    }

    public float getVisualRotationPitch() {
        return ((Float)this.f_19804_.m_135370_(DATA_ROTATION_PITCH)).floatValue();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("RotationYaw", ((Float)this.f_19804_.m_135370_(DATA_ROTATION_YAW)).floatValue());
        compound.m_128350_("RotationPitch", ((Float)this.f_19804_.m_135370_(DATA_ROTATION_PITCH)).floatValue());
        compound.m_128405_("TickCount", this.tickCount);
        compound.m_128350_("Damage", this.damage);
        if (this.targetUUID != null) {
            compound.m_128362_("Target", this.targetUUID);
        }
        if (this.initialRandomDirection != null) {
            compound.m_128347_("InitDirX", this.initialRandomDirection.f_82479_);
            compound.m_128347_("InitDirY", this.initialRandomDirection.f_82480_);
            compound.m_128347_("InitDirZ", this.initialRandomDirection.f_82481_);
        }
        if (this.spawnPosition != null) {
            compound.m_128347_("SpawnX", this.spawnPosition.f_82479_);
            compound.m_128347_("SpawnY", this.spawnPosition.f_82480_);
            compound.m_128347_("SpawnZ", this.spawnPosition.f_82481_);
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("RotationYaw")) {
            this.f_19804_.m_135381_(DATA_ROTATION_YAW, (Object)Float.valueOf(compound.m_128457_("RotationYaw")));
        }
        if (compound.m_128441_("RotationPitch")) {
            this.f_19804_.m_135381_(DATA_ROTATION_PITCH, (Object)Float.valueOf(compound.m_128457_("RotationPitch")));
        }
        if (compound.m_128441_("TickCount")) {
            this.tickCount = compound.m_128451_("TickCount");
        }
        if (compound.m_128441_("Damage")) {
            this.damage = compound.m_128457_("Damage");
        }
        if (compound.m_128403_("Target")) {
            this.targetUUID = compound.m_128342_("Target");
        }
        if (compound.m_128441_("InitDirX")) {
            this.initialRandomDirection = new Vec3(compound.m_128459_("InitDirX"), compound.m_128459_("InitDirY"), compound.m_128459_("InitDirZ"));
        }
        if (compound.m_128441_("SpawnX")) {
            this.spawnPosition = new Vec3(compound.m_128459_("SpawnX"), compound.m_128459_("SpawnY"), compound.m_128459_("SpawnZ"));
        }
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    public void m_5997_(double x, double y, double z) {
    }

    public boolean m_6128_() {
        return true;
    }

    public boolean m_6673_(DamageSource source) {
        return true;
    }

    protected boolean m_5603_(Entity entity) {
        if (this.tickCount <= 10) {
            return false;
        }
        if (entity == this.m_19749_()) {
            return false;
        }
        if (entity instanceof MissileEntity) {
            return false;
        }
        boolean canHit = super.m_5603_(entity);
        if (canHit && !this.m_9236_().f_46443_) {
            System.out.println("[MissileEntity] canHitEntity=true, tickCount=" + this.tickCount + ", entity=" + entity.m_7755_().getString());
        }
        return canHit;
    }
}

