/*
 * Decompiled with CFR 0.152.
 */
package com.tianyi.origin.Enitiy.Enitiycz;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class LaserCannonEntity
extends ThrowableProjectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Float> DATA_LASER_LENGTH = SynchedEntityData.m_135353_(LaserCannonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_YAW = SynchedEntityData.m_135353_(LaserCannonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_PITCH = SynchedEntityData.m_135353_(LaserCannonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> DATA_INDEPENDENT = SynchedEntityData.m_135353_(LaserCannonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int tickCount = 0;
    private static final int MAX_LIFETIME = 40;
    private static final int SPAWN_ANIMATION_DURATION = 5;
    private static final int DESPAWN_ANIMATION_DURATION = 10;
    private static final float LASER_LENGTH = 64.0f;
    private static final float LASER_HITBOX_RADIUS = 1.5f;
    private static final float LASER_HIT_DISTANCE = 2.0f;
    private static final float DAMAGE_PERCENT = 0.02f;
    private float damage = 6.0f;
    private Vec3 shootDirection;

    public LaserCannonEntity(EntityType<? extends ThrowableProjectile> type, Level level) {
        super(type, level);
        this.m_20242_(true);
        this.f_19811_ = true;
    }

    public LaserCannonEntity(EntityType<? extends ThrowableProjectile> type, Level level, LivingEntity owner, Vec3 direction) {
        super(type, level);
        this.m_5602_((Entity)owner);
        this.m_20242_(true);
        this.shootDirection = direction.m_82541_();
        this.f_19811_ = true;
    }

    public boolean m_6783_(double distance) {
        return true;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_LASER_LENGTH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_PITCH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_INDEPENDENT, (Object)false);
    }

    public float getScaleFactor() {
        if (this.tickCount <= 5) {
            return (float)this.tickCount / 5.0f;
        }
        if (this.tickCount >= 30) {
            int despawnTick = 40 - this.tickCount;
            return (float)despawnTick / 10.0f;
        }
        return 1.0f;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public void setIndependentMode(boolean independent) {
        this.f_19804_.m_135381_(DATA_INDEPENDENT, (Object)independent);
    }

    public boolean isIndependentMode() {
        return (Boolean)this.f_19804_.m_135370_(DATA_INDEPENDENT);
    }

    public float getLaserLength() {
        return ((Float)this.f_19804_.m_135370_(DATA_LASER_LENGTH)).floatValue();
    }

    private void setLaserLength(float length) {
        this.f_19804_.m_135381_(DATA_LASER_LENGTH, (Object)Float.valueOf(length));
    }

    public void setSyncedRotation(float yaw, float pitch) {
        this.f_19804_.m_135381_(DATA_YAW, (Object)Float.valueOf(yaw));
        this.f_19804_.m_135381_(DATA_PITCH, (Object)Float.valueOf(pitch));
        this.m_146922_(yaw);
        this.m_146926_(pitch);
    }

    public float getSyncedYaw() {
        return ((Float)this.f_19804_.m_135370_(DATA_YAW)).floatValue();
    }

    public float getSyncedPitch() {
        return ((Float)this.f_19804_.m_135370_(DATA_PITCH)).floatValue();
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.tickCount;
        if (this.tickCount > 40) {
            this.m_146870_();
            return;
        }
        Entity owner = this.m_19749_();
        if (!this.isIndependentMode()) {
            if (owner instanceof LivingEntity) {
                LivingEntity livingOwner = (LivingEntity)owner;
                Vec3 playerPos = livingOwner.m_20182_();
                Vec3 lookVec = livingOwner.m_20154_();
                Vec3 newPos = playerPos.m_82520_(0.0, 0.1, 0.0).m_82549_(lookVec.m_82490_(0.5));
                this.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
                this.shootDirection = lookVec.m_82541_();
                this.setSyncedRotation(livingOwner.m_146908_(), livingOwner.m_146909_());
            } else {
                this.m_146870_();
                return;
            }
        }
        this.m_20256_(Vec3.f_82478_);
        this.m_146922_(((Float)this.f_19804_.m_135370_(DATA_YAW)).floatValue());
        this.m_146926_(((Float)this.f_19804_.m_135370_(DATA_PITCH)).floatValue());
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
        this.setLaserLength(64.0f);
        if (!this.m_9236_().f_46443_) {
            this.damageEntitiesInLaserPath();
        }
    }

    private void damageEntitiesInLaserPath() {
        if (this.shootDirection == null) {
            return;
        }
        Vec3 start = this.m_20182_();
        float length = this.getLaserLength();
        Vec3 end = start.m_82549_(this.shootDirection.m_82490_((double)length));
        AABB laserBox = new AABB(start, end).m_82400_(1.5);
        List entities = this.m_9236_().m_6249_((Entity)this, laserBox, entity -> entity instanceof LivingEntity && entity != this.m_19749_());
        for (Entity entity2 : entities) {
            LivingEntity livingEntity;
            if (!(entity2 instanceof LivingEntity) || !this.isEntityOnLaserPath(livingEntity = (LivingEntity)entity2, start, end)) continue;
            livingEntity.f_19802_ = 0;
            Vec3 velocityBefore = livingEntity.m_20184_();
            float maxHealth = livingEntity.m_21233_();
            float calculatedDamage = maxHealth * 0.02f;
            livingEntity.m_6469_(this.m_269291_().m_269425_(), calculatedDamage);
            livingEntity.m_20256_(velocityBefore);
            livingEntity.f_19864_ = true;
            livingEntity.f_19802_ = 0;
        }
    }

    private boolean isEntityOnLaserPath(LivingEntity entity, Vec3 start, Vec3 end) {
        Vec3 entityPos = entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0);
        Vec3 laserDir = end.m_82546_(start);
        Vec3 toEntity = entityPos.m_82546_(start);
        double projection = toEntity.m_82526_(laserDir) / laserDir.m_82556_();
        if (projection < 0.0 || projection > 1.0) {
            return false;
        }
        Vec3 closestPoint = start.m_82549_(laserDir.m_82490_(projection));
        double distance = entityPos.m_82554_(closestPoint);
        return distance < 2.0;
    }

    protected void m_6532_(HitResult result) {
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("TickCount", this.tickCount);
        tag.m_128350_("Damage", this.damage);
        tag.m_128350_("Yaw", ((Float)this.f_19804_.m_135370_(DATA_YAW)).floatValue());
        tag.m_128350_("Pitch", ((Float)this.f_19804_.m_135370_(DATA_PITCH)).floatValue());
        if (this.shootDirection != null) {
            tag.m_128347_("DirX", this.shootDirection.f_82479_);
            tag.m_128347_("DirY", this.shootDirection.f_82480_);
            tag.m_128347_("DirZ", this.shootDirection.f_82481_);
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.tickCount = tag.m_128451_("TickCount");
        this.damage = tag.m_128457_("Damage");
        if (tag.m_128441_("Yaw")) {
            this.f_19804_.m_135381_(DATA_YAW, (Object)Float.valueOf(tag.m_128457_("Yaw")));
            this.f_19804_.m_135381_(DATA_PITCH, (Object)Float.valueOf(tag.m_128457_("Pitch")));
        }
        if (tag.m_128441_("DirX")) {
            this.shootDirection = new Vec3(tag.m_128459_("DirX"), tag.m_128459_("DirY"), tag.m_128459_("DirZ"));
        }
        this.setLaserLength(64.0f);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "rotation_controller", 0, state -> {
            state.setAnimation(RawAnimation.begin().thenLoop("gundong"));
            return PlayState.CONTINUE;
        })});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "scale_controller", 0, state -> {
            if (this.tickCount <= 5) {
                state.setAnimation(RawAnimation.begin().thenPlay("fangda"));
                return PlayState.CONTINUE;
            }
            if (this.tickCount >= 30) {
                state.setAnimation(RawAnimation.begin().thenPlay("suoxiao"));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

