/*
 * Decompiled with CFR 0.152.
 */
package com.tianyi.origin.Enitiy;

import com.tianyi.origin.Enitiy.DenLisTwo;
import com.tianyi.origin.Enitiy.EnitiyRegister.ModEnitiyRegister;
import com.tianyi.origin.Enitiy.Enitiycz.MfdanEntity;
import com.tianyi.origin.Enitiy.Enitiycz.OrbitingMagicBullet;
import com.tianyi.origin.origincore;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DenLisBoss
extends Monster
implements GeoEntity,
RangedAttackMob {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final ServerBossEvent bossBar;
    private static final EntityDataAccessor<Integer> ATTACK_TYPE = SynchedEntityData.m_135353_(DenLisBoss.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK_TICK = SynchedEntityData.m_135353_(DenLisBoss.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final RawAnimation WALK_ANIM = RawAnimation.begin().thenLoop("zoulu");
    private static final RawAnimation MAGIC_ATTACK_ANIM = RawAnimation.begin().thenPlay("mofagj_2");
    private static final RawAnimation MISSILE_ATTACK_ANIM = RawAnimation.begin().thenPlay("mofagj");
    private static final RawAnimation ORBITING_ATTACK_ANIM = RawAnimation.begin().thenPlay("mofagj_3");
    private int attackCooldown = 0;
    private static final int ATTACK_COOLDOWN_TIME = 60;
    private AttackType currentAttackType = AttackType.NONE;
    private int attackAnimationTick = 0;
    private ComboAttackType currentCombo = ComboAttackType.NONE;
    private int comboStep = 0;
    private int comboStepCooldown = 0;
    private static final double MIN_DISTANCE = 6.0;
    private static final double MAX_FOLLOW_DISTANCE = 30.0;
    private static final double TELEPORT_DISTANCE = 32.0;
    private static final double NO_FLY_RANGE = 128.0;
    private int noFlyCheckCooldown = 0;

    public DenLisBoss(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.bossBar = new ServerBossEvent((Component)Component.m_237115_((String)"entity.origincore.den_lis_boss"), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS);
        this.f_21364_ = 520;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACK_TYPE, (Object)0);
        this.f_19804_.m_135372_(ATTACK_TICK, (Object)0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("AttackType", ((Integer)this.f_19804_.m_135370_(ATTACK_TYPE)).intValue());
        tag.m_128405_("AttackTick", this.attackAnimationTick);
        tag.m_128405_("AttackCooldown", this.attackCooldown);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(ATTACK_TYPE, (Object)tag.m_128451_("AttackType"));
        this.attackAnimationTick = tag.m_128451_("AttackTick");
        this.attackCooldown = tag.m_128451_("AttackCooldown");
    }

    public AttackType getCurrentAttackType() {
        int type = (Integer)this.f_19804_.m_135370_(ATTACK_TYPE);
        return AttackType.values()[type];
    }

    public ComboAttackType getCurrentCombo() {
        return this.currentCombo;
    }

    private void setCurrentAttackType(AttackType type) {
        this.currentAttackType = type;
        this.f_19804_.m_135381_(ATTACK_TYPE, (Object)type.ordinal());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 300.0).m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22277_, 164.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22284_, 5.0);
    }

    protected void m_8099_() {
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(2, (Goal)new FollowTargetGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 60, 30.0f));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 32.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossBar.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossBar.m_6539_(player);
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossBar.m_6456_(this.m_5446_());
    }

    public void m_8107_() {
        AttackType currentType;
        double distance;
        LivingEntity target;
        super.m_8107_();
        this.bossBar.m_142711_(this.m_21223_() / this.m_21233_());
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (this.comboStepCooldown > 0) {
            --this.comboStepCooldown;
        }
        if (this.noFlyCheckCooldown > 0) {
            --this.noFlyCheckCooldown;
        }
        if (!this.m_9236_().f_46443_ && this.m_6084_()) {
            this.applyNoFlyEffect();
        }
        if (!this.m_9236_().f_46443_ && (target = this.m_5448_()) != null && target.m_6084_() && (distance = (double)this.m_20270_((Entity)target)) > 32.0 && this.currentCombo == ComboAttackType.NONE) {
            this.teleportNearTarget(target);
        }
        if ((currentType = this.getCurrentAttackType()) != AttackType.NONE) {
            this.m_21573_().m_26573_();
            LivingEntity target2 = this.m_5448_();
            if (target2 != null && target2.m_6084_()) {
                double dx = target2.m_20185_() - this.m_20185_();
                double dz = target2.m_20189_() - this.m_20189_();
                float targetYRot = (float)(Math.atan2(dz, dx) * 57.29577951308232) - 90.0f;
                this.m_146922_(targetYRot);
                this.f_19859_ = targetYRot;
                this.m_5618_(targetYRot);
                this.f_20884_ = targetYRot;
                this.m_5616_(targetYRot);
                this.f_20886_ = targetYRot;
                this.m_21563_().m_24960_((Entity)target2, 360.0f, 360.0f);
            }
            if (!this.m_9236_().f_46443_) {
                ++this.attackAnimationTick;
                this.f_19804_.m_135381_(ATTACK_TICK, (Object)this.attackAnimationTick);
                this.handleAttackEffect();
            }
        }
        if (!this.m_9236_().f_46443_) {
            this.handleComboAttack();
        }
    }

    private void applyNoFlyEffect() {
        AABB boundingBox = new AABB(this.m_20185_() - 128.0, this.m_20186_() - 128.0, this.m_20189_() - 128.0, this.m_20185_() + 128.0, this.m_20186_() + 128.0, this.m_20189_() + 128.0);
        for (Player player : this.m_9236_().m_45976_(Player.class, boundingBox)) {
            boolean isFlying = player.m_150110_().f_35935_;
            boolean isFallFlying = player.m_21255_();
            if (!isFlying && !isFallFlying) continue;
            if (isFlying) {
                player.m_150110_().f_35935_ = false;
                player.m_6885_();
            }
            if (isFallFlying) {
                player.m_36321_();
            }
            if (this.noFlyCheckCooldown > 0) continue;
            player.m_5661_((Component)Component.m_237113_((String)"\u00a7c\u4f60\u65e0\u6cd5\u98de\u884c\uff01"), true);
            this.noFlyCheckCooldown = 20;
        }
    }

    public boolean isBossAlive() {
        return this.m_6084_();
    }

    public void m_6667_(DamageSource damageSource) {
        if (!this.m_9236_().f_46443_) {
            this.spawnPhaseTwo();
        }
        super.m_6667_(damageSource);
    }

    private void spawnPhaseTwo() {
        DenLisTwo phaseTwo = new DenLisTwo((EntityType<? extends Monster>)((EntityType)ModEnitiyRegister.DEN_LIS_TWO.get()), this.m_9236_());
        phaseTwo.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        if (this.m_5448_() != null) {
            phaseTwo.m_6710_(this.m_5448_());
        }
        this.m_9236_().m_7967_((Entity)phaseTwo);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123799_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 100, 1.0, 1.0, 1.0, 0.2);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123745_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 50, 0.5, 1.0, 0.5, 0.1);
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12563_, SoundSource.HOSTILE, 1.5f, 0.8f);
        }
        origincore.LOGGER.info("Boss\u4e00\u9636\u6bb5\u6b7b\u4ea1\uff0c\u8fdb\u5165\u4e8c\u9636\u6bb5\uff01");
    }

    private void handleComboAttack() {
        if (this.m_5448_() == null || this.getCurrentAttackType() != AttackType.NONE) {
            return;
        }
        if (this.currentCombo == ComboAttackType.NONE && this.attackCooldown <= 0) {
            this.startNewComboAttack();
            return;
        }
        if (this.currentCombo != ComboAttackType.NONE && this.comboStepCooldown <= 0) {
            this.executeNextComboStep();
        }
    }

    private void startNewComboAttack() {
        RandomSource random = this.m_217043_();
        float choice = random.m_188501_();
        this.currentCombo = choice < 0.25f ? ComboAttackType.COMBO_A : (choice < 0.5f ? ComboAttackType.COMBO_B : (choice < 0.75f ? ComboAttackType.COMBO_C : ComboAttackType.COMBO_D));
        this.comboStep = 0;
        this.comboStepCooldown = 0;
    }

    private void executeNextComboStep() {
        LivingEntity target = this.m_5448_();
        if (target == null || !target.m_6084_()) {
            this.currentCombo = ComboAttackType.NONE;
            this.comboStep = 0;
            return;
        }
        block0 : switch (this.currentCombo) {
            case COMBO_A: {
                switch (this.comboStep) {
                    case 0: {
                        this.teleportNearTarget(target);
                        this.comboStepCooldown = 10;
                        ++this.comboStep;
                        break;
                    }
                    case 1: {
                        this.setCurrentAttackType(AttackType.MAGIC_BULLET);
                        this.attackAnimationTick = 0;
                        ++this.comboStep;
                        break;
                    }
                    case 2: {
                        this.setCurrentAttackType(AttackType.MAGIC_BULLET);
                        this.attackAnimationTick = 0;
                        ++this.comboStep;
                        break;
                    }
                    case 3: {
                        this.setCurrentAttackType(AttackType.ORBITING_SHIELD);
                        this.attackAnimationTick = 0;
                        ++this.comboStep;
                        break;
                    }
                    case 4: {
                        this.setCurrentAttackType(AttackType.MISSILE_RAIN);
                        this.attackAnimationTick = 0;
                        ++this.comboStep;
                        break;
                    }
                    case 5: {
                        this.finishComboAttack();
                    }
                }
                break;
            }
            case COMBO_B: {
                switch (this.comboStep) {
                    case 0: {
                        this.teleportNearTarget(target);
                        this.comboStepCooldown = 10;
                        ++this.comboStep;
                        break;
                    }
                    case 1: {
                        this.setCurrentAttackType(AttackType.ORBITING_SHIELD);
                        this.attackAnimationTick = 0;
                        ++this.comboStep;
                        break;
                    }
                    case 2: {
                        this.setCurrentAttackType(AttackType.MISSILE_RAIN);
                        this.attackAnimationTick = 0;
                        ++this.comboStep;
                        break;
                    }
                    case 3: {
                        this.setCurrentAttackType(AttackType.MISSILE_RAIN);
                        this.attackAnimationTick = 0;
                        ++this.comboStep;
                        break;
                    }
                    case 4: {
                        this.finishComboAttack();
                    }
                }
                break;
            }
            case COMBO_C: {
                switch (this.comboStep) {
                    case 0: {
                        this.setCurrentAttackType(AttackType.MAGIC_BULLET);
                        this.attackAnimationTick = 0;
                        ++this.comboStep;
                        break;
                    }
                    case 1: {
                        this.setCurrentAttackType(AttackType.MAGIC_BULLET);
                        this.attackAnimationTick = 0;
                        ++this.comboStep;
                        break;
                    }
                    case 2: {
                        this.setCurrentAttackType(AttackType.MAGIC_BULLET);
                        this.attackAnimationTick = 0;
                        ++this.comboStep;
                        break;
                    }
                    case 3: {
                        this.finishComboAttack();
                    }
                }
                break;
            }
            case COMBO_D: {
                switch (this.comboStep) {
                    case 0: {
                        this.setCurrentAttackType(AttackType.MISSILE_RAIN);
                        this.attackAnimationTick = 0;
                        ++this.comboStep;
                        break block0;
                    }
                    case 1: {
                        this.setCurrentAttackType(AttackType.MISSILE_RAIN);
                        this.attackAnimationTick = 0;
                        ++this.comboStep;
                        break block0;
                    }
                    case 2: {
                        this.finishComboAttack();
                    }
                }
            }
        }
    }

    private void finishComboAttack() {
        this.currentCombo = ComboAttackType.NONE;
        this.comboStep = 0;
        this.comboStepCooldown = 0;
        this.attackCooldown = 60;
    }

    private void handleAttackEffect() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        LivingEntity target = this.m_5448_();
        if (target == null || !target.m_6084_()) {
            this.setCurrentAttackType(AttackType.NONE);
            this.attackAnimationTick = 0;
            this.f_19804_.m_135381_(ATTACK_TICK, (Object)0);
            return;
        }
        AttackType currentType = this.getCurrentAttackType();
        if (currentType == AttackType.MAGIC_BULLET) {
            if (this.attackAnimationTick == 7 || this.attackAnimationTick == 32) {
                this.shootFrontMagicBullets(target);
            }
            if (this.attackAnimationTick >= 47) {
                this.setCurrentAttackType(AttackType.NONE);
                this.attackAnimationTick = 0;
                this.f_19804_.m_135381_(ATTACK_TICK, (Object)0);
                if (this.currentCombo != ComboAttackType.NONE) {
                    this.comboStepCooldown = 5;
                }
            }
        } else if (currentType == AttackType.MISSILE_RAIN) {
            if (this.attackAnimationTick >= 5 && this.attackAnimationTick <= 20 && this.attackAnimationTick % 2 == 0) {
                this.shootTopMagicBullet(target);
            }
            if (this.attackAnimationTick >= 25) {
                this.setCurrentAttackType(AttackType.NONE);
                this.attackAnimationTick = 0;
                this.f_19804_.m_135381_(ATTACK_TICK, (Object)0);
                if (this.currentCombo != ComboAttackType.NONE) {
                    this.comboStepCooldown = 5;
                }
            }
        } else if (currentType == AttackType.ORBITING_SHIELD) {
            if (this.attackAnimationTick == 10) {
                this.summonOrbitingBullets();
            }
            if (this.attackAnimationTick >= 30) {
                this.setCurrentAttackType(AttackType.NONE);
                this.attackAnimationTick = 0;
                this.f_19804_.m_135381_(ATTACK_TICK, (Object)0);
                if (this.currentCombo != ComboAttackType.NONE) {
                    this.comboStepCooldown = 5;
                }
            }
        }
    }

    private void shootFrontMagicBullets(LivingEntity target) {
        float damage = target.m_21233_() * 0.04f;
        Vec3 lookVec = this.m_20154_();
        Vec3 rightVec = new Vec3(-lookVec.f_82481_, 0.0, lookVec.f_82479_).m_82541_();
        double spawnHeight = this.m_20186_() + (double)this.m_20206_() * 0.5;
        Vec3 spawnPos = this.m_20182_().m_82549_(lookVec.m_82490_(1.0));
        for (int i = 0; i < 2; ++i) {
            Vec3 offset = rightVec.m_82490_(i == 0 ? -0.5 : 0.5);
            Vec3 bulletPos = spawnPos.m_82549_(offset);
            Vec3 targetPos = new Vec3(target.m_20185_(), target.m_20186_() + (double)target.m_20206_() * 0.3, target.m_20189_());
            Vec3 direction = targetPos.m_82546_(new Vec3(bulletPos.f_82479_, spawnHeight, bulletPos.f_82481_)).m_82541_();
            MfdanEntity bullet = new MfdanEntity((EntityType<? extends ThrowableProjectile>)((EntityType)ModEnitiyRegister.MFDAN.get()), this.m_9236_(), (LivingEntity)this);
            bullet.m_6034_(bulletPos.f_82479_, spawnHeight, bulletPos.f_82481_);
            bullet.setDamage(damage);
            bullet.setTarget(target);
            bullet.shoot(direction);
            this.m_9236_().m_7967_((Entity)bullet);
        }
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123771_, spawnPos.f_82479_, spawnHeight, spawnPos.f_82481_, 20, 0.3, 0.3, 0.3, 0.05);
        }
    }

    private void shootTopMagicBullet(LivingEntity target) {
        float damage = target.m_21233_() * 0.04f;
        double x = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 0.5;
        double y = this.m_20186_() + (double)this.m_20206_() + 1.5;
        double z = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 0.5;
        Vec3 targetPos = new Vec3(target.m_20185_(), target.m_20186_() + (double)target.m_20206_() * 0.5, target.m_20189_());
        Vec3 bulletPos = new Vec3(x, y, z);
        Vec3 direction = targetPos.m_82546_(bulletPos).m_82541_();
        MfdanEntity bullet = new MfdanEntity((EntityType<? extends ThrowableProjectile>)((EntityType)ModEnitiyRegister.MFDAN.get()), this.m_9236_(), (LivingEntity)this);
        bullet.m_6034_(x, y, z);
        bullet.setDamage(damage);
        bullet.setTarget(target);
        bullet.shoot(direction);
        this.m_9236_().m_7967_((Entity)bullet);
    }

    private void summonOrbitingBullets() {
        float damage = 8.0f;
        LivingEntity target = this.m_5448_();
        if (target != null) {
            damage = target.m_21233_() * 0.04f;
        }
        for (int i = 0; i < 4; ++i) {
            OrbitingMagicBullet bullet = new OrbitingMagicBullet((EntityType<? extends ThrowableProjectile>)((EntityType)ModEnitiyRegister.ORBITING_MAGIC_BULLET.get()), this.m_9236_(), (LivingEntity)this, i);
            bullet.setDamage(damage);
            this.m_9236_().m_7967_((Entity)bullet);
        }
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123771_, this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * 0.6, this.m_20189_(), 30, 0.5, 0.5, 0.5, 0.1);
        }
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState<DenLisBoss> state) {
        AttackType currentType = this.getCurrentAttackType();
        switch (currentType) {
            case MAGIC_BULLET: {
                return state.setAndContinue(MAGIC_ATTACK_ANIM);
            }
            case MISSILE_RAIN: {
                return state.setAndContinue(MISSILE_ATTACK_ANIM);
            }
            case ORBITING_SHIELD: {
                return state.setAndContinue(ORBITING_ATTACK_ANIM);
            }
        }
        if (state.isMoving()) {
            return state.setAndContinue(WALK_ANIM);
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private void teleportNearTarget(LivingEntity target) {
        for (int attempt = 0; attempt < 10; ++attempt) {
            ServerLevel serverLevel;
            double angle = this.f_19796_.m_188500_() * Math.PI * 2.0;
            double distance = 6.0 + this.f_19796_.m_188500_() * 2.0;
            double x = target.m_20185_() + Math.cos(angle) * distance;
            double z = target.m_20189_() + Math.sin(angle) * distance;
            Vec3 safePos = this.findSafeTeleportPosition(x, target.m_20186_(), z);
            if (safePos == null) continue;
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 50, 0.5, 1.0, 0.5, 0.1);
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11852_, SoundSource.HOSTILE, 1.0f, 1.0f);
            }
            this.m_6842_(true);
            this.m_6021_(safePos.f_82479_, safePos.f_82480_, safePos.f_82481_);
            level = this.m_9236_();
            if (level instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                serverLevel.m_7654_().execute(() -> {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    this.m_6842_(false);
                });
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, safePos.f_82479_, safePos.f_82480_ + 1.0, safePos.f_82481_, 50, 0.5, 1.0, 0.5, 0.1);
                this.m_9236_().m_6263_(null, safePos.f_82479_, safePos.f_82480_, safePos.f_82481_, SoundEvents.f_11852_, SoundSource.HOSTILE, 1.0f, 1.0f);
            }
            return;
        }
    }

    private Vec3 findSafeTeleportPosition(double x, double startY, double z) {
        double y;
        int yOffset;
        for (yOffset = 0; yOffset <= 10 && !((y = startY - (double)yOffset) < (double)this.m_9236_().m_141937_()); ++yOffset) {
            if (!this.isSafeTeleportPosition(x, y, z)) continue;
            return new Vec3(x, y, z);
        }
        for (yOffset = 1; yOffset <= 5 && !((y = startY + (double)yOffset) > (double)this.m_9236_().m_151558_()); ++yOffset) {
            if (!this.isSafeTeleportPosition(x, y, z)) continue;
            return new Vec3(x, y, z);
        }
        return null;
    }

    private boolean isSafeTeleportPosition(double x, double y, double z) {
        BlockPos pos = new BlockPos((int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(z));
        BlockPos posBelow = pos.m_7495_();
        BlockPos posAbove = pos.m_7494_();
        if (!this.m_9236_().m_8055_(posBelow).m_280296_()) {
            return false;
        }
        if (!this.m_9236_().m_8055_(pos).m_60795_() && this.m_9236_().m_8055_(pos).m_280296_()) {
            return false;
        }
        if (!this.m_9236_().m_8055_(posAbove).m_60795_() && this.m_9236_().m_8055_(posAbove).m_280296_()) {
            return false;
        }
        AABB boundingBox = this.m_20191_().m_82386_(x - this.m_20185_(), y - this.m_20186_(), z - this.m_20189_());
        return this.m_9236_().m_45756_((Entity)this, boundingBox);
    }

    private static enum AttackType {
        NONE,
        MAGIC_BULLET,
        MISSILE_RAIN,
        ORBITING_SHIELD;

    }

    private static enum ComboAttackType {
        NONE,
        COMBO_A,
        COMBO_B,
        COMBO_C,
        COMBO_D;

    }

    private static class FollowTargetGoal
    extends Goal {
        private final DenLisBoss boss;
        private LivingEntity target;

        public FollowTargetGoal(DenLisBoss boss) {
            this.boss = boss;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity target = this.boss.m_5448_();
            if (target == null || !target.m_6084_()) {
                return false;
            }
            this.target = target;
            return this.boss.getCurrentAttackType() == AttackType.NONE && this.boss.getCurrentCombo() == ComboAttackType.NONE;
        }

        public boolean m_8045_() {
            return this.target != null && this.target.m_6084_() && this.boss.getCurrentAttackType() == AttackType.NONE && this.boss.getCurrentCombo() == ComboAttackType.NONE;
        }

        public void m_8037_() {
            if (this.target == null || !this.target.m_6084_()) {
                return;
            }
            double distance = this.boss.m_20270_((Entity)this.target);
            if (distance > 6.0 && distance <= 30.0) {
                this.boss.m_21573_().m_5624_((Entity)this.target, 1.0);
            } else if (distance <= 6.0) {
                this.boss.m_21573_().m_26573_();
            }
            this.boss.m_21563_().m_24960_((Entity)this.target, 10.0f, 10.0f);
        }

        public void m_8041_() {
            this.boss.m_21573_().m_26573_();
        }
    }
}

