/*
 * Decompiled with CFR 0.152.
 */
package com.tianyi.origin.Enitiy;

import com.tianyi.origin.Enitiy.EnitiyRegister.ModEnitiyRegister;
import com.tianyi.origin.Enitiy.Enitiycz.MissileEntity;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CustomBoss
extends Monster
implements RangedAttackMob {
    private final transient ServerBossEvent bossBar = new ServerBossEvent((Component)Component.m_237115_((String)"entity.origincore.custom_boss.name"), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);
    private int missileCooldown = 0;
    private static final int MISSILE_COOLDOWN_TIME = 100;

    public CustomBoss(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.f_21364_ = 500;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22281_, 15.0).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22277_, 150.0);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        double health = this.m_21133_(Attributes.f_22276_);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int particleCount = 135;
            double radius = 1.75;
            double speed = 1.0;
            for (int i = 0; i < particleCount; ++i) {
                double phi = Math.acos(1.0 - 2.0 * ((double)i + 0.5) / (double)particleCount);
                double theta = Math.PI * (1.0 + Math.sqrt(5.0)) * (double)i;
                double xDir = Math.cos(theta) * Math.sin(phi);
                double zDir = Math.sin(theta) * Math.sin(phi);
                double yDir = Math.cos(phi);
                double x = this.m_20185_() + xDir * radius;
                double y = this.m_20186_() + yDir * radius + 1.5;
                double z = this.m_20189_() + zDir * radius;
                double velocityMultiplier = speed * 2.0;
                double vx = xDir * velocityMultiplier;
                double vy = yDir * velocityMultiplier;
                double vz = zDir * velocityMultiplier;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123815_, x, y, z, 1, vx, vy, vz, 0.0);
            }
        }
    }

    protected void m_8099_() {
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 20, true, true, entity -> EntitySelector.f_20406_.test(entity)));
        this.f_21345_.m_25352_(1, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 15, 5, 50.0f));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.f_21345_.m_25352_(3, (Goal)new AreaEffectGoal(this, 40, () -> ParticleTypes.f_123756_));
        this.f_21345_.m_25352_(4, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }

    public boolean m_5825_() {
        return true;
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossBar.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossBar.m_6539_(player);
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossBar.m_6456_(this.m_5446_());
    }

    public void m_8107_() {
        LivingEntity target;
        super.m_8107_();
        this.bossBar.m_142711_(this.m_21223_() / this.m_21233_());
        if (this.missileCooldown > 0) {
            --this.missileCooldown;
        }
        if ((target = this.m_5448_()) != null && !target.m_6084_()) {
            this.m_146870_();
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        Entity attacker = event.getSource().m_7639_();
        if (event.getEntity() == this) {
            MissileEntity missile;
            if (attacker == this) {
                event.setCanceled(true);
                return;
            }
            if (attacker instanceof MissileEntity && (missile = (MissileEntity)attacker).m_19749_() == this) {
                event.setCanceled(true);
                return;
            }
        }
        if (attacker == this) {
            event.getEntity().f_19802_ = 0;
        }
    }

    public boolean m_7327_(Entity entity) {
        if (entity instanceof LivingEntity) {
            double dz;
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.f_19802_ = 0;
            double knockbackStrength = 3.0;
            double dx = entity.m_20185_() - this.m_20185_();
            double distance = Math.sqrt(dx * dx + (dz = entity.m_20189_() - this.m_20189_()) * dz);
            if (distance > 0.0) {
                double xRatio = dx / distance;
                double zRatio = dz / distance;
                entity.m_5997_(xRatio * knockbackStrength, 0.6, zRatio * knockbackStrength);
                entity.f_19864_ = true;
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123813_, entity.m_20185_(), entity.m_20186_() + (double)entity.m_20206_() * 0.5, entity.m_20189_(), 5, 0.2, 0.2, 0.2, 0.0);
                }
            }
        }
        return super.m_7327_(entity);
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        if (this.missileCooldown > 0) {
            if (this.m_20270_((Entity)target) > 5.0f) {
                this.m_21573_().m_5624_((Entity)target, 1.2);
            }
            return;
        }
        if (!this.m_142582_((Entity)target)) {
            return;
        }
        double attackDamage = this.m_21133_(Attributes.f_22281_);
        float missileDamage = (float)(attackDamage * 0.6);
        double distanceToTarget = this.m_20270_((Entity)target);
        int missileCount = (double)this.m_21223_() < (double)this.m_21233_() * 0.3 ? 8 : ((double)this.m_21223_() < (double)this.m_21233_() * 0.5 ? 5 : (distanceToTarget > 15.0 ? 4 : 2));
        RandomSource random = this.m_217043_();
        for (int i = 0; i < missileCount; ++i) {
            int randomDelay = random.m_188503_(40);
            this.m_9236_().m_7654_().m_6937_((Runnable)new TickTask(this.m_9236_().m_7654_().m_129921_() + randomDelay, () -> {
                if (!this.m_213877_() && this.m_6084_() && target.m_6084_()) {
                    double targetZ;
                    double directionZ;
                    double targetY;
                    double directionY;
                    double x = this.m_20185_();
                    double y = this.m_20186_() + (double)this.m_20206_() + 1.5;
                    double z = this.m_20189_();
                    double targetX = target.m_20185_();
                    double directionX = targetX - x;
                    double distance = Math.sqrt(directionX * directionX + (directionY = (targetY = target.m_20186_() + (double)target.m_20206_() * 0.5) - y) * directionY + (directionZ = (targetZ = target.m_20189_()) - z) * directionZ);
                    if (distance > 0.0) {
                        directionX /= distance;
                        directionY /= distance;
                        directionZ /= distance;
                    }
                    this.spawnMissile(target, x, y, z, directionX, directionY, directionZ, missileDamage, distanceToTarget);
                }
            }));
        }
        this.missileCooldown = 100;
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_() + (double)this.m_20206_() + 1.5, this.m_20189_(), 30, 0.3, 0.4, 0.3, 0.05);
        }
    }

    private void spawnMissile(LivingEntity target, double x, double y, double z, double dirX, double dirY, double dirZ, float damage, double distanceToTarget) {
        if (!this.m_9236_().f_46443_) {
            MissileEntity missile = new MissileEntity((EntityType<? extends ThrowableProjectile>)((EntityType)ModEnitiyRegister.MISSILE.get()), this.m_9236_(), (LivingEntity)this);
            missile.m_6034_(x, y, z);
            missile.setTarget(target);
            missile.setDamage(damage);
            this.m_9236_().m_7967_((Entity)missile);
        }
    }

    public void m_147240_(double strength, double xRatio, double zRatio) {
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return effectInstance.m_19544_().m_19486_();
    }

    private static class AreaEffectGoal
    extends Goal {
        private final CustomBoss boss;
        private final int radius;
        private final Supplier<ParticleType<?>> particle;
        private int effectDuration = 100;
        public static final Predicate<Entity> NO_CREATIVE_OR_SPECTATOR = p_20436_ -> !(p_20436_ instanceof Player) || !p_20436_.m_5833_() && !((Player)p_20436_).m_7500_();

        public AreaEffectGoal(CustomBoss boss, int radius, Supplier<ParticleType<?>> particle) {
            this.boss = boss;
            this.radius = radius;
            this.particle = particle;
        }

        public boolean m_8036_() {
            if (this.boss.m_9236_().m_46467_() % 300L != 0L) {
                return false;
            }
            LivingEntity target = this.boss.m_5448_();
            if (target == null) {
                return false;
            }
            double distanceSq = this.boss.m_20280_((Entity)target);
            return distanceSq >= 64.0;
        }

        public void m_8041_() {
            super.m_8041_();
            this.boss.m_21573_().m_26573_();
            LivingEntity livingentity = this.boss.m_5448_();
            if (!NO_CREATIVE_OR_SPECTATOR.test((Entity)livingentity)) {
                this.boss.m_6710_(null);
            }
            this.boss.m_21561_(false);
            this.boss.m_21573_().m_26573_();
        }

        public void m_8056_() {
            this.boss.m_9236_().m_45976_(Player.class, this.boss.m_20191_().m_82400_((double)this.radius)).forEach(player -> {
                if (!player.m_5833_() && !player.m_7500_()) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, this.effectDuration, 2));
                    Level patt8289$temp = this.boss.m_9236_();
                    if (patt8289$temp instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)patt8289$temp;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), 50, 1.0, 0.0, 1.0, 0.1);
                        player.m_213846_((Component)Component.m_237113_((String)"\u4e0d\u8981\u8bd5\u56fe\u9003\u8dd1\uff0c\u5bbf\u547d\u4ea6\u7136\u6ce8\u5b9a\uff01\uff01\uff01"));
                    }
                }
            });
            this.m_8041_();
        }
    }
}

