/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.rough_blade.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import net.exmo.rough_blade.Rough_blade;
import net.exmo.rough_blade.utils.ExConfig;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.fml.loading.FMLPaths;

public class ExConfigHandle {
    public static int autoUUID = 0;
    public static int autoName = 0;
    public static Map<type, Map<String, Object>> valueByKey = new HashMap<type, Map<String, Object>>();

    public static UUID generateUUIDFromString(String inputString) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] hashBytes = md.digest(inputString.getBytes(StandardCharsets.UTF_8));
            long mostSignificantBits = (long)(hashBytes[0] & 0xFF) << 56 | (long)(hashBytes[1] & 0xFF) << 48 | (long)(hashBytes[2] & 0xFF) << 40 | (long)(hashBytes[3] & 0xFF) << 32 | (long)(hashBytes[4] & 0xFF) << 24 | (long)((hashBytes[5] & 0xFF) << 16) | (long)((hashBytes[6] & 0xFF) << 8) | (long)(hashBytes[7] & 0xFF);
            long leastSignificantBits = (long)(hashBytes[8] & 0xFF) << 56 | (long)(hashBytes[9] & 0xFF) << 48 | (long)(hashBytes[10] & 0xFF) << 40 | (long)(hashBytes[11] & 0xFF) << 32 | (long)(hashBytes[12] & 0xFF) << 24 | (long)((hashBytes[13] & 0xFF) << 16) | (long)((hashBytes[14] & 0xFF) << 8) | (long)(hashBytes[15] & 0xFF);
            return new UUID(mostSignificantBits, leastSignificantBits);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-256 algorithm not found", e);
        }
    }

    public void copyResourceToFile(String resourcePath, String targetPath) {
        File mcDir = FMLPaths.GAMEDIR.get().toFile();
        File targetDir = new File(mcDir, targetPath).getParentFile();
        if (!targetDir.exists() && !targetDir.mkdirs()) {
            throw new IllegalStateException("Could not create directory: " + targetDir.getAbsolutePath());
        }
        File targetFile = new File(targetDir, new File(targetPath).getName());
        try (InputStream in = this.getClass().getResourceAsStream(resourcePath);){
            if (in == null) {
                throw new IOException("Resource not found: " + resourcePath);
            }
            Files.copy(in, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to copy file from " + resourcePath + " to " + String.valueOf(targetFile), e);
        }
    }

    public static EquipmentSlot getEquipmentSlot(String key) {
        return (EquipmentSlot)valueByKey.get((Object)type.EquipmentSlot).get(key);
    }

    public static AttributeModifier.Operation getOperation(String key) {
        return (AttributeModifier.Operation)valueByKey.get((Object)type.Operation).get(key);
    }

    public static List<ExConfig> listFiles(Path directory) throws IOException {
        ArrayList<ExConfig> arrayList;
        block9: {
            Stream<Path> paths = Files.walk(directory, new FileVisitOption[0]);
            try {
                List<Path> files = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).toList();
                ArrayList<ExConfig> moconfigs = new ArrayList<ExConfig>();
                for (Path file : files) {
                    ExConfig moconfig = new ExConfig(file);
                    moconfigs.add(moconfig);
                }
                arrayList = moconfigs;
                if (paths == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    return new ArrayList<ExConfig>();
                }
            }
            paths.close();
        }
        return arrayList;
    }

    public static UUID autoUUid(int number) {
        StringBuilder hexNumber = new StringBuilder(Integer.toHexString(number));
        while (hexNumber.length() < 8) {
            hexNumber.insert(0, "0");
        }
        String uuidString = hexNumber.substring(0, 8) + "-e89b-12d3-a456-" + "426614174001".substring(0, 12);
        Rough_blade.LOGGER.debug("autoUUid: " + uuidString);
        return UUID.fromString(uuidString);
    }

    static {
        valueByKey.put(type.Operation, Map.of("add", AttributeModifier.Operation.ADDITION, "multiply", AttributeModifier.Operation.MULTIPLY_TOTAL, "multiply_base", AttributeModifier.Operation.MULTIPLY_BASE, "multiply_total", AttributeModifier.Operation.MULTIPLY_TOTAL));
        valueByKey.put(type.EquipmentSlot, Map.of("mainhand", EquipmentSlot.MAINHAND, "offhand", EquipmentSlot.OFFHAND, "head", EquipmentSlot.HEAD, "chest", EquipmentSlot.CHEST, "legs", EquipmentSlot.LEGS, "feet", EquipmentSlot.FEET));
    }

    public static enum type {
        Operation,
        Attribute,
        Modifier,
        EquipmentSlot,
        Name,
        UUID;

    }
}

