/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.rough_blade.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.awt.Color;
import javax.annotation.Nullable;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.util.BladeRenderState;
import mods.flammpfeil.slashblade.client.renderer.util.MSAutoCloser;
import net.exmo.rough_blade.Rough_blade;
import net.exmo.rough_blade.entity.FaZhenUnder;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class FaZhenUnderRender<T extends FaZhenUnder>
extends EntityRenderer<T> {
    private static final ResourceLocation CORE_CIRCLE = Rough_blade.prefix("models/zhen.obj");
    private static final ResourceLocation INNER_RING = Rough_blade.prefix("models/huan.obj");
    private static final ResourceLocation OUTER_RING = Rough_blade.prefix("models/huan.obj");
    private static final ResourceLocation RUNE_PATTERNS = Rough_blade.prefix("models/huan.obj");
    private static final int CHARGE_DURATION = 540;
    private static final int PHASE_RISE = 300;
    private static final int PHASE_EXPAND = 160;
    private static final int PHASE_ACTIVATE = 80;
    private static final int PHASE_RETRACT = 20;

    public FaZhenUnderRender(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        int tickCount = ((FaZhenUnder)((Object)entity)).f_19797_;
        float totalProgress = Mth.m_14036_((float)((float)tickCount / 560.0f), (float)0.0f, (float)1.0f);
        try (MSAutoCloser msac = MSAutoCloser.pushMatrix((PoseStack)matrixStack);){
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14189_((float)partialTicks, (float)((FaZhenUnder)((Object)entity)).f_19859_, (float)entity.m_146908_())));
            this.renderRisingPhase(entity, matrixStack, buffer, packedLight, tickCount, partialTicks);
            this.renderExpansionPhase(entity, matrixStack, buffer, packedLight, tickCount, partialTicks);
            this.renderActivationPhase(entity, matrixStack, buffer, packedLight, tickCount, partialTicks);
            this.renderFinalCharge(entity, matrixStack, buffer, packedLight, tickCount, partialTicks);
            this.renderRetractPhase(entity, matrixStack, buffer, packedLight, tickCount, partialTicks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderRisingPhase(T entity, PoseStack matrixStack, MultiBufferSource buffer, int packedLight, int tickCount, float partialTicks) {
        float phaseProgress = Mth.m_14036_((float)((float)tickCount / 300.0f), (float)0.0f, (float)1.0f);
        for (int i = 0; i < 4; ++i) {
            matrixStack.m_85836_();
            try {
                float layerHeight = Mth.m_14179_((float)phaseProgress, (float)(-0.5f + (float)i * 0.15f), (float)(2.0f + (float)i * 1.2f));
                float scale = Mth.m_14179_((float)phaseProgress, (float)0.01f, (float)(0.8f + (float)i * 0.6f));
                float alpha = Mth.m_14179_((float)phaseProgress, (float)0.3f, (float)1.0f);
                matrixStack.m_252880_(0.0f, layerHeight * 50.0f, 0.0f);
                matrixStack.m_85841_(scale, scale, scale);
                float rotation = ((float)tickCount + partialTicks) * (float)i;
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
                WavefrontObject model = BladeModelManager.getInstance().getModel(CORE_CIRCLE);
                BladeRenderState.setCol((int)this.getLayerColor(i, phaseProgress).getRGB(), (alpha < 0.9f ? 1 : 0) != 0);
                BladeRenderState.renderOverridedLuminous((ItemStack)ItemStack.f_41583_, (WavefrontObject)model, (String)"Circle", (ResourceLocation)this.getTextureLocation(entity), (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)packedLight);
                continue;
            }
            finally {
                matrixStack.m_85849_();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderExpansionPhase(T entity, PoseStack matrixStack, MultiBufferSource buffer, int packedLight, int tickCount, float partialTicks) {
        if (tickCount < 300) {
            return;
        }
        float phaseProgress = Mth.m_14036_((float)((float)(tickCount - 300) / 160.0f), (float)0.0f, (float)1.0f);
        for (int a = 0; a < 3; ++a) {
            for (int i = 0; i < 2; ++i) {
                matrixStack.m_85836_();
                try {
                    float layerHeight = Mth.m_14179_((float)phaseProgress, (float)(-0.5f + (float)i * 0.15f), (float)(2.0f + (float)i * 1.2f));
                    float scale = Mth.m_14179_((float)phaseProgress, (float)0.5f, (float)(3.0f + (float)i * 1.2f)) * (float)a * 0.6f;
                    float rotationSpeed = i == 0 ? -1.5f : 2.0f;
                    float currentRotation = (float)tickCount * rotationSpeed * partialTicks;
                    matrixStack.m_252781_(Axis.f_252436_.m_252977_(currentRotation));
                    matrixStack.m_85841_(scale, scale * 0.5f, scale);
                    matrixStack.m_252880_(0.0f, layerHeight * 50.0f * (float)(3 - a) * 0.6f, 0.0f);
                    Color pulseColor = Color.getHSBColor((float)(tickCount % 40) / 40.0f, 0.8f, Mth.m_14031_((float)((float)(tickCount + i * 20) * 0.1f)) * 0.5f + 0.5f);
                    BladeRenderState.setCol((int)pulseColor.getRGB(), (boolean)true);
                    WavefrontObject ringModel = BladeModelManager.getInstance().getModel(i == 0 ? INNER_RING : OUTER_RING);
                    BladeRenderState.renderOverridedLuminous((ItemStack)ItemStack.f_41583_, (WavefrontObject)ringModel, (String)"huan", (ResourceLocation)this.getTextureLocation(entity), (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)packedLight);
                    continue;
                }
                finally {
                    matrixStack.m_85849_();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderActivationPhase(T entity, PoseStack matrixStack, MultiBufferSource buffer, int packedLight, int tickCount, float partialTicks) {
        if (tickCount < 460) {
            return;
        }
        float phaseProgress = Mth.m_14036_((float)((float)(tickCount - 300 - 160) / 80.0f), (float)0.0f, (float)1.0f);
        matrixStack.m_85836_();
        try {
            float globalScale = Mth.m_14179_((float)phaseProgress, (float)1.0f, (float)2.5f);
            matrixStack.m_85841_(globalScale, globalScale * 0.2f, globalScale);
            float rotationSpeed = Mth.m_14031_((float)((float)tickCount * 0.1f)) * 2.0f;
            matrixStack.m_252781_(Axis.f_252436_.m_252977_((float)tickCount * 3.0f));
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(rotationSpeed));
            WavefrontObject runeModel = BladeModelManager.getInstance().getModel(RUNE_PATTERNS);
            for (int i = 0; i < 8; ++i) {
                matrixStack.m_85836_();
                float angle = (float)(45 * i) + (float)tickCount * 2.0f;
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(angle));
                matrixStack.m_252880_(0.0f, 0.0f, 1.5f);
                float runeAlpha = Mth.m_14036_((float)((float)(tickCount - i * 5) / 10.0f), (float)0.0f, (float)1.0f);
                BladeRenderState.setCol((int)this.getRuneColor(i), (runeAlpha > 0.9f ? 1 : 0) != 0);
                BladeRenderState.renderOverridedLuminous((ItemStack)ItemStack.f_41583_, (WavefrontObject)runeModel, (String)"huan", (ResourceLocation)this.getTextureLocation(entity), (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)packedLight);
                matrixStack.m_85849_();
            }
        }
        finally {
            matrixStack.m_85849_();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderFinalCharge(T entity, PoseStack matrixStack, MultiBufferSource buffer, int packedLight, int tickCount, float partialTicks) {
        if (tickCount < 500) {
            return;
        }
        if (tickCount >= 540) {
            return;
        }
        float chargeProgress = (float)(tickCount - 500) / 40.0f;
        matrixStack.m_85836_();
        try {
            float pulseScale = Mth.m_14179_((float)Mth.m_14031_((float)(chargeProgress * (float)Math.PI)), (float)1.0f, (float)1.5f);
            matrixStack.m_85841_(pulseScale, pulseScale * 0.3f, pulseScale);
            BladeRenderState.setCol((int)Color.WHITE.getRGB(), (boolean)false);
            WavefrontObject coreModel = BladeModelManager.getInstance().getModel(OUTER_RING);
            BladeRenderState.renderOverridedLuminous((ItemStack)ItemStack.f_41583_, (WavefrontObject)coreModel, (String)"huan", (ResourceLocation)this.getTextureLocation(entity), (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)packedLight);
            for (int i = 0; i < 4; ++i) {
                matrixStack.m_85836_();
                try {
                    float baseAngle = (float)tickCount * 5.0f;
                    matrixStack.m_252781_(Axis.f_252436_.m_252977_((float)(90 * i) + baseAngle));
                    float radius = 24.0f * Mth.m_14179_((float)chargeProgress, (float)0.5f, (float)1.0f);
                    matrixStack.m_252880_(radius, 0.0f, 0.0f);
                    float scale = Mth.m_14179_((float)chargeProgress, (float)0.3f, (float)1.1f) / 1.2f;
                    matrixStack.m_85841_(scale * 0.3f, scale * 0.3f, scale * 0.3f);
                    matrixStack.m_252781_(Axis.f_252436_.m_252977_((float)tickCount * 3.0f * (float)(i % 2 == 0 ? 1 : -1)));
                    float alpha = Mth.m_14036_((float)(Mth.m_14116_((float)chargeProgress) * 1.2f), (float)0.0f, (float)1.0f);
                    BladeRenderState.setCol((int)this.getLayerColor(i, 1.0f).getRGB(), (alpha < 0.9f ? 1 : 0) != 0);
                    WavefrontObject model = BladeModelManager.getInstance().getModel(CORE_CIRCLE);
                    BladeRenderState.renderOverridedLuminous((ItemStack)ItemStack.f_41583_, (WavefrontObject)model, (String)"Circle", (ResourceLocation)this.getTextureLocation(entity), (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)packedLight);
                    continue;
                }
                finally {
                    matrixStack.m_85849_();
                }
            }
            this.renderExpandingDownwardRings(entity, matrixStack, buffer, packedLight, chargeProgress, 0.0f);
            if (tickCount % 2 == 0) {
                this.spawnChargeParticles(entity, matrixStack, chargeProgress);
            }
        }
        finally {
            matrixStack.m_85849_();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderExpandingDownwardRings(T entity, PoseStack matrixStack, MultiBufferSource buffer, int packedLight, float chargeProgress, float retractProgress) {
        for (int i = 0; i < 5; ++i) {
            matrixStack.m_85836_();
            try {
                float ringProgress = Mth.m_14187_((float)(chargeProgress * 2.0f + (float)i * 0.2f));
                float scale = ringProgress * 0.5f;
                float downwardMovement = ringProgress * 2.0f;
                if (retractProgress > 0.0f) {
                    scale *= 1.0f - retractProgress;
                    downwardMovement *= 1.0f - retractProgress;
                }
                matrixStack.m_252880_(0.0f, -downwardMovement, 0.0f);
                matrixStack.m_85841_(scale, scale * 0.1f, scale);
                Color ringColor = Color.getHSBColor(0.6f + ringProgress * 0.2f, 0.8f, 0.9f);
                float alpha = (1.0f - ringProgress) * 0.7f;
                if (retractProgress > 0.0f) {
                    alpha *= 1.0f - retractProgress;
                }
                BladeRenderState.setCol((int)ringColor.getRGB(), (alpha < 0.9f ? 1 : 0) != 0);
                WavefrontObject ringModel = BladeModelManager.getInstance().getModel(INNER_RING);
                BladeRenderState.renderOverridedLuminous((ItemStack)ItemStack.f_41583_, (WavefrontObject)ringModel, (String)"huan", (ResourceLocation)this.getTextureLocation(entity), (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)packedLight);
                continue;
            }
            finally {
                matrixStack.m_85849_();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderRetractPhase(T entity, PoseStack matrixStack, MultiBufferSource buffer, int packedLight, int tickCount, float partialTicks) {
        if (tickCount < 540) {
            return;
        }
        float retractProgress = Mth.m_14036_((float)((float)(tickCount - 540) / 20.0f), (float)0.0f, (float)1.0f);
        float invRetractProgress = 1.0f - retractProgress;
        for (int i = 0; i < 4; ++i) {
            matrixStack.m_85836_();
            try {
                matrixStack.m_252880_(0.0f, 0.5f * invRetractProgress, 0.0f);
                float baseAngle = (float)tickCount * 3.0f;
                matrixStack.m_252781_(Axis.f_252436_.m_252977_((float)(90 * i) + baseAngle));
                float radius = 24.0f * invRetractProgress;
                matrixStack.m_252880_(0.0f, 0.0f, radius);
                matrixStack.m_252781_(Axis.f_252529_.m_252977_(80.0f));
                float scale = invRetractProgress * 0.8f;
                matrixStack.m_85841_(scale * 0.1f, scale * 0.1f, scale * 0.1f);
                matrixStack.m_252781_(Axis.f_252436_.m_252977_((float)tickCount * 5.0f * (float)(i % 2 == 0 ? 1 : -1)));
                BladeRenderState.setCol((int)this.getLayerColor(i, invRetractProgress).getRGB(), (retractProgress > 0.1f ? 1 : 0) != 0);
                WavefrontObject model = BladeModelManager.getInstance().getModel(CORE_CIRCLE);
                BladeRenderState.renderOverridedLuminous((ItemStack)ItemStack.f_41583_, (WavefrontObject)model, (String)"Circle", (ResourceLocation)this.getTextureLocation(entity), (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)packedLight);
                continue;
            }
            finally {
                matrixStack.m_85849_();
            }
        }
        this.renderRetractingRings(entity, matrixStack, buffer, packedLight, retractProgress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderRetractingRings(T entity, PoseStack matrixStack, MultiBufferSource buffer, int packedLight, float retractProgress) {
        for (int i = 0; i < 5; ++i) {
            matrixStack.m_85836_();
            try {
                float ringProgress = Mth.m_14187_((float)(retractProgress * 2.0f + (float)i * 0.2f));
                float scale = (1.0f - ringProgress) * 3.0f;
                float downwardMovement = (1.0f - ringProgress) * 2.0f;
                matrixStack.m_252880_(0.0f, -downwardMovement, 0.0f);
                matrixStack.m_85841_(scale, scale * 0.1f, scale);
                Color ringColor = Color.getHSBColor(0.6f + ringProgress * 0.2f, 0.8f, 0.9f);
                float alpha = ringProgress * 0.7f;
                BladeRenderState.setCol((int)ringColor.getRGB(), (alpha < 0.9f ? 1 : 0) != 0);
                WavefrontObject ringModel = BladeModelManager.getInstance().getModel(INNER_RING);
                BladeRenderState.renderOverridedLuminous((ItemStack)ItemStack.f_41583_, (WavefrontObject)ringModel, (String)"huan", (ResourceLocation)this.getTextureLocation(entity), (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)packedLight);
                continue;
            }
            finally {
                matrixStack.m_85849_();
            }
        }
    }

    private Color getLayerColor(int layer, float progress) {
        float hue = 0.6f + (float)layer * 0.07f;
        float saturation = 0.8f - progress * 0.3f;
        float brightness = 0.5f + progress * 0.5f;
        return Color.getHSBColor(hue, saturation, brightness);
    }

    private int getRuneColor(int index) {
        float hue = (float)(index % 8) / 8.0f;
        return Color.getHSBColor(hue, 0.9f, 1.0f).getRGB();
    }

    private void spawnChargeParticles(T entity, PoseStack matrixStack, float progress) {
        for (int i = 0; i < 36; ++i) {
            double angle = Math.toRadians(i * 10 + ((FaZhenUnder)((Object)entity)).f_19797_ * 5);
            double radius = 3.0 * (double)progress;
            double x = entity.m_20185_() + radius * Math.cos(angle);
            double z = entity.m_20189_() + radius * Math.sin(angle);
            double y = entity.m_20186_() + 2.5;
            entity.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public ResourceLocation getTextureLocation(T entity) {
        return FaZhenUnder.getTextureLoc();
    }
}

