/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.rough_blade.render;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.exmo.rough_blade.Config;
import net.exmo.rough_blade.content.client.LSClientData;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.IItemDecorator;

public class SlashBladeRender
implements IItemDecorator {
    private static final int CYCLE_INTERVAL = 500;
    private final Map<String, TextAnimState> textAnimStates = new HashMap<String, TextAnimState>();

    private static String getStyledSubstring(String text, int visibleStart, int length) {
        StringBuilder result = new StringBuilder();
        int totalVisible = (int)text.chars().filter(c -> c != 167).count() / 2;
        if (totalVisible == 0) {
            return text;
        }
        ArrayList<String> activeStyles = new ArrayList<String>();
        int visibleCount = 0;
        int i = 0;
        while (i < text.length() && visibleCount <= visibleStart + length) {
            if (text.charAt(i) == '\u00a7') {
                if (i + 1 < text.length()) {
                    String styleCode = text.substring(i, i + 2);
                    activeStyles.add(styleCode);
                    i += 2;
                    continue;
                }
                ++i;
                continue;
            }
            if (visibleCount >= visibleStart) {
                for (String style : activeStyles) {
                    result.append(style);
                }
            }
            if (visibleCount >= visibleStart && visibleCount < visibleStart + length) {
                result.append(text.charAt(i));
            }
            ++i;
            ++visibleCount;
        }
        return result.toString();
    }

    public boolean render(GuiGraphics guiGraphics, Font font, ItemStack stack, int xOffset, int yOffset) {
        return this.renders(guiGraphics, font, stack, xOffset, yOffset);
    }

    public boolean renders(GuiGraphics guiGraphics, Font font, ItemStack stack, int xOffset, int yOffset) {
        int totalVisible;
        if (((Boolean)Config.CLOSE_TEXT_RENDER.get()).booleanValue()) {
            return false;
        }
        if (!LSClientData.isHideModel()) {
            return false;
        }
        if (!Screen.m_96638_() || ((Boolean)Config.NEW_TEXT_RENDER_ALAWAYS.get()).booleanValue() && !((Boolean)Config.OLD_TEXT_RENDER_ALAWAYS.get()).booleanValue()) {
            return false;
        }
        Component c = stack.m_41786_();
        String text = c.getString();
        TextAnimState state = this.textAnimStates.computeIfAbsent(text, k -> new TextAnimState());
        long now = System.currentTimeMillis();
        if (state.lastUpdate == 0L) {
            state.lastUpdate = now;
        }
        if ((totalVisible = text.replaceAll("\u00a7.", "").length()) < 2) {
            return false;
        }
        long elapsed = now - state.lastUpdate;
        if (elapsed >= 500L) {
            state.visibleStartIndex = (state.visibleStartIndex + 1) % (totalVisible - 1);
            state.lastUpdate = now;
        }
        String displayedString = SlashBladeRender.getStyledSubstring(text, state.visibleStartIndex, 2);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
        MutableComponent mutableComponent = Component.m_237113_((String)displayedString);
        int n = xOffset + 8 - font.m_92895_(displayedString) / 2;
        Objects.requireNonNull(font);
        guiGraphics.m_280614_(font, (Component)mutableComponent, n, yOffset + 8 - 9 / 2, 0xFFFFFF, true);
        guiGraphics.m_280168_().m_85849_();
        return true;
    }

    private static class TextAnimState {
        int visibleStartIndex;
        long lastUpdate;

        private TextAnimState() {
        }
    }
}

