/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.rough_blade.network;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.exmo.rough_blade.Rough_blade;
import net.exmo.rough_blade.network.LSVARB;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CareerWarModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        Rough_blade.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        Rough_blade.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    public static class PlayerVariablesSyncMessage {
        private final int target;
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
            this.target = buffer.readInt();
        }

        public PlayerVariablesSyncMessage(PlayerVariables data, int entityid) {
            this.data = data;
            this.target = entityid;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
            buffer.writeInt(message.target);
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.m_9236_().m_6815_(message.target).getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.career = message.data.career;
                    variables.HasCareer = message.data.HasCareer;
                    variables.playercooldown = message.data.playercooldown;
                    variables.magicGether = message.data.magicGether;
                    variables.CareerProficiency = message.data.CareerProficiency;
                    variables.KillRecord = message.data.KillRecord;
                    variables.HeavenlyEyeUUID = message.data.HeavenlyEyeUUID;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public String career = "\"\"";
        public String HasCareer = "\"\"";
        public String HeavenlyEyeUUID = "";
        public Map<String, Integer> playercooldown = new HashMap<String, Integer>();
        public Map<String, Integer> CareerProficiency = new HashMap<String, Integer>();
        public String magicGether = "\"\"";
        public int KillRecord = 0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                Rough_blade.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)entity.m_9236_()).m_46472_()), (Object)new PlayerVariablesSyncMessage(this, entity.m_19879_()));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            if (this.career != null) {
                nbt.m_128359_("career", this.career);
            }
            nbt.m_128359_("HasCareer", this.HasCareer);
            nbt.m_128359_("HeavenlyEyeUUID", this.HeavenlyEyeUUID);
            CompoundTag stringMapTag = new CompoundTag();
            for (Map.Entry<String, Integer> entry : this.playercooldown.entrySet()) {
                stringMapTag.m_128405_(entry.getKey(), entry.getValue().intValue());
            }
            nbt.m_128365_("playercooldown", (Tag)stringMapTag);
            CompoundTag stringMapTag1 = new CompoundTag();
            for (Map.Entry<String, Integer> entry : this.CareerProficiency.entrySet()) {
                stringMapTag1.m_128405_(entry.getKey(), entry.getValue().intValue());
            }
            nbt.m_128365_("CareerProficiency", (Tag)stringMapTag1);
            nbt.m_128405_("KillRecord", this.KillRecord);
            nbt.m_128359_("magicGether", this.magicGether);
            return nbt;
        }

        public void readNBT(Tag Tag2) {
            CompoundTag nbt = (CompoundTag)Tag2;
            this.career = nbt.m_128461_("career");
            this.HasCareer = nbt.m_128461_("HasCareer");
            this.HeavenlyEyeUUID = nbt.m_128461_("HeavenlyEyeUUID");
            CompoundTag stringMapTag = nbt.m_128469_("playercooldown");
            for (String key : stringMapTag.m_128431_()) {
                int value = stringMapTag.m_128451_(key);
                this.playercooldown.put(key, value);
            }
            CompoundTag stringMapTag1 = nbt.m_128469_("CareerProficiency");
            for (String key : stringMapTag1.m_128431_()) {
                int value = stringMapTag1.m_128451_(key);
                this.CareerProficiency.put(key, value);
            }
            this.magicGether = nbt.m_128461_("magicGether");
            this.KillRecord = nbt.m_128451_("KillRecord");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LSVARB.PlayerVariables playerVariables1 = new LSVARB.PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);
        private final LazyOptional<LSVARB.PlayerVariables> instance1 = LazyOptional.of(() -> this.playerVariables1);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("rough_blade", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            if (cap == PLAYER_VARIABLES_CAPABILITY) {
                return this.instance.cast();
            }
            if (cap == LSVARB.PLAYER_VARIABLES_CAPABILITY) {
                return this.instance1.cast();
            }
            return LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return ((CompoundTag)this.playerVariables.writeNBT()).m_128391_((CompoundTag)this.playerVariables1.writeNBT());
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
            this.playerVariables1.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.career = original.career;
            clone.HasCareer = original.HasCareer;
            clone.CareerProficiency = original.CareerProficiency;
            if (!event.isWasDeath()) {
                clone.playercooldown = original.playercooldown;
                clone.HeavenlyEyeUUID = original.HeavenlyEyeUUID;
                clone.magicGether = original.magicGether;
                clone.KillRecord = original.KillRecord;
            }
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }
    }
}

