/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.rough_blade.network;

import java.util.UUID;
import java.util.function.Supplier;
import net.exmo.rough_blade.Rough_blade;
import net.exmo.rough_blade.content.specialEffects.MingLiEffectHandle;
import net.exmo.rough_blade.network.MingLiChangeMessage;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public record AskMingLiChangeMessage(UUID uuid) {
    public static void encode(AskMingLiChangeMessage msg, FriendlyByteBuf buffer) {
        CompoundTag tag = new CompoundTag();
        tag.m_128362_("uuid", msg.uuid);
        buffer.m_130079_(tag);
    }

    public static void handle(AskMingLiChangeMessage msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            LivingEntity livingEntity;
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            Entity entity = sender.m_284548_().m_8791_(msg.uuid);
            if (entity instanceof LivingEntity && MingLiEffectHandle.isMingLi(livingEntity = (LivingEntity)entity)) {
                int mingLi = MingLiEffectHandle.getMingLi((Entity)livingEntity);
                MingLiChangeMessage mingLiChangeMessage = new MingLiChangeMessage(msg.uuid, mingLi);
                Rough_blade.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> sender), (Object)mingLiChangeMessage);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static AskMingLiChangeMessage decode(FriendlyByteBuf buffer) {
        CompoundTag tag = buffer.m_130260_();
        return new AskMingLiChangeMessage(tag.m_128342_("uuid"));
    }
}

