/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.rough_blade.network;

import java.util.function.Supplier;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.exmo.rough_blade.content.shineArt.ShineArt;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ActiveState2SyncMessage {
    public CompoundTag activeTag;
    public int id;

    public static ActiveState2SyncMessage decode(FriendlyByteBuf buf) {
        ActiveState2SyncMessage msg = new ActiveState2SyncMessage();
        msg.id = buf.readInt();
        msg.activeTag = buf.m_130260_();
        return msg;
    }

    public static void encode(ActiveState2SyncMessage msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.id);
        buf.m_130079_(msg.activeTag);
    }

    public static void handle(ActiveState2SyncMessage msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (msg.activeTag.m_128403_("BladeUniqueId")) {
                ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
                Entity target = Minecraft.m_91087_().f_91073_.m_6815_(msg.id);
                if (target instanceof LivingEntity) {
                    ItemStack stack = ((LivingEntity)target).m_21120_(InteractionHand.MAIN_HAND);
                    if (stack.m_41619_()) {
                        return;
                    }
                    if (!(stack.m_41720_() instanceof ItemSlashBlade)) {
                        return;
                    }
                    CompoundTag tag = stack.m_41784_();
                    stack.getCapability(ShineArt.BLADESTATE_PLUST).filter(state -> state.getUniqueId().equals(msg.activeTag.m_128342_("BladeUniqueId"))).ifPresent(state -> {
                        state.setActiveState(msg.activeTag);
                        tag.m_128365_("charge_power_state", (Tag)state.serializeNBT());
                    });
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

