/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.rough_blade.mixin.power;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.slasharts.SlashArts;
import mods.flammpfeil.slashblade.util.AttackManager;
import net.exmo.rough_blade.Config;
import net.exmo.rough_blade.Rough_blade;
import net.exmo.rough_blade.content.CustomConfig;
import net.exmo.rough_blade.content.SlashAttackHandle;
import net.exmo.rough_blade.events.OnCharge;
import net.exmo.rough_blade.events.OnCharge1_5;
import net.exmo.rough_blade.events.OnCharge2;
import net.exmo.rough_blade.network.LSVARB;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SlashArts.class})
public abstract class DoSlashAttackMixin {
    private static final Map<String, Integer> COST_CACHE = new ConcurrentHashMap<String, Integer>();
    private static final ThreadLocal<Long> LAST_SOUND_TIME = ThreadLocal.withInitial(() -> 0L);
    private static final float CHARGED_MULTIPLIER_1_5 = 1.5f;
    private static final float CHARGED_MULTIPLIER_2_0 = 2.0f;
    private static final int CHARGE_THRESHOLD_1_5 = 22;
    private static final int CHARGE_THRESHOLD_2_0 = 25;
    private static final int BOOST_DURATION_1_5 = 12;
    private static final int BOOST_DURATION_2_0 = 16;

    @Shadow(remap=false)
    public abstract ResourceLocation doArts(SlashArts.ArtsType var1, LivingEntity var2);

    @Shadow(remap=false)
    public abstract ResourceLocation getComboState(LivingEntity var1);

    @Shadow(remap=false)
    public abstract Function<LivingEntity, ResourceLocation> getComboStateSuper();

    @Inject(at={@At(value="HEAD")}, method={"doArts"}, cancellable=true, remap=false)
    public void doArts$LS(SlashArts.ArtsType type2, LivingEntity user, CallbackInfoReturnable<ResourceLocation> cir) {
        if (type2 == SlashArts.ArtsType.Fail) {
            cir.setReturnValue((Object)ComboStateRegistry.NONE.getId());
            cir.cancel();
            return;
        }
        if (!((Boolean)Config.POWER.get()).booleanValue()) {
            this.handleNoPowerMode(user, (SlashArts)this, type2);
            return;
        }
        ItemStack mainHandItem = user.m_21205_();
        if (mainHandItem.m_41619_()) {
            return;
        }
        LazyOptional bladeStateCap = mainHandItem.getCapability(ItemSlashBlade.BLADESTATE);
        LazyOptional playerVarsCap = user.getCapability(LSVARB.PLAYER_VARIABLES_CAPABILITY);
        if (!bladeStateCap.isPresent() || !playerVarsCap.isPresent()) {
            return;
        }
        ISlashBladeState iSlashBladeState = (ISlashBladeState)bladeStateCap.orElse(null);
        LSVARB.PlayerVariables playerVariables = (LSVARB.PlayerVariables)playerVarsCap.orElse(null);
        if (iSlashBladeState == null || playerVariables == null) {
            return;
        }
        int chargeTime = (Integer)playerVariables.playerSimpleVars.get(1).getValue();
        OnCharge event = new OnCharge(user, iSlashBladeState, chargeTime, (SlashArts)this, type2);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            cir.setReturnValue((Object)ComboStateRegistry.NONE.getId());
            cir.cancel();
            return;
        }
        if (!(user instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)user;
        int power = (Integer)playerVariables.playerSimpleVars.get(0).getValue();
        String artKey = SlashArts.getRegistryKey((SlashArts)((SlashArts)this)).toString();
        int baseCost = COST_CACHE.computeIfAbsent(artKey, k -> CustomConfig.SlashArtsCostMap.getOrDefault(k, 50));
        if (!this.hasSufficientEnergy(player, power, baseCost)) {
            cir.setReturnValue((Object)ComboStateRegistry.NONE.getId());
            cir.cancel();
            return;
        }
        this.handleChargedAttack(player, mainHandItem, iSlashBladeState, (SlashArts)this, type2, chargeTime, power, baseCost, cir);
    }

    private boolean hasSufficientEnergy(ServerPlayer player, int currentPower, int requiredCost) {
        CompoundTag persistentData = player.getPersistentData();
        if (persistentData.m_128441_("boost2") && persistentData.m_128471_("boost2")) {
            return true;
        }
        if (currentPower < requiredCost) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - LAST_SOUND_TIME.get() > 500L) {
                player.m_6330_(SoundEvents.f_11669_, SoundSource.PLAYERS, 0.4f, 1.2f);
                LAST_SOUND_TIME.set(currentTime);
            }
            player.m_240418_((Component)Component.m_237110_((String)"message.rough_blade.slash_arts_no_power", (Object[])new Object[]{requiredCost, ((SlashArts)this).getDescription()}).m_130940_(ChatFormatting.RED), true);
            return false;
        }
        return true;
    }

    private void handleChargedAttack(ServerPlayer player, ItemStack mainHandItem, ISlashBladeState bladeState, SlashArts art, SlashArts.ArtsType type2, int chargeTime, int currentPower, int baseCost, CallbackInfoReturnable<ResourceLocation> cir) {
        LSVARB.PlayerVariables playerVariables = (LSVARB.PlayerVariables)player.getCapability(LSVARB.PLAYER_VARIABLES_CAPABILITY).orElse(null);
        if (playerVariables == null) {
            return;
        }
        if (chargeTime > 15) {
            this.spawnChargeParticles(player, chargeTime);
        }
        if (chargeTime >= 25) {
            this.handleLevel2Charge(player, bladeState, art, currentPower, baseCost, chargeTime, cir);
        } else if (chargeTime >= 22) {
            this.handleLevel1Charge(player, bladeState, art, currentPower, baseCost, chargeTime, cir);
        } else {
            this.handleNormalAttack(player, playerVariables, art, baseCost, cir);
        }
    }

    private void handleNormalAttack(ServerPlayer player, LSVARB.PlayerVariables playerVariables, SlashArts art, int cost, CallbackInfoReturnable<ResourceLocation> cir) {
        CompoundTag data = player.getPersistentData();
        if (!data.m_128441_("boost2") || data.m_128451_("boost2") <= 0) {
            this.sendSkillMessage(player, art.getDescription(), "", ChatFormatting.WHITE);
            int newPower = Math.max(0, (Integer)playerVariables.playerSimpleVars.get(0).getValue() - cost);
            playerVariables.playerSimpleVars.get(0).setValue(newPower);
            playerVariables.syncPlayerVariables((Entity)player);
            player.m_147240_((double)0.1f, player.m_20154_().f_82479_, player.m_20154_().f_82481_);
        }
    }

    private void handleLevel1Charge(ServerPlayer player, ISlashBladeState bladeState, SlashArts art, int currentPower, int baseCost, int chargeTime, CallbackInfoReturnable<ResourceLocation> cir) {
        int cost = (int)((float)baseCost * 1.5f);
        if (!this.checkAndConsumePower(player, currentPower, cost, art, " 1.5", ChatFormatting.YELLOW)) {
            cir.setReturnValue((Object)ComboStateRegistry.NONE.getId());
            cir.cancel();
            return;
        }
        this.sendSkillMessage(player, art.getDescription(), " 1.5", ChatFormatting.GOLD);
        OnCharge1_5 event = new OnCharge1_5((LivingEntity)player, bladeState, chargeTime, art);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        Rough_blade.queueServerWork(3, () -> this.executeChargedAttack(player, bladeState, chargeTime, 12, 4, 1.5f));
    }

    private void handleLevel2Charge(ServerPlayer player, ISlashBladeState bladeState, SlashArts art, int currentPower, int baseCost, int chargeTime, CallbackInfoReturnable<ResourceLocation> cir) {
        int cost = (int)((float)baseCost * 2.0f);
        if (!this.checkAndConsumePower(player, currentPower, cost, art, " 2.0", ChatFormatting.RED)) {
            cir.setReturnValue((Object)ComboStateRegistry.NONE.getId());
            cir.cancel();
            return;
        }
        this.sendSkillMessage(player, art.getDescription(), " 2.0", ChatFormatting.DARK_RED);
        OnCharge2 event = new OnCharge2((Player)player, bladeState, chargeTime, art);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        Rough_blade.queueServerWork(4, () -> this.executeChargedAttack(player, bladeState, chargeTime, 16, 5, 2.0f));
        this.createShockwave(player, 3.0f);
    }

    private void executeChargedAttack(ServerPlayer player, ISlashBladeState bladeState, int chargeTime, int boostDuration, int workDelay, float multiplier) {
        ItemStack mainHandItem = player.m_21205_();
        player.getPersistentData().m_128405_("boost2", boostDuration);
        player.getPersistentData().m_128405_("boost3", (int)((float)boostDuration * 1.33f));
        AttackManager.playQuickSheathSoundAction((LivingEntity)player);
        Item item = mainHandItem.m_41720_();
        if (item instanceof ItemSlashBlade) {
            ItemSlashBlade itemSlashBlade = (ItemSlashBlade)item;
            Level level = player.m_9236_();
            long lastActionTime = bladeState.getLastActionTime();
            itemSlashBlade.m_5929_(level, (LivingEntity)player, mainHandItem, 8);
            bladeState.setLastActionTime(lastActionTime + (long)Math.max(0, chargeTime - 8));
        }
        bladeState.updateComboSeq((LivingEntity)player, new ResourceLocation("slashblade", "none"));
        bladeState.doChargeAction((LivingEntity)player, chargeTime);
        if (multiplier >= 2.0f) {
            player.getPersistentData().m_128405_("cancelWindow", 5);
        }
    }

    private boolean checkAndConsumePower(ServerPlayer player, int currentPower, int requiredCost, SlashArts art, String suffix, ChatFormatting color) {
        if (currentPower < requiredCost) {
            MutableComponent message = Component.m_237110_((String)"message.rough_blade.slash_arts_no_power", (Object[])new Object[]{requiredCost, art.getDescription().m_6881_().m_130946_(suffix).m_130940_(color)});
            player.m_240418_((Component)message, true);
            player.m_6330_(SoundEvents.f_11669_, SoundSource.PLAYERS, 0.9f, 1.0f);
            return false;
        }
        LSVARB.PlayerVariables vars = (LSVARB.PlayerVariables)player.getCapability(LSVARB.PLAYER_VARIABLES_CAPABILITY).orElse(null);
        if (vars != null) {
            vars.playerSimpleVars.get(0).setValue(Math.max(0, currentPower - requiredCost));
            vars.syncPlayerVariables((Entity)player);
        }
        return true;
    }

    private void sendSkillMessage(ServerPlayer player, Component description, String suffix, ChatFormatting color) {
        MutableComponent message = description.m_6881_().m_130946_(suffix).m_130940_(color).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
        SlashAttackHandle.sendSkillInfoMessage(player, (Component)message);
        player.m_6330_(SoundEvents.f_11871_, SoundSource.PLAYERS, 0.5f, 1.5f);
    }

    private void spawnChargeParticles(ServerPlayer player, int chargeTime) {
        Level level = player.m_9236_();
        Vec3 pos = player.m_20182_();
        if (level.f_46443_) {
            for (int i = 0; i < 3; ++i) {
                double offsetX = (level.f_46441_.m_188500_() - 0.5) * 0.5;
                double offsetY = (level.f_46441_.m_188500_() - 0.5) * 0.5;
                double offsetZ = (level.f_46441_.m_188500_() - 0.5) * 0.5;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123809_, pos.f_82479_ + offsetX, pos.f_82480_ + 1.0 + offsetY, pos.f_82481_ + offsetZ, 0.0, 0.1, 0.0);
            }
        }
    }

    private void createShockwave(ServerPlayer player, float radius) {
        Level level = player.m_9236_();
        Vec3 center = player.m_20182_().m_82520_(0.0, 1.0, 0.0);
        level.m_45976_(LivingEntity.class, new AABB(center.m_82492_((double)radius, (double)radius, (double)radius), center.m_82520_((double)radius, (double)radius, (double)radius))).stream().filter(entity -> entity != player && !entity.m_7307_((Entity)player)).forEach(entity -> {
            Vec3 direction = entity.m_20182_().m_82546_(center).m_82541_();
            entity.m_147240_(1.5, direction.f_82479_, direction.f_82481_);
            if (level.f_46443_) {
                for (int i = 0; i < 5; ++i) {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123797_, entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_(), (level.f_46441_.m_188500_() - 0.5) * 0.2, 0.2, (level.f_46441_.m_188500_() - 0.5) * 0.2);
                }
            }
        });
    }

    private void handleNoPowerMode(LivingEntity user, SlashArts art, SlashArts.ArtsType type2) {
        if (type2 != SlashArts.ArtsType.Fail && user instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)user;
            MutableComponent message = art.getDescription().m_6881_().m_130940_(ChatFormatting.WHITE).m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)));
            SlashAttackHandle.sendSkillInfoMessage(player, (Component)message);
        }
    }
}

