/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.rough_blade.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import mods.flammpfeil.slashblade.entity.Projectile;
import net.exmo.rough_blade.entity.SummonSwordPROEntity;
import net.exmo.rough_blade.init.RBEntityRegistry;
import net.exmo.rough_blade.repack.it.hurts.octostudios.perception.common.modules.trail.config.data.TrailConfigData;
import net.exmo.rough_blade.repack.it.hurts.octostudios.perception.common.modules.trail.misc.ITrailConfigProvider;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Unique;

public class TrackTailEntity
extends SummonSwordPROEntity
implements ITrailConfigProvider {
    @Unique
    private TrailConfigData perception$trailData = new TrailConfigData();

    public TrackTailEntity(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
    }

    public static TrackTailEntity createInstance(PlayMessages.SpawnEntity packet, Level worldIn) {
        return new TrackTailEntity(RBEntityRegistry.TRACK_TAIL_ENTITY, worldIn);
    }

    @Override
    public TrailConfigData getTrailConfigData() {
        return this.perception$trailData;
    }

    @Override
    public void setTrailConfigData(TrailConfigData data) {
        this.perception$trailData = data;
    }

    public int getTrailMaxLength() {
        return this.getTrailConfigData().getMaxPoints();
    }

    public int getTrailUpdateFrequency() {
        return this.getTrailConfigData().getUpdateFrequency();
    }

    public double getTrailScale() {
        return this.getTrailConfigData().getSize();
    }

    public Vec3 getTrailPosition(float partialTicks) {
        Entity entity = (Entity)this;
        TrailConfigData data = this.getTrailConfigData();
        Vector3f offset = data.getPositionOffset();
        Vec3 entityPosition = (entity.f_19797_ > 1 ? entity.m_20318_(partialTicks) : entity.m_20182_()).m_82549_(entity.m_20184_().m_82541_().m_82490_((double)(-data.getMotionShift()))).m_82520_((double)offset.x(), (double)offset.y(), (double)offset.z());
        Player player = entity.m_20193_().m_45930_(entity, this.getTrailRenderDistance());
        if (player == null) {
            return entityPosition;
        }
        Vec3 playerPosition = player.m_20299_(partialTicks);
        entityPosition = entityPosition.m_82549_(entityPosition.m_82546_(playerPosition).m_82541_().m_82490_((double)data.getBackwardShift()));
        return entityPosition;
    }

    public boolean isTrailGrowing() {
        Entity entity = (Entity)this;
        return entity.m_20184_().m_82553_() >= (double)this.getTrailConfigData().getMinSpeed();
    }

    public boolean isTrailAlive() {
        Entity entity = (Entity)this;
        return entity.m_6084_();
    }

    public int getTrailFadeInColor() {
        return (int)Long.parseLong(this.getTrailConfigData().getFadeInColor().replace("#", ""), 16);
    }

    public int getTrailFadeOutColor() {
        return (int)Long.parseLong(this.getTrailConfigData().getFadeOutColor().replace("#", ""), 16);
    }

    public void renderTrail(float pTicks, PoseStack poseStack, MultiBufferSource bufferSourceList) {
        ITrailConfigProvider.super.renderTrail(pTicks, poseStack, bufferSourceList);
    }
}

