/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.rough_blade.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.hurts.octostudios.octolib.util.ColorUtils;
import it.hurts.octostudios.octolib.util.TesselatorUtils;
import it.hurts.octostudios.octolib.util.VectorUtils;
import java.awt.Color;
import java.util.List;
import mods.flammpfeil.slashblade.entity.EntityDrive;
import mods.flammpfeil.slashblade.entity.Projectile;
import net.exmo.rough_blade.Rough_blade;
import net.exmo.rough_blade.content.specialEffects.StarrySkySE;
import net.exmo.rough_blade.init.RBEntityRegistry;
import net.exmo.rough_blade.repack.it.hurts.octostudios.perception.common.modules.trail.config.data.TrailConfigData;
import net.exmo.rough_blade.repack.it.hurts.octostudios.perception.common.modules.trail.misc.ITrailConfigProvider;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Unique;

public class StarrySkySlash
extends EntityDrive
implements ITrailConfigProvider {
    @Unique
    private TrailConfigData perception$trailData = new TrailConfigData();
    private float partialTicks;
    private float thickness = 0.05f;
    private float verticalScale = 1.5f;
    private float horizontalScale = 0.8f;
    private Vec3 rotationAxis = new Vec3(0.0, 1.0, 0.0);
    private double rotationAngle = 0.0;
    private Vec3 positionOffset = new Vec3(0.0, 0.0, 0.0);

    public StarrySkySlash(EntityType<? extends Projectile> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        LivingEntity livingEntity;
        super.m_5790_(entityHitResult);
        Entity owner = this.m_19749_();
        if (owner == null) {
            return;
        }
        Entity entity = entityHitResult.m_82443_();
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_6084_() && Math.random() <= 0.5) {
            livingEntity.getPersistentData().m_128359_("star_imprint_uuid", owner.m_20149_());
            if (!livingEntity.m_21023_((MobEffect)Rough_blade.effectAbout.StarImprintEffect.get())) {
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)Rough_blade.effectAbout.StarImprintEffect.get(), 200, 0, true, true));
            } else {
                int amplifier = livingEntity.m_21124_((MobEffect)Rough_blade.effectAbout.StarImprintEffect.get()).m_19564_();
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)Rough_blade.effectAbout.StarImprintEffect.get(), 200, amplifier + 1, true, true));
            }
        }
    }

    public static StarrySkySlash createInstance(PlayMessages.SpawnEntity packet, Level worldIn) {
        return new StarrySkySlash(RBEntityRegistry.STARRY_SKY_SLASH, worldIn);
    }

    @Override
    public TrailConfigData getTrailConfigData() {
        return this.perception$trailData;
    }

    @Override
    public void setTrailConfigData(TrailConfigData data) {
        this.perception$trailData = data;
    }

    public int getTrailMaxLength() {
        return this.getTrailConfigData().getMaxPoints();
    }

    public int getTrailUpdateFrequency() {
        return this.getTrailConfigData().getUpdateFrequency();
    }

    public double getTrailScale() {
        return this.getTrailConfigData().getSize();
    }

    public void m_8119_() {
        super.m_8119_();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (Math.random() < 0.2) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123810_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 1, (double)0.05f, (double)0.05f, (double)0.05f, (double)0.05f);
            }
        }
    }

    public Vec3 getTrailPosition(float partialTicks) {
        Entity entity = (Entity)this;
        TrailConfigData data = this.getTrailConfigData();
        Vector3f offset = data.getPositionOffset();
        Vec3 entityPosition = (entity.f_19797_ > 1 ? entity.m_20318_(partialTicks) : entity.m_20182_()).m_82549_(entity.m_20184_().m_82541_().m_82490_((double)(-data.getMotionShift()))).m_82520_((double)offset.x(), (double)offset.y(), (double)offset.z());
        Player player = entity.m_20193_().m_45930_(entity, this.getTrailRenderDistance());
        if (player == null) {
            return entityPosition;
        }
        Vec3 playerPosition = player.m_20299_(partialTicks);
        entityPosition = entityPosition.m_82549_(entityPosition.m_82546_(playerPosition).m_82541_().m_82490_((double)data.getBackwardShift()));
        return entityPosition;
    }

    public boolean isTrailGrowing() {
        Entity entity = (Entity)this;
        return entity.m_20184_().m_82553_() >= (double)this.getTrailConfigData().getMinSpeed();
    }

    public boolean isTrailAlive() {
        Entity entity = (Entity)this;
        return entity.m_6084_();
    }

    public int getTrailFadeInColor() {
        return (int)Long.parseLong(this.getTrailConfigData().getFadeInColor().replace("#", ""), 16);
    }

    public int getTrailFadeOutColor() {
        return (int)Long.parseLong(this.getTrailConfigData().getFadeOutColor().replace("#", ""), 16);
    }

    public void renderTrail(float pTicks, PoseStack poseStack, MultiBufferSource bufferSourceList) {
        this.partialTicks = pTicks;
        ITrailConfigProvider.super.renderTrail(pTicks, poseStack, bufferSourceList);
    }

    public void draw3dTrail(List<Vec3> partialPoses, PoseStack poseStack, MultiBufferSource bufferSourceList) {
        if (partialPoses.size() < 2) {
            return;
        }
        float verticalScale = 1.5f;
        float horizontalScale = 0.8f;
        Vec3 rotationAxis = new Vec3(0.0, 0.0, 0.0);
        double rotationAngle = this.getRotationRoll();
        Vec3 positionOffset = new Vec3(0.0, 0.0, 0.0);
        Vec3[][] crossVecs = new Vec3[partialPoses.size()][4];
        poseStack.m_85836_();
        boolean test = StarrySkySE.isPower.test(Float.valueOf(this.getRotationRoll()));
        Vec3 finalPositionOffset = positionOffset;
        partialPoses = partialPoses.stream().map(a -> a.m_82546_(finalPositionOffset)).toList();
        for (int i = 1; i < partialPoses.size(); ++i) {
            Vec3 pos1 = partialPoses.get(i - 1);
            Vec3 pos2 = partialPoses.get(i);
            Vec3 vec1 = pos2.m_82546_(pos1);
            Vec3 vec1n = vec1.m_82541_();
            Vec3 rightVec = Math.abs(vec1n.f_82480_) > 0.9 ? vec1.m_82537_(new Vec3(1.0, 0.0, 0.0)).m_82541_() : vec1.m_82537_(VectorUtils.Y_VEC).m_82541_();
            Vec3 upVec = rightVec.m_82537_(vec1n).m_82541_();
            if (rotationAngle != 0.0) {
                rightVec = VectorUtils.rotate((Vec3)rightVec, (Vec3)rotationAxis, (double)rotationAngle).m_82541_();
                upVec = VectorUtils.rotate((Vec3)upVec, (Vec3)rotationAxis, (double)rotationAngle).m_82541_();
            }
            double len = 1.0f - (float)(i - 1) / (float)partialPoses.size();
            double scale = this.getTrailScale() * len * (double)(test ? 4.0f : 1.0f);
            crossVecs[i - 1][0] = upVec.m_82490_(scale * (double)verticalScale).m_82549_(rightVec.m_82490_((double)(this.thickness * horizontalScale)));
            crossVecs[i - 1][1] = upVec.m_82490_(-scale * (double)verticalScale * 0.2).m_82549_(rightVec.m_82490_((double)(this.thickness * horizontalScale)));
            crossVecs[i - 1][2] = upVec.m_82490_(-scale * (double)verticalScale * 0.2).m_82549_(rightVec.m_82490_((double)(-this.thickness * horizontalScale)));
            crossVecs[i - 1][3] = upVec.m_82490_(scale * (double)verticalScale).m_82549_(rightVec.m_82490_((double)(-this.thickness * horizontalScale)));
        }
        Color color1 = new Color(this.getTrailFadeInColor(), true);
        Color color2 = new Color(this.getTrailFadeOutColor(), true);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        for (int i = 0; i < partialPoses.size() - 1; ++i) {
            if (crossVecs[i][0] == null) continue;
            Color c1 = ColorUtils.blend((Color)color1, (Color)color2, (double)((float)i / (float)(partialPoses.size() - 1)));
            Color c2 = ColorUtils.blend((Color)color1, (Color)color2, (double)(((float)i + 1.0f) / (float)(partialPoses.size() - 1)));
            Vec3 pos_i = partialPoses.get(i);
            Vec3 pos_i1 = partialPoses.get(i + 1);
            Vec3[] currentPoints = new Vec3[4];
            for (int j = 0; j < 4; ++j) {
                currentPoints[j] = pos_i.m_82549_(crossVecs[i][j]);
            }
            Vec3[] nextPoints = new Vec3[4];
            if (i < partialPoses.size() - 2 && crossVecs[i + 1][0] != null) {
                for (int j = 0; j < 4; ++j) {
                    nextPoints[j] = pos_i1.m_82549_(crossVecs[i + 1][j]);
                }
            } else {
                Vec3 endDir = pos_i1.m_82546_(pos_i).m_82541_().m_82490_((double)this.thickness * 0.5);
                for (int j = 0; j < 4; ++j) {
                    nextPoints[j] = pos_i1.m_82549_(endDir);
                }
            }
            VertexConsumer tes = bufferSourceList.m_6299_(TesselatorUtils.TRAIL_RENDER_TYPE);
            this.drawQuadSide(tes, matrix4f, currentPoints[0], currentPoints[1], nextPoints[1], nextPoints[0], c1, c2);
            this.drawQuadSide(tes, matrix4f, currentPoints[1], currentPoints[2], nextPoints[2], nextPoints[1], c1, c2);
            this.drawQuadSide(tes, matrix4f, currentPoints[2], currentPoints[3], nextPoints[3], nextPoints[2], c1, c2);
            this.drawQuadSide(tes, matrix4f, currentPoints[3], currentPoints[0], nextPoints[0], nextPoints[3], c1, c2);
        }
        poseStack.m_85849_();
    }

    private void drawQuadSide(VertexConsumer tes, Matrix4f matrix, Vec3 p1, Vec3 p2, Vec3 p3, Vec3 p4, Color c1, Color c2) {
        TesselatorUtils.drawQuadGradient((VertexConsumer)tes, (Matrix4f)matrix, (float)((float)p1.f_82479_), (float)((float)p1.f_82480_), (float)((float)p1.f_82481_), (float)((float)p2.f_82479_), (float)((float)p2.f_82480_), (float)((float)p2.f_82481_), (float)((float)p3.f_82479_), (float)((float)p3.f_82480_), (float)((float)p3.f_82481_), (float)((float)p4.f_82479_), (float)((float)p4.f_82480_), (float)((float)p4.f_82481_), (Color)c1, (Color)c2);
    }

    public void setRotation(double angleRadians, Vec3 axis) {
        this.rotationAngle = angleRadians;
        this.rotationAxis = axis.m_82541_();
    }

    public void setPositionOffset(Vec3 offset) {
        this.positionOffset = offset;
    }

    public void setScaling(float vertical, float horizontal) {
        this.verticalScale = vertical;
        this.horizontalScale = horizontal;
    }

    public void setThickness(float thickness) {
        this.thickness = thickness;
    }
}

