/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.rough_blade.entity;

import java.util.List;
import mods.flammpfeil.slashblade.entity.IShootable;
import net.exmo.rough_blade.content.specialEffects.CherryBlossomMarkHandle;
import net.exmo.rough_blade.init.RBEntityRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.PlayMessages;

public class SakuraExplosionEntity
extends Entity
implements IShootable,
IEntityAdditionalSpawnData {
    private static final EntityDataAccessor<Float> DATA_RADIUS = SynchedEntityData.m_135353_(SakuraExplosionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DATA_OWNER_ID = SynchedEntityData.m_135353_(SakuraExplosionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_EXPLOSION_COUNT = SynchedEntityData.m_135353_(SakuraExplosionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DATA_DAMAGE = SynchedEntityData.m_135353_(SakuraExplosionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private Entity cachedOwner;

    public SakuraExplosionEntity(EntityType<? extends SakuraExplosionEntity> type2, Level level) {
        super(type2, level);
    }

    public static SakuraExplosionEntity createInstance(PlayMessages.SpawnEntity spawnEntity, Level level) {
        return new SakuraExplosionEntity(RBEntityRegistry.SAKURA_EXPLOSION_ENTITY, level);
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            for (int i = 0; i < 10; ++i) {
                double offsetX = (this.f_19796_.m_188500_() - 0.5) * (double)this.getRadius();
                double offsetY = (this.f_19796_.m_188500_() - 0.5) * 1.0;
                double offsetZ = (this.f_19796_.m_188500_() - 0.5) * (double)this.getRadius();
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_276452_, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, (this.f_19796_.m_188500_() - 0.5) * 0.1, 0.05, (this.f_19796_.m_188500_() - 0.5) * 0.1);
            }
        } else {
            if (this.f_19797_ % 5 == 0 && this.getExplosionCount() > 0) {
                this.explode();
                this.setExplosionCount(this.getExplosionCount() - 1);
            }
            if (this.f_19797_ > 50 || this.getExplosionCount() <= 0) {
                this.m_146870_();
            }
        }
    }

    private void explode() {
        Entity owner = this.getShooter();
        if (owner == null) {
            return;
        }
        AABB explosionArea = new AABB(this.m_20185_() - (double)this.getRadius(), this.m_20186_() - 1.0, this.m_20189_() - (double)this.getRadius(), this.m_20185_() + (double)this.getRadius(), this.m_20186_() + 2.0, this.m_20189_() + (double)this.getRadius());
        List entitiesInRange = this.m_9236_().m_45933_(owner, explosionArea);
        for (Entity entity : entitiesInRange) {
            Level level;
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity == owner) continue;
            if (owner instanceof Player) {
                Player player = (Player)owner;
                CherryBlossomMarkHandle.addCherryBlossomMark(livingEntity, 1);
            }
            if (!((level = this.m_9236_()) instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123813_, entity.m_20185_(), entity.m_20186_() + (double)entity.m_20206_() / 2.0, entity.m_20189_(), 5, 0.3, 0.3, 0.3, 0.1);
        }
    }

    public float getRadius() {
        return ((Float)this.f_19804_.m_135370_(DATA_RADIUS)).floatValue();
    }

    public void setRadius(float radius) {
        this.f_19804_.m_135381_(DATA_RADIUS, (Object)Float.valueOf(radius));
    }

    public Entity getShooter() {
        Entity entity;
        if (this.cachedOwner != null && !this.cachedOwner.m_213877_()) {
            return this.cachedOwner;
        }
        int ownerId = (Integer)this.f_19804_.m_135370_(DATA_OWNER_ID);
        if (ownerId != -1 && (entity = this.m_9236_().m_6815_(ownerId)) instanceof LivingEntity) {
            this.cachedOwner = (LivingEntity)entity;
            return this.cachedOwner;
        }
        return null;
    }

    public void setShooter(Entity owner) {
        if (owner != null) {
            this.f_19804_.m_135381_(DATA_OWNER_ID, (Object)owner.m_19879_());
            this.cachedOwner = owner;
        }
    }

    public int getExplosionCount() {
        return (Integer)this.f_19804_.m_135370_(DATA_EXPLOSION_COUNT);
    }

    public void setExplosionCount(int count) {
        this.f_19804_.m_135381_(DATA_EXPLOSION_COUNT, (Object)count);
    }

    public void m_6686_(double v, double v1, double v2, float v3, float v4) {
    }

    public double getDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DATA_DAMAGE, (Object)Float.valueOf(damage));
    }

    protected void m_7378_(CompoundTag compound) {
        this.setRadius(compound.m_128457_("radius"));
        this.f_19804_.m_135381_(DATA_OWNER_ID, (Object)compound.m_128451_("ownerId"));
        this.setExplosionCount(compound.m_128451_("explosionCount"));
        this.setDamage(compound.m_128457_("damage"));
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128350_("radius", this.getRadius());
        compound.m_128405_("ownerId", ((Integer)this.f_19804_.m_135370_(DATA_OWNER_ID)).intValue());
        compound.m_128405_("explosionCount", this.getExplosionCount());
        compound.m_128347_("damage", this.getDamage());
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.getRadius());
        buffer.writeInt(((Integer)this.f_19804_.m_135370_(DATA_OWNER_ID)).intValue());
        buffer.writeInt(this.getExplosionCount());
        buffer.writeDouble(this.getDamage());
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.setRadius(additionalData.readFloat());
        this.f_19804_.m_135381_(DATA_OWNER_ID, (Object)additionalData.readInt());
        this.setExplosionCount(additionalData.readInt());
        this.setDamage(additionalData.readFloat());
    }
}

