/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.rough_blade.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.entity.EntityDrive;
import net.exmo.rough_blade.init.RBEntityRegistry;
import net.exmo.rough_blade.repack.it.hurts.octostudios.perception.common.modules.trail.config.data.TrailConfigData;
import net.exmo.rough_blade.repack.it.hurts.octostudios.perception.common.modules.trail.misc.ITrailConfigProvider;
import net.exmo.rough_blade.utils.ExUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Unique;

public class FallenStarEntity
extends EntityDrive
implements ITrailConfigProvider {
    @Unique
    private TrailConfigData perception$trailData = new TrailConfigData();

    public FallenStarEntity(EntityType<? extends EntityDrive> p_37248_, Level p_37249_) {
        super(p_37248_, p_37249_);
    }

    public static FallenStarEntity createInstance(PlayMessages.SpawnEntity packet, Level worldIn) {
        return new FallenStarEntity(RBEntityRegistry.FALLEN_STAR_ENTITY, worldIn);
    }

    @Override
    public TrailConfigData getTrailConfigData() {
        return this.perception$trailData;
    }

    @Override
    public void setTrailConfigData(TrailConfigData data) {
        this.perception$trailData = data;
    }

    public int getTrailMaxLength() {
        return this.getTrailConfigData().getMaxPoints();
    }

    public int getTrailUpdateFrequency() {
        return this.getTrailConfigData().getUpdateFrequency();
    }

    public double getTrailScale() {
        return this.getTrailConfigData().getSize();
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        this.explode();
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        this.explode();
    }

    private void explode() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Entity owner = this.m_19749_();
            if (!(owner instanceof LivingEntity)) {
                return;
            }
            ItemStack mainHandItem = ((LivingEntity)owner).m_21205_();
            ISlashBladeState slashBlade = ExUtils.getSlashBlade(mainHandItem);
            if (slashBlade == null) {
                return;
            }
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 3, 0.5, 0.5, 0.5, 0.1);
            serverLevel.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 1.0f, 1.0f);
            int radius = 5;
            List entities = this.m_9236_().m_45933_((Entity)this, AABB.m_165882_((Vec3)this.m_20182_(), (double)(radius * 2), (double)(radius * 2), (double)(radius * 2)));
            for (Entity entity : entities) {
                double distance;
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                if (entity == this || entity == owner || !((distance = (double)entity.m_20270_((Entity)this)) <= (double)radius)) continue;
                float damage = (float)(3.0 * (20.0 + ((LivingEntity)owner).m_21133_(Attributes.f_22281_)) * (double)slashBlade.getRefine() * 0.02 * (1.0 - distance / (double)radius));
                livingEntity.m_6469_(new DamageSource((Holder)owner.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268515_), owner), damage);
                Vec3 direction = entity.m_20182_().m_82546_(this.m_20182_()).m_82541_();
                livingEntity.m_147240_(0.5, -direction.f_82479_, -direction.f_82481_);
            }
            this.m_146870_();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (Math.random() < 0.2) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123810_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 1, (double)0.05f, (double)0.05f, (double)0.05f, (double)0.05f);
            }
        }
    }

    public Vec3 getTrailPosition(float partialTicks) {
        Entity entity = (Entity)this;
        TrailConfigData data = this.getTrailConfigData();
        Vector3f offset = data.getPositionOffset();
        Vec3 entityPosition = (entity.f_19797_ > 1 ? entity.m_20318_(partialTicks) : entity.m_20182_()).m_82549_(entity.m_20184_().m_82541_().m_82490_((double)(-data.getMotionShift()))).m_82520_((double)offset.x(), (double)offset.y(), (double)offset.z());
        Player player = entity.m_20193_().m_45930_(entity, this.getTrailRenderDistance());
        if (player == null) {
            return entityPosition;
        }
        Vec3 playerPosition = player.m_20299_(partialTicks);
        entityPosition = entityPosition.m_82549_(entityPosition.m_82546_(playerPosition).m_82541_().m_82490_((double)data.getBackwardShift()));
        return entityPosition;
    }

    public boolean isTrailGrowing() {
        Entity entity = (Entity)this;
        return entity.m_20184_().m_82553_() >= (double)this.getTrailConfigData().getMinSpeed();
    }

    public boolean isTrailAlive() {
        Entity entity = (Entity)this;
        return entity.m_6084_();
    }

    public int getTrailFadeInColor() {
        return (int)Long.parseLong(this.getTrailConfigData().getFadeInColor().replace("#", ""), 16);
    }

    public int getTrailFadeOutColor() {
        return (int)Long.parseLong(this.getTrailConfigData().getFadeOutColor().replace("#", ""), 16);
    }

    public void renderTrail(float pTicks, PoseStack poseStack, MultiBufferSource bufferSourceList) {
        ITrailConfigProvider.super.renderTrail(pTicks, poseStack, bufferSourceList);
    }
}

