/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.rough_blade.content.specialEffects;

import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import net.exmo.rough_blade.Rough_blade;
import net.exmo.rough_blade.entity.ZhenLiEntity;
import net.exmo.rough_blade.init.RBEntityRegistry;
import net.exmo.rough_blade.network.ClearMingLiChangeMessage;
import net.exmo.rough_blade.network.MingLiChangeMessage;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber
public class MingLiEffectHandle {
    public static void addMingLi(LivingEntity livingEntity, int level) {
        CompoundTag persistentData = livingEntity.getPersistentData();
        int mingLiLevel = persistentData.m_128451_("MingLiLevel");
        int p128407 = mingLiLevel + level;
        persistentData.m_128405_("MingLiLevel", p128407);
        persistentData.m_128405_("MingLiTime", 400);
        MingLiEffectHandle.updatePlayerData(livingEntity, p128407);
    }

    public static void addZhenLi(LivingEntity livingEntity) {
        CompoundTag persistentData = livingEntity.getPersistentData();
        persistentData.m_128405_("ZhenLiTime", 400);
    }

    public static boolean isMingLi(LivingEntity livingEntity) {
        CompoundTag persistentData = livingEntity.getPersistentData();
        return persistentData.m_128441_("MingLiLevel") && persistentData.m_128451_("MingLiLevel") > 0;
    }

    public static boolean isZhenLi(LivingEntity livingEntity) {
        CompoundTag persistentData = livingEntity.getPersistentData();
        return persistentData.m_128441_("ZhenLiTime") && persistentData.m_128451_("ZhenLiTime") > 0;
    }

    public static void removeMingLi(LivingEntity livingEntity) {
        CompoundTag persistentData = livingEntity.getPersistentData();
        persistentData.m_128473_("MingLiLevel");
        persistentData.m_128473_("MingLiTime");
        MingLiEffectHandle.clearPlayerData(livingEntity);
    }

    public static void removeMingLi(LivingEntity livingEntity, int level) {
        CompoundTag persistentData = livingEntity.getPersistentData();
        persistentData.m_128405_("MingLiLevel", persistentData.m_128451_("MingLiLevel") - level);
        if (persistentData.m_128451_("MingLiLevel") <= 0) {
            persistentData.m_128473_("MingLiLevel");
            persistentData.m_128473_("MingLiTime");
        }
        MingLiEffectHandle.clearPlayerData(livingEntity);
    }

    public static void applyEffectTick(LivingEntity livingEntity, int level) {
        livingEntity.m_20334_(0.0, 0.01, 0.0);
        if (livingEntity.f_19797_ % 2 == 0) {
            if (MingLiEffectHandle.isMingLi(livingEntity)) {
                int amplifier = MingLiEffectHandle.getMingLi((Entity)livingEntity);
                if (amplifier <= 0) {
                    MingLiEffectHandle.removeMingLi(livingEntity);
                } else {
                    MingLiEffectHandle.addMingLi(livingEntity, -1);
                }
                Level level2 = livingEntity.m_9236_();
                if (level2 instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level2;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123746_, livingEntity.m_20185_(), livingEntity.m_20186_() + 1.0, livingEntity.m_20189_(), 8, 0.8, 0.8, 0.8, 0.8);
                    ZhenLiEntity zhenLiEntity = new ZhenLiEntity(RBEntityRegistry.ZLENTITY, livingEntity.m_9236_());
                    RandomSource random = serverLevel.f_46441_;
                    double xOffset = random.m_188500_() * 0.3;
                    double yOffset = (double)random.m_188501_() * 0.3;
                    double zOffset = (double)random.m_188501_() * 0.3;
                    zhenLiEntity.m_6034_(livingEntity.m_20185_() + xOffset, livingEntity.m_20186_() + 1.0 + yOffset, livingEntity.m_20189_() + zOffset);
                    zhenLiEntity.setAmp(amplifier % 12);
                    serverLevel.m_7967_((Entity)zhenLiEntity);
                    zhenLiEntity.f_19802_ = 0;
                    String string = livingEntity.getPersistentData().m_128461_("ZhenLiO");
                    if (string.length() < 10) {
                        return;
                    }
                    LivingEntity owner = (LivingEntity)serverLevel.m_8791_(UUID.fromString(string));
                    if (owner == null) {
                        return;
                    }
                    zhenLiEntity.m_5602_((Entity)owner);
                    DamageSource damageSource = new DamageSource((Holder)serverLevel.m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268724_), (Entity)owner);
                    int invulnerableTime = livingEntity.f_19802_;
                    livingEntity.f_19802_ = 0;
                    double attributeValue = owner.getPersistentData().m_128457_("ZhenLiDamage");
                    livingEntity.m_6469_(damageSource, (float)((double)(level + 1) * (attributeValue + 12.0) * 13.0 + (double)livingEntity.m_21233_() * 5.0E-4));
                    livingEntity.f_19802_ = invulnerableTime;
                }
            } else {
                livingEntity.getPersistentData().m_128473_("ZhenLiTime");
            }
        }
    }

    @SubscribeEvent
    public static void updateMingLi(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        CompoundTag persistentData1 = livingEntity.getPersistentData();
        if (persistentData1.m_128441_("ZhenLiTime")) {
            int zhenLiTime = persistentData1.m_128451_("ZhenLiTime");
            if (zhenLiTime > 0) {
                persistentData1.m_128405_("ZhenLiTime", zhenLiTime - 1);
                MingLiEffectHandle.applyEffectTick(livingEntity, 0);
            } else if (zhenLiTime == 0) {
                persistentData1.m_128473_("ZhenLiTime");
            }
        }
        if (MingLiEffectHandle.isMingLi(livingEntity)) {
            persistentData1.m_128405_("MingLiTime", persistentData1.m_128451_("MingLiTime") - 1);
            if (persistentData1.m_128451_("MingLiTime") <= 0) {
                if (persistentData1.m_128451_("MingLiLevel") <= 1) {
                    MingLiEffectHandle.removeMingLi(livingEntity);
                    MingLiEffectHandle.clearPlayerData(livingEntity);
                } else if (persistentData1.m_128451_("MingLiLevel") > 10) {
                    MingLiEffectHandle.addMingLi(livingEntity, -10);
                } else {
                    MingLiEffectHandle.removeMingLi(livingEntity);
                }
            }
        }
    }

    private static void clearPlayerData(LivingEntity livingEntity) {
        Level level = livingEntity.m_9236_();
        Vec3 _center = livingEntity.m_20182_();
        List<Entity> _entfound = level.m_6443_(Entity.class, new AABB(_center, _center).m_82400_(30.0), a -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.m_20238_(_center))).toList();
        for (Entity entityiterator : _entfound) {
            if (!(entityiterator instanceof ServerPlayer)) continue;
            ServerPlayer le = (ServerPlayer)entityiterator;
            ClearMingLiChangeMessage clearMingLiChangeMessage = new ClearMingLiChangeMessage(livingEntity.m_20148_());
            Rough_blade.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> le), (Object)clearMingLiChangeMessage);
        }
    }

    private static void updatePlayerData(LivingEntity livingEntity, int level1) {
        Level level = livingEntity.m_9236_();
        Vec3 _center = livingEntity.m_20182_();
        List<Entity> _entfound = level.m_6443_(Entity.class, new AABB(_center, _center).m_82400_(30.0), a -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.m_20238_(_center))).toList();
        for (Entity entityiterator : _entfound) {
            if (!(entityiterator instanceof ServerPlayer)) continue;
            ServerPlayer le = (ServerPlayer)entityiterator;
            MingLiChangeMessage mingLiChangeMessage = new MingLiChangeMessage(livingEntity.m_20148_(), level1);
            Rough_blade.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> le), (Object)mingLiChangeMessage);
        }
    }

    @SubscribeEvent
    public static void Death(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (MingLiEffectHandle.isMingLi(livingEntity)) {
            MingLiEffectHandle.removeMingLi(livingEntity);
        }
    }

    public static int getMingLi(Entity entity) {
        CompoundTag persistentData;
        int mingLiLevel;
        LivingEntity livingEntity;
        if (entity instanceof LivingEntity && MingLiEffectHandle.isMingLi(livingEntity = (LivingEntity)entity) && (mingLiLevel = (persistentData = livingEntity.getPersistentData()).m_128451_("MingLiLevel")) > 0) {
            return mingLiLevel;
        }
        return 0;
    }
}

