/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.rough_blade.content.specialEffects;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.exmo.rough_blade.Rough_blade;
import net.exmo.rough_blade.network.CherryBlossomMarkSyncMessage;
import net.exmo.rough_blade.network.LSVARB;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class CherryBlossomMarkHandle {
    public static final int MAX_STACKS = 20;
    public static Map<UUID, Integer> CherryBlossomMarkMap = new HashMap<UUID, Integer>();

    private static void updatePlayerData(LivingEntity livingEntity, int level1) {
        Level level = livingEntity.m_9236_();
        Vec3 _center = livingEntity.m_20182_();
        List<Entity> _entfound = level.m_6443_(Entity.class, new AABB(_center, _center).m_82400_(30.0), a -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.m_20238_(_center))).toList();
        for (Entity entityiterator : _entfound) {
            if (!(entityiterator instanceof ServerPlayer)) continue;
            ServerPlayer le = (ServerPlayer)entityiterator;
            CherryBlossomMarkSyncMessage mingLiChangeMessage = new CherryBlossomMarkSyncMessage(livingEntity.m_20148_(), level1);
            Rough_blade.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> le), (Object)mingLiChangeMessage);
        }
    }

    public static void addCherryBlossomMark(LivingEntity target, int stacks) {
        CompoundTag persistentData = target.getPersistentData();
        int currentStacks = persistentData.m_128451_("CherryBlossomMark");
        int newStacks = Math.min(currentStacks + stacks, 20);
        persistentData.m_128405_("CherryBlossomMark", newStacks);
        persistentData.m_128405_("CherryBlossomMarkTime", 600);
        CherryBlossomMarkHandle.updatePlayerData(target, newStacks);
    }

    public static void removeCherryBlossomMark(LivingEntity target) {
        CompoundTag persistentData = target.getPersistentData();
        persistentData.m_128473_("CherryBlossomMark");
        persistentData.m_128473_("CherryBlossomMarkTime");
        CherryBlossomMarkHandle.updatePlayerData(target, 0);
    }

    public static boolean hasCherryBlossomMark(LivingEntity target) {
        CompoundTag persistentData = target.getPersistentData();
        return persistentData.m_128441_("CherryBlossomMark") && persistentData.m_128451_("CherryBlossomMark") > 0;
    }

    public static int getCherryBlossomMarkStacks(LivingEntity target) {
        CompoundTag persistentData = target.getPersistentData();
        if (CherryBlossomMarkHandle.hasCherryBlossomMark(target)) {
            return persistentData.m_128451_("CherryBlossomMark");
        }
        return 0;
    }

    public static void updateCherryBlossomMark(LivingEntity target) {
        int markTime;
        CompoundTag persistentData = target.getPersistentData();
        if (persistentData.m_128441_("CherryBlossomMarkTime") && (markTime = persistentData.m_128451_("CherryBlossomMarkTime")) > 0) {
            persistentData.m_128405_("CherryBlossomMarkTime", markTime - 1);
            if (persistentData.m_128451_("CherryBlossomMarkTime") <= 0) {
                CherryBlossomMarkHandle.removeCherryBlossomMark(target);
            }
        }
    }

    public static void onSimpleLoveAttack(Player attacker, LivingEntity target, double probability) {
        if (attacker.m_9236_().f_46441_.m_188500_() < probability) {
            CherryBlossomMarkHandle.addCherryBlossomMark(target, 1);
            CherryBlossomMarkHandle.increaseSakuraValue(attacker, 5);
            Level level = target.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_276452_, target.m_20185_(), target.m_20186_() + (double)target.m_20206_() / 2.0, target.m_20189_(), 10, 0.5, 0.5, 0.5, 0.02);
            }
        }
    }

    public static void increaseSakuraValue(Player player, int amount) {
        LSVARB.playerSimpleVar sakuraVar;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        LSVARB.PlayerVariables playerVariables = (LSVARB.PlayerVariables)serverPlayer.getCapability(LSVARB.PLAYER_VARIABLES_CAPABILITY, null).orElse(null);
        if (playerVariables != null && (sakuraVar = (LSVARB.playerSimpleVar)playerVariables.playerSimpleVars.stream().filter(var -> "cherry_blossom_sakura_value".equals(var.name)).findFirst().orElse(null)) != null) {
            int currentValue = (Integer)sakuraVar.getValue();
            int newValue = Math.min(currentValue + amount, 100);
            sakuraVar.setValue(newValue);
            playerVariables.syncPlayerVariables((Entity)player);
        }
    }

    public static void decreaseSakuraValue(Player player, int amount) {
        LSVARB.playerSimpleVar sakuraVar;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        LSVARB.PlayerVariables playerVariables = (LSVARB.PlayerVariables)serverPlayer.getCapability(LSVARB.PLAYER_VARIABLES_CAPABILITY, null).orElse(null);
        if (playerVariables != null && (sakuraVar = (LSVARB.playerSimpleVar)playerVariables.playerSimpleVars.stream().filter(var -> "cherry_blossom_sakura_value".equals(var.name)).findFirst().orElse(null)) != null) {
            int currentValue = (Integer)sakuraVar.getValue();
            int newValue = Math.max(currentValue - amount, 0);
            sakuraVar.setValue(newValue);
            playerVariables.syncPlayerVariables((Entity)player);
        }
    }

    public static int getSakuraValue(Player player) {
        LSVARB.playerSimpleVar sakuraVar;
        LSVARB.PlayerVariables playerVariables = (LSVARB.PlayerVariables)player.getCapability(LSVARB.PLAYER_VARIABLES_CAPABILITY, null).orElse(null);
        if (playerVariables != null && (sakuraVar = (LSVARB.playerSimpleVar)playerVariables.playerSimpleVars.stream().filter(var -> "cherry_blossom_sakura_value".equals(var.name)).findFirst().orElse(null)) != null) {
            return (Integer)sakuraVar.getValue();
        }
        return 0;
    }

    public static int interactWithMark(Player attacker, LivingEntity target) {
        if (CherryBlossomMarkHandle.hasCherryBlossomMark(target)) {
            int stacks = CherryBlossomMarkHandle.getCherryBlossomMarkStacks(target);
            CherryBlossomMarkHandle.removeCherryBlossomMark(target);
            CherryBlossomMarkHandle.increaseSakuraValue(attacker, stacks * 2);
            return stacks;
        }
        return 0;
    }
}

